/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.AlreadyOpenException;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FileOpenSelector;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerRegistry;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.ui.AWTExceptionHandler;
import edu.rice.cs.drjava.ui.ClasspathFilter;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.SimpleInteractionsWindow;
import edu.rice.cs.drjava.ui.SplashScreen;
import edu.rice.cs.util.OutputStreamRedirector;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ToolsJarClassLoader;
import edu.rice.cs.util.newjvm.ExecJVM;
import edu.rice.cs.util.swing.Utilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.java.plaf.LookAndFeelPatchManager;

public class DrJava
implements OptionConstants {
    public static final int FULL_JAVA = 0;
    public static final int ELEMENTARY_LEVEL = 1;
    public static final int INTERMEDIATE_LEVEL = 2;
    public static final int ADVANCED_LEVEL = 3;
    public static final String[] LANGUAGE_LEVEL_EXTENSIONS = new String[]{".java", ".dj0", ".dj1", ".dj2"};
    public static final String TEST_DEBUGGER_CLASS = "com.sun.jdi.Bootstrap";
    private static final PrintStream _consoleOut = System.out;
    private static final PrintStream _consoleErr = System.err;
    private static String[] _filesToOpen = new String[0];
    private static boolean _attemptingAugmentedClasspath = false;
    private static boolean _showDrJavaDebugConsole = false;
    private static boolean _usingJSR14v20 = false;
    private static SimpleInteractionsWindow _debugConsole = null;
    private static File _propertiesFile = new File(System.getProperty("user.home"), ".drjava");
    private static FileConfiguration _config = DrJava._initConfig();

    public static File getPropertiesFile() {
        return _propertiesFile;
    }

    public static FileConfiguration getConfig() {
        return _config;
    }

    public static void main(String[] args) {
        final SplashScreen splash = new SplashScreen();
        splash.setVisible(true);
        splash.repaint();
        DrJava.createAndShowGUI(args);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                splash.dispose();
            }
        });
    }

    private static void createAndShowGUI(String[] args) {
        try {
            if (DrJava.handleCommandLineArgs(args)) {
                String currLAFName;
                String configLAFName = _config.getSetting(LOOK_AND_FEEL);
                if (!configLAFName.equals(currLAFName = UIManager.getLookAndFeel().getClass().getName())) {
                    UIManager.setLookAndFeel(configLAFName);
                }
                LookAndFeelPatchManager.initialize();
                _usingJSR14v20 = DrJava.checkForJSR14v20() && !System.getProperty("java.specification.version").equals("1.5");
                DrJava.checkForCompilersAndDebugger(args);
                final MainFrame mf = new MainFrame();
                AWTExceptionHandler.setFrame(mf);
                System.setProperty("sun.awt.exception.handler", "edu.rice.cs.drjava.ui.AWTExceptionHandler");
                DrJava._openCommandLineFiles(mf, _filesToOpen);
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        mf.setVisible(true);
                    }
                });
                System.setOut(new PrintStream(new OutputStreamRedirector(){

                    public void print(String s) {
                        mf.getModel().systemOutPrint(s);
                    }
                }));
                System.setErr(new PrintStream(new OutputStreamRedirector(){

                    public void print(String s) {
                        mf.getModel().systemErrPrint(s);
                    }
                }));
                if (_showDrJavaDebugConsole) {
                    DrJava.showDrJavaDebugConsole(mf);
                }
            }
        }
        catch (Throwable t) {
            _consoleErr.println(t.getClass().getName() + ": " + t.getMessage());
            t.printStackTrace(_consoleErr);
            System.out.println("error thrown");
            new AWTExceptionHandler().handle(t);
        }
    }

    static boolean handleCommandLineArgs(String[] args) {
        int firstFile = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-config")) {
                if (args.length > i + 1) {
                    DrJava.setPropertiesFile(args[i + 1]);
                    firstFile = i + 2;
                    _config = DrJava._initConfig();
                    continue;
                }
                firstFile = i + 1;
                continue;
            }
            if (args[i].equals("-attemptingAugmentedClasspath")) {
                _attemptingAugmentedClasspath = true;
                continue;
            }
            if (args[i].equals("-debugConsole")) {
                _showDrJavaDebugConsole = true;
                continue;
            }
            if (!args[i].equals("-help") && !args[i].equals("-?")) continue;
            DrJava.displayUsage();
            return false;
        }
        int numFiles = args.length - firstFile;
        _filesToOpen = new String[numFiles];
        System.arraycopy(args, firstFile, _filesToOpen, 0, numFiles);
        return true;
    }

    static void displayUsage() {
        StringBuffer buf = new StringBuffer();
        buf.append("Usage: java -jar drjava.jar [OPTIONS] [FILES]\n\n");
        buf.append("where options include:\n");
        buf.append("  -config [FILE]        to use a custom config file\n");
        buf.append("  -help | -?            print this help message\n");
        _consoleOut.print(buf.toString());
    }

    static void setPropertiesFile(String filename) {
        if (!filename.endsWith(".java")) {
            _propertiesFile = new File(filename);
        }
    }

    static FileConfiguration _initConfig() throws IllegalStateException {
        try {
            _propertiesFile.createNewFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        FileConfiguration config = new FileConfiguration(_propertiesFile);
        try {
            config.loadConfiguration();
        }
        catch (Exception e) {
            config.resetToDefaults();
            config.storeStartupException(e);
        }
        _config = config;
        return config;
    }

    protected static void _saveConfig() {
        try {
            DrJava.getConfig().saveConfiguration();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not save the location of tools.jar in \nthe '.drjava' file in your home directory. \nAnother process may be using the file.\n\n" + e, "Could Not Save Changes", 0);
        }
    }

    static void openCommandLineFiles(final MainFrame mf, final String[] filesToOpen) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                DrJava._openCommandLineFiles(mf, filesToOpen);
            }
        });
    }

    private static void _openCommandLineFiles(MainFrame mf, String[] filesToOpen) {
        for (int i = 0; i < filesToOpen.length; ++i) {
            String currFileName = filesToOpen[i];
            boolean isProjectFile = currFileName.endsWith(".pjt");
            final File file = new File(currFileName).getAbsoluteFile();
            FileOpenSelector command = new FileOpenSelector(){

                public File getFile() {
                    return file;
                }

                public File[] getFiles() {
                    return new File[]{file};
                }
            };
            try {
                if (isProjectFile) {
                    mf.openProject(command);
                    continue;
                }
                mf.getModel().openFile(command);
                continue;
            }
            catch (FileNotFoundException ex) {
                continue;
            }
            catch (SecurityException se) {
                continue;
            }
            catch (AlreadyOpenException aoe) {
                continue;
            }
            catch (FileMovedException aoe) {
                continue;
            }
            catch (IOException ex) {
                continue;
            }
            catch (Exception ex) {
                throw new UnexpectedException(ex);
            }
        }
    }

    private static boolean checkJSR14JarForClass(String checkClass, String msg, String title) {
        File jsr14 = _config.getSetting(JSR14_LOCATION);
        if (jsr14 != FileOption.NULL_FILE) {
            try {
                JarFile jsr14jar = new JarFile(jsr14);
                if (jsr14jar.getJarEntry(checkClass) != null) {
                    if (System.getProperty("java.specification.version").equals("1.3") || System.getProperty("java.runtime.version").startsWith("1.4.0")) {
                        if (!_attemptingAugmentedClasspath) {
                            JOptionPane.showMessageDialog(null, msg, title, 2);
                        }
                        return false;
                    }
                    return true;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean checkForJSR14v24() {
        String fs = "/";
        String checkClass = "com" + fs + "sun" + fs + "javadoc" + fs + "ParameterizedType.class";
        String msg = "The JSR-14 v2.4 compiler is only compatible with JDK 1.4.2.\nIt will not be available in your list of compilers.";
        String title = "Cannot Load JSR-14 v2.4";
        return DrJava.checkJSR14JarForClass(checkClass, msg, title);
    }

    public static boolean checkForJSR14v20() {
        String fs = "/";
        String checkClass = "com" + fs + "sun" + fs + "tools" + fs + "javac" + fs + "comp" + fs + "Check.class";
        String msg = "The JSR-14 v2.x compiler is not compatible with JDK 1.3 or 1.4.0.\nIt will not be available in your list of compilers.";
        String title = "Cannot Load JSR-14 v2.x";
        return DrJava.checkJSR14JarForClass(checkClass, msg, title);
    }

    static void checkForCompilersAndDebugger(String[] args) {
        if (_attemptingAugmentedClasspath) {
            return;
        }
        boolean restartForToolsJar = false;
        if (DrJava.hasAvailableCompiler()) {
            restartForToolsJar = DrJava.hasAvailableDebugger() ? false : (DrJava.classLoadersCanFindDebugger() ? true : DrJava.promptForToolsJar(false, true));
        } else if (DrJava.hasAvailableDebugger()) {
            DrJava.promptForToolsJar(true, false);
        } else {
            restartForToolsJar = DrJava.classLoadersCanFindDebugger() ? true : DrJava.promptForToolsJar(true, true);
        }
        DrJava.restartIfNecessary(restartForToolsJar, args);
    }

    public static boolean hasAvailableCompiler() {
        return !CompilerRegistry.ONLY.isNoCompilerAvailable();
    }

    public static boolean hasAvailableDebugger() {
        try {
            Class.forName(TEST_DEBUGGER_CLASS);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (UnsupportedClassVersionError ucve) {
            return false;
        }
    }

    public static boolean classLoadersCanFindDebugger() {
        File jar = DrJava.getConfig().getSetting(JAVAC_LOCATION);
        if (jar != FileOption.NULL_FILE) {
            try {
                URL[] urls = new URL[]{jar.toURL()};
                URLClassLoader loader = new URLClassLoader(urls);
                loader.loadClass(TEST_DEBUGGER_CLASS);
                return true;
            }
            catch (ClassNotFoundException e) {
            }
            catch (UnsupportedClassVersionError ucve) {
                return false;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        ToolsJarClassLoader loader = new ToolsJarClassLoader();
        try {
            loader.loadClass(TEST_DEBUGGER_CLASS);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (UnsupportedClassVersionError ucve) {
            return false;
        }
    }

    public static boolean bootClasspathHasJSR14v24() {
        try {
            Class.forName("com.sun.javadoc.ParameterizedType");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean bootClasspathHasJSR14v20() {
        try {
            Class.forName("java.lang.Enum");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void restartIfNecessary(boolean forToolsJar, String[] args) {
        block7: {
            String[] jvmArgs;
            if (!(forToolsJar || _usingJSR14v20 && !DrJava.bootClasspathHasJSR14v20())) {
                return;
            }
            String pathSep = System.getProperty("path.separator");
            String classpath = System.getProperty("java.class.path");
            String[] classArgs = new String[args.length + 1];
            System.arraycopy(args, 0, classArgs, 0, args.length);
            classArgs[args.length] = "-attemptingAugmentedClasspath";
            if (_usingJSR14v20) {
                String jsr14 = _config.getSetting(JSR14_LOCATION).getAbsolutePath();
                jvmArgs = new String[]{"-Xbootclasspath/p:" + jsr14};
            } else {
                jvmArgs = new String[]{};
            }
            if (forToolsJar) {
                classpath = classpath + pathSep;
                File toolsFromConfig = DrJava.getConfig().getSetting(JAVAC_LOCATION);
                if (toolsFromConfig != FileOption.NULL_FILE) {
                    classpath = classpath + toolsFromConfig.getAbsolutePath() + pathSep;
                }
                classpath = classpath + ToolsJarClassLoader.getToolsJarClasspath();
            }
            try {
                ExecJVM.runJVM("edu.rice.cs.drjava.DrJava", classArgs, classpath, jvmArgs);
                System.exit(0);
            }
            catch (IOException ioe) {
                String[] text = new String[]{"DrJava was unable to load its debugger.  Would you ", "like to start DrJava without a debugger?", "\nReason: " + ioe.toString()};
                int result = JOptionPane.showConfirmDialog(null, text, "Could Not Load Debugger", 0);
                if (result == 0) break block7;
                System.exit(0);
            }
        }
    }

    public static boolean usingJSR14v20() {
        return _usingJSR14v20;
    }

    public static boolean promptForToolsJar(boolean needCompiler, boolean needDebugger) {
        boolean restartRequired = false;
        String[] text = needDebugger && !needCompiler ? new String[]{"DrJava cannot get the necessary information from the", "current Java SDK's 'tools.jar' file to start the", "debugger. Would you like to specify the 'tools.jar'", "file for the version of java you are using to run", "DrJava at this time?", "(If you say 'No', DrJava might be unable to debug", "programs and the debug menu will not appear.)"} : new String[]{"DrJava cannot find the Java SDK's 'tools.jar' file. ", "This file is necessary to compile files and use the ", "debugger.  It is generally located in the 'lib' ", "subdirectory of your Java installation directory. ", "Would you like to specify its location? ", "(If you say 'No', DrJava might be unable to compile ", "or debug programs.)"};
        int result = JOptionPane.showConfirmDialog(null, text, "Locate 'tools.jar'?", 0);
        if (result == 0) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new ClasspathFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String ext = 7.getExtension(f);
                    return ext != null && ext.equals("jar");
                }

                public String getDescription() {
                    return "Jar Files";
                }
            });
            do {
                CompilerInterface[] compilers;
                File jar;
                if (chooser.showOpenDialog(null) != 0 || (jar = chooser.getSelectedFile()) == null) continue;
                DrJava.getConfig().setSetting(JAVAC_LOCATION, jar);
                if (needCompiler && (compilers = CompilerRegistry.ONLY.getAvailableCompilers())[0] != NoCompilerAvailable.ONLY) {
                    needCompiler = false;
                    CompilerRegistry.ONLY.setActiveCompiler(compilers[0]);
                    DrJava._saveConfig();
                }
                if (!needDebugger || !DrJava.classLoadersCanFindDebugger()) continue;
                needDebugger = false;
                restartRequired = true;
                DrJava._saveConfig();
            } while ((needCompiler || needDebugger) && DrJava._userWantsToPickAgain(needDebugger && !needCompiler));
        }
        return restartRequired;
    }

    private static boolean _userWantsToPickAgain(boolean justDebugger) {
        String[] text = justDebugger ? new String[]{"DrJava was still unable to load the debugger from the", "'tools.jar' file you located. Would you like to pick again?", "The 'tools.jar' file is generally located in the 'lib'", "subdirectory under your JDK installation directory.", "(If you say 'No', DrJava might be unable to debug programs,", "in which case the 'Debugger' menu will not be displayed.)"} : new String[]{"The file you chose did not appear to be the correct 'tools.jar'. ", "(Your choice might be an incompatible version of the file.) ", "Would you like to pick again?  The 'tools.jar' file is ", "generally located in the 'lib' subdirectory under your ", "JDK installation directory.", "(If you say 'No', DrJava might be unable to compile or ", "debug programs.)"};
        int result = JOptionPane.showConfirmDialog(null, text, "Locate 'tools.jar'?", 0);
        return result == 0;
    }

    public static void showDrJavaDebugConsole(MainFrame mf) {
        if (_debugConsole == null) {
            _debugConsole = new SimpleInteractionsWindow("DrJava Debug Console"){

                protected void close() {
                    this.dispose();
                    _debugConsole = null;
                }
            };
            _debugConsole.defineConstant("mainFrame", mf);
            _debugConsole.defineConstant("model", mf.getModel());
            _debugConsole.defineConstant("config", _config);
            _debugConsole.setInterpreterPrivateAccessible(true);
            _debugConsole.setVisible(true);
        } else {
            _debugConsole.toFront();
        }
    }

    public static PrintStream consoleErr() {
        return _consoleErr;
    }

    public static PrintStream consoleOut() {
        return _consoleOut;
    }
}

