/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MazeGUI
extends JFrame {
    JLabel[][] labels;
    JPanel mazePanel = new JPanel();
    Box JenBox = new Box(1);
    JLabel JenScore = new JLabel("   0", 0);
    Box SteveBox = new Box(1);
    JLabel SteveScore = new JLabel("   0", 0);
    Box southBox = new Box(1);
    JLabel sproutsLeft = new JLabel("        Brussel sprouts left: 5555");
    Box northBox = new Box(1);
    JLabel endOfGame = new JLabel("        Steve won!");
    public Maze maze;

    public MazeGUI(Maze maze) {
        this.maze = maze;
        Container con = this.getContentPane();
        this.JenBox.add(new JLabel("  Jen "));
        this.JenBox.add(new JLabel("  ate "));
        this.JenBox.add(this.JenScore);
        this.SteveBox.add(new JLabel(" Steve "));
        this.SteveBox.add(new JLabel("  ate "));
        this.SteveBox.add(this.SteveScore);
        con.add((Component)this.JenBox, "West");
        con.add((Component)this.SteveBox, "East");
        this.northBox.add(this.endOfGame);
        this.northBox.add(new JLabel(" "));
        con.add((Component)this.northBox, "North");
        this.southBox.add(new JLabel(" "));
        this.southBox.add(this.sproutsLeft);
        con.add((Component)this.southBox, "South");
        this.mazePanel.setLayout(new GridLayout(maze.nRows(), maze.nCols()));
        this.labels = new JLabel[maze.nRows()][maze.nCols()];
        for (int r = 0; r != this.labels.length; ++r) {
            for (int c = 0; c != this.labels[0].length; ++c) {
                this.labels[r][c] = new JLabel("" + '#');
                this.mazePanel.add(this.labels[r][c]);
            }
        }
        this.update();
        con.add((Component)this.mazePanel, "Center");
        this.addKeyListener(new MazeKeyListener(this, maze));
        this.pack();
        this.show();
    }

    public void update() {
        for (int r = 0; r != this.labels.length; ++r) {
            for (int c = 0; c != this.labels[0].length; ++c) {
                this.labels[r][c].setText(this.visualChar(r, c));
            }
        }
        this.JenScore.setText("  " + this.maze.JenTheRat.getNumSprouts());
        this.SteveScore.setText("  " + this.maze.SteveTheRat.getNumSprouts());
        this.sproutsLeft.setText("        Brussel sprouts left: " + this.maze.sproutsLeft());
        this.endOfGame.setText("  ");
        if (this.maze.sproutsLeft() != 0) {
            return;
        }
        this.endOfGame.setText("        It's a tie");
        if (this.maze.JenTheRat.getNumSprouts() > this.maze.SteveTheRat.getNumSprouts()) {
            this.endOfGame.setText("        Jen won!");
        } else if (this.maze.JenTheRat.getNumSprouts() < this.maze.SteveTheRat.getNumSprouts()) {
            this.endOfGame.setText("        Steve won!");
        }
    }

    public String visualChar(int r, int c) {
        int ch = this.maze.getChar(r, c);
        if (this.maze.JenTheRat.getRow() == r && this.maze.JenTheRat.getCol() == c) {
            ch = 74;
        }
        if (this.maze.SteveTheRat.getRow() == r && this.maze.SteveTheRat.getCol() == c) {
            ch = 83;
        }
        return Character.toString((char)ch);
    }
}

