/*
 * Decompiled with CFR 0.152.
 */
public class Maze {
    public static final char WALL = '#';
    public static final char HALL = '.';
    public static final char SPROUT = '@';
    public static final char STEVE_CHAR = 'S';
    public static final char JEN_CHAR = 'J';
    public static final int LEFT = -1;
    public static final int RIGHT = 1;
    public static final int NO_CHANGE = 0;
    public static final int UP = -1;
    public static final int DOWN = 1;
    public final Rat JenTheRat = new Rat();
    public final Rat SteveTheRat = new Rat();
    private char[][] b;
    private int numberSprouts;

    public Maze(char[][] b) {
        this.b = b;
        this.numberSprouts = 0;
        for (int k = 0; k != b.length; ++k) {
            for (int j = 0; j != b[0].length; ++j) {
                if (b[k][j] == 'J') {
                    this.JenTheRat.move(k, j);
                    b[k][j] = 46;
                    continue;
                }
                if (b[k][j] == 'S') {
                    this.SteveTheRat.move(k, j);
                    b[k][j] = 46;
                    continue;
                }
                if (b[k][j] != '@') continue;
                ++this.numberSprouts;
            }
        }
    }

    public char getChar(int r, int c) {
        return this.b[r][c];
    }

    public int nRows() {
        return this.b.length;
    }

    public int nCols() {
        return this.b[0].length;
    }

    public String toString() {
        if (this.b == null) {
            return "";
        }
        String res = "";
        for (int k = 0; k != this.b.length; ++k) {
            for (int j = 0; j != this.b[0].length; ++j) {
                res = res + this.b[k][j];
            }
            res = res + "\n";
        }
        return res;
    }

    public int sproutsLeft() {
        return this.numberSprouts;
    }

    public void move(Rat r, int vert, int horiz) {
        int newC;
        int newR = r.getRow() + vert;
        if (this.b[newR][newC = r.getCol() + horiz] == '#') {
            return;
        }
        r.move(newR, newC);
        if (this.b[newR][newC] == '@') {
            r.eatSprout();
            --this.numberSprouts;
            this.b[r.getRow()][r.getCol()] = 46;
        }
    }
}

