/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public abstract class JLiveWindow {
    private static final int TOTAL_MAX_FIELDS = 1;
    private static int MAX_FIELDS;
    private static final int MAX_FIELD_LENGTH = 20;
    private static final int ROW_SEPARATION = 10;
    private static final int COLUMN_SEPARATION = 15;
    private TextField[] intFields;
    private TextField[] stringFields;
    private int numInts = 1;
    private int numStrings = 1;
    private TextArea instructions = new TextArea("0: Read games from file given by user, copy them to the working set.\n1: Clear output area and then print the working set there.\n2: Sort the working set by total score.\n3: Sort the working set by person's name.\n4: Append statistics of the working set (min, ave, max score) to the output area.\n5: Set the working set to all the games read in earlier.\n6: Restrict the working set to games of person named in first String field\n7: Restrict the working set to games with scores >= 200\nAfter each command except 1 and 4, clear output area and put working set there;");
    protected TextArea output = new TextArea("Your output will appear here", 20, 60);
    private Frame frame = new Frame("JLiveWindow");

    public JLiveWindow() {
        MAX_FIELDS = 1;
        this.intFields = new TextField[MAX_FIELDS];
        this.stringFields = new TextField[MAX_FIELDS];
        this.createFields();
        this.instructions.setEditable(false);
        this.output.setEditable(false);
        this.output.setFont(new Font("Monospaced", 0, 10));
        this.frame.addWindowListener(new 1());
        this.frame.add("North", this.createPanel());
        this.frame.add("Center", this.instructions);
        this.frame.add("South", this.output);
    }

    private void createFields() {
        int i = 0;
        while (i < MAX_FIELDS) {
            this.intFields[i] = new TextField(20);
            this.stringFields[i] = new TextField(20);
            ++i;
        }
    }

    private Panel createPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3, 15, 0));
        if (this.numInts > 0) {
            panel.add(this.createFieldsPanel(this.numInts, this.intFields, "Integer field"));
        }
        if (this.numStrings > 0) {
            panel.add(this.createFieldsPanel(this.numStrings, this.stringFields, "String field"));
        }
        panel.add(this.createActionButton());
        return panel;
    }

    private Panel createFieldsPanel(int n, TextField[] a, String t) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(MAX_FIELDS + 1, 1, 0, 10));
        if (n > 0) {
            panel.add(new Label(t, 1));
        }
        int i = 0;
        while (i < n) {
            panel.add(a[i]);
            ++i;
        }
        int i2 = n + 1;
        while (i2 < MAX_FIELDS) {
            panel.add(a[i2]);
            a[i2].setVisible(false);
            ++i2;
        }
        return panel;
    }

    private Button createActionButton() {
        Button button = new Button("Ready!");
        button.addActionListener(new 2());
        return button;
    }

    public void showWindow() {
        this.frame.pack();
        ((Component)this.frame).setVisible(true);
    }

    abstract Object buttonPressed();

    public int getIntField(int f) {
        try {
            return Integer.parseInt(this.intFields[f].getText());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            this.intFields[f].setText(this.intFields[f].getText() + ": NOT AN INTEGER, 0 used");
            return 0;
        }
    }

    public void setIntField(int f, int m) {
        try {
            this.intFields[f].setText(String.valueOf(m));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public String getStringField(int f) {
        try {
            return this.stringFields[f].getText();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public void setStringField(int f, String s) {
        try {
            this.stringFields[f].setText(String.valueOf(s));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JLiveWindow.this.buttonPressed();
        }

        /* synthetic */ 2() {
        }
    }
}

