/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class ThumbnailPanel
extends JPanel {
    public static final int SIZE = 60;
    public static final int WIDTH_PADDING = 10;
    private static Font labelFont = new Font("Helvetica", 1, 9);
    private Image im;
    private String f;
    private ImageHandler imageHand;
    private FontMetrics labelFontMetrics;

    public ThumbnailPanel(Image v, String fpath, ImageHandler imageHand) {
        this.im = v;
        this.imageHand = imageHand;
        this.f = fpath;
        int k = this.f.lastIndexOf("/");
        if (k != -1) {
            this.f = this.f.substring(k + 1);
        }
        this.addMouseListener(new LocalMouseListener());
    }

    public int newGetHeight() {
        if (this.im == null) {
            return 60;
        }
        return 60 * this.im.getHeight(this) / this.im.getWidth(this);
    }

    public void setImage(Image im) {
        this.im = im;
    }

    public int newGetWidth() {
        return 60;
    }

    public void paint(Graphics g) {
        if (this.labelFontMetrics == null) {
            this.labelFontMetrics = g.getFontMetrics(labelFont);
        }
        g.drawImage(this.im, 0, 0, this.newGetWidth(), this.newGetHeight(), 0, 0, this.im.getWidth(this), this.im.getHeight(this), this);
        g.setFont(labelFont);
        Color c = g.getColor();
        if (this == this.imageHand.getHighlighted()) {
            g.setColor(Color.RED);
        }
        g.drawString(this.f, 0, this.newGetHeight() + this.labelFontMetrics.getAscent() + 1);
        g.setColor(c);
    }

    public Dimension getPreferredSize() {
        int width = this.newGetWidth() + 10;
        return new Dimension(width, this.newGetHeight() + 15);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.newGetWidth() + 10, this.newGetHeight() + 15);
    }

    class LocalMouseListener
    extends MouseInputAdapter {
        LocalMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            ThumbnailPanel.this.imageHand.highlightThumbnail((ThumbnailPanel)e.getSource());
        }
    }
}

