/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.image.PixelGrabber;

public class ImageMap {
    Image image;
    int rows;
    int cols;
    int[] map;

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int[] getMap() {
        return this.map;
    }

    public void setRows(int r) {
        this.rows = r;
    }

    public void setCols(int c) {
        this.cols = c;
    }

    public ImageMap(Image i, int r, int c) {
        this.image = i;
        this.rows = r;
        this.cols = c;
        this.map = new int[this.rows * this.cols];
        if (this.image == null) {
            return;
        }
        PixelGrabber pg = new PixelGrabber(this.image, 0, 0, this.cols, this.rows, this.map, 0, this.cols);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.out.println("pixel grab interrupted!");
            return;
        }
    }

    public ImageMap copy() {
        return new ImageMap(this.image, this.rows, this.cols);
    }

    public int getPixel(int row, int col) {
        return this.map[row * this.cols + col];
    }

    public void setPixel(int row, int col, int pixValue) {
        this.map[row * this.cols + col] = pixValue;
    }

    public void swapPixels(int a, int b, int i, int j) {
        int temp = this.getPixel(a, b);
        this.setPixel(a, b, this.getPixel(i, j));
        this.setPixel(i, j, temp);
    }
}

