/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;

public class ImageMaintainer {
    private Image image;
    private String fileName;
    private ImagePanel imagePanel;
    private ImageMap imageMap;
    private ThumbnailPanel thumbnail;
    private ImageHandler imageHand;
    private ImageMap originalMap;

    public ImageMaintainer(Image im, String fileName, ImageHandler imageHand) {
        this.image = im;
        this.fileName = fileName;
        this.imageHand = imageHand;
        this.thumbnail = new ThumbnailPanel(im, fileName, imageHand);
        this.imagePanel = new ImagePanel(this.image);
        this.imageMap = new ImageMap(this.image, this.image.getHeight(this.imagePanel), this.image.getWidth(this.imagePanel));
        this.originalMap = this.imageMap.copy();
    }

    public Image getImage() {
        return this.image;
    }

    public ImagePanel getImagePanel() {
        return this.imagePanel;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ImageMap getImageMap() {
        return this.imageMap;
    }

    public ThumbnailPanel getThumbnail() {
        return this.thumbnail;
    }

    public static Image getImage(String f, JFrame jframe) {
        Image image = null;
        try {
            image = jframe.getToolkit().getImage(new URL("file:" + f));
        }
        catch (MalformedURLException e) {
            System.err.println("Bad URL!");
            return null;
        }
        MediaTracker tracker = new MediaTracker(jframe);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            return null;
        }
        return image;
    }

    public static String getImageName() {
        FileDialog fd = new FileDialog(new Frame(), "Open File", 0);
        ((Component)fd).setVisible(true);
        if (fd.getFile() == null) {
            return null;
        }
        return fd.getDirectory() + fd.getFile();
    }

    public void formImage(ImageMap map) {
        int rows = map.getRows();
        int cols = map.getCols();
        this.image = this.imagePanel.createImage(new MemoryImageSource(cols, rows, map.getMap(), 0, cols));
        this.imagePanel.changeImage(this.image);
        this.thumbnail.setImage(this.image);
    }

    public void invert() {
        DirectColorModel dm = (DirectColorModel)ColorModel.getRGBdefault();
        int rows = this.imageMap.getRows();
        int cols = this.imageMap.getCols();
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int rgb = this.imageMap.getPixel(i, j);
                int red = 255 - dm.getRed(rgb);
                int blue = 255 - dm.getBlue(rgb);
                int green = 255 - dm.getGreen(rgb);
                int alpha = dm.getAlpha(rgb);
                this.imageMap.setPixel(i, j, alpha << 24 | red << 16 | green << 8 | blue);
                ++j;
            }
            ++i;
        }
        this.formImage(this.imageMap);
    }

    public void transpose() {
        int rows = this.imageMap.getRows();
        int cols = this.imageMap.getCols();
        ImageMap b = new ImageMap(this.image, cols, rows);
        int r = 0;
        while (r != rows) {
            int c = 0;
            while (c != cols) {
                b.setPixel(c, r, this.imageMap.getPixel(r, c));
                ++c;
            }
            ++r;
        }
        this.imageMap = b;
        this.formImage(this.imageMap);
    }

    public void hreflect() {
        int rows = this.imageMap.getRows();
        int cols = this.imageMap.getCols();
        int h = 0;
        int k = rows - 1;
        while (h < k) {
            int c = 0;
            while (c != cols) {
                this.imageMap.swapPixels(h, c, k, c);
                ++c;
            }
            ++h;
            --k;
        }
        this.formImage(this.imageMap);
    }

    public void vreflect() {
        int rows = this.imageMap.getRows();
        int cols = this.imageMap.getCols();
        int h = 0;
        int k = cols - 1;
        while (h < k) {
            int r = 0;
            while (r != rows) {
                this.imageMap.swapPixels(r, h, r, k);
                ++r;
            }
            ++h;
            --k;
        }
        this.formImage(this.imageMap);
    }

    public void restore() {
        this.imageMap = this.originalMap.copy();
        this.formImage(this.imageMap);
    }
}

