/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.border.EmptyBorder;

public class ImageHandler
extends JFrame {
    public static final String LOAD_INTERRUPTED = "Image loading interrupted";
    public static final String NORMAL = "Select or load an image";
    public static final String IMAGE_LIMIT_EXCEEDED = "Image limit exceeded";
    public static final String NO_IMAGE = "No image selected";
    private ImageJFrame selectedImage = new ImageJFrame(null, null);
    private JMenuBar menuBar = new JMenuBar();
    private JLabel message = new JLabel("Select or load an image");
    Box topImages = new Box(0);
    Box bottomImages = new Box(0);
    Box rows = new Box(1);
    private ImageMaintainer[] images = new ImageMaintainer[10];
    private int numberImages = 0;
    private int highlighted = -1;
    private ImageHandler thisHandler = this;

    public static void main(String[] par) {
        ImageHandler imageHandler = new ImageHandler();
    }

    public ThumbnailPanel getHighlighted() {
        if (this.highlighted == -1) {
            return null;
        }
        return this.images[this.highlighted].getThumbnail();
    }

    public void addImage(ImageMaintainer im) {
        if (this.numberImages == 10) {
            this.flashMessage("There is no room to add an image");
        }
        this.images[this.numberImages] = im;
        if (this.numberImages <= 4) {
            this.topImages.add((Component)im.getThumbnail(), "title");
        } else {
            this.bottomImages.add((Component)im.getThumbnail(), "title");
        }
        this.highlighted = this.numberImages++;
        this.setPreferredSizeOfBox();
        this.pack();
        this.repaint();
    }

    public void removeImage() {
        if (this.numberImages == 0) {
            return;
        }
        if (this.highlighted == -1) {
            return;
        }
        if (this.highlighted < 5) {
            this.topImages.remove(this.images[this.highlighted].getThumbnail());
        } else {
            this.bottomImages.remove(this.images[this.highlighted].getThumbnail());
        }
        if (this.highlighted < 5 && this.numberImages >= 6) {
            this.bottomImages.remove(this.images[5].getThumbnail());
            this.topImages.add(this.images[5].getThumbnail());
        }
        int i = this.highlighted + 1;
        while (i != this.numberImages) {
            this.images[i - 1] = this.images[i];
            ++i;
        }
        --this.numberImages;
        if (this.highlighted == this.numberImages) {
            --this.highlighted;
        }
        if (this.highlighted != -1) {
            ImageMaintainer it = this.images[this.highlighted];
            this.selectedImage.placeImage(it.getImage(), it.getFileName());
        } else {
            this.selectedImage.placeImage(null, null);
        }
        this.pack();
        ((Component)this).setVisible(true);
        this.repaint();
    }

    public ImageHandler() {
        this.setTitle("Image Handler");
        this.setDefaultCloseOperation(3);
        this.setPreferredSizeOfBox();
        this.rows.add(this.topImages);
        this.rows.add(this.bottomImages);
        this.rows.setBorder(new EmptyBorder(0, 10, 0, 10));
        int c = 0;
        while (c != this.images.length) {
            this.images[c] = null;
            ++c;
        }
        JMenu file = new JMenu("File");
        JMenuItem fileOpen = new JMenuItem("Open");
        JMenuItem fileClose = new JMenuItem("Close");
        JMenuItem fileExit = new JMenuItem("Exit");
        fileOpen.addActionListener(new OpenActionListener());
        fileClose.addActionListener(new CloseActionListener());
        file.add(fileOpen);
        file.add(fileClose);
        file.addSeparator();
        file.add(fileExit);
        this.menuBar.add(file);
        JMenu im = new JMenu("Image");
        JMenuItem inv = new JMenuItem("Invert");
        JMenuItem trans = new JMenuItem("Transpose");
        JMenuItem href = new JMenuItem("Horizontally Reflect");
        JMenuItem vref = new JMenuItem("Vertically Reflect");
        JMenuItem rest = new JMenuItem("Restore");
        inv.addActionListener(new InvertActionListener());
        trans.addActionListener(new TransActionListener());
        href.addActionListener(new HRefActionListener());
        vref.addActionListener(new VRefActionListener());
        rest.addActionListener(new RestActionListener());
        im.add(inv);
        im.add(trans);
        im.add(href);
        im.add(vref);
        im.addSeparator();
        im.add(rest);
        this.menuBar.add(im);
        JMenu help = new JMenu("Help");
        JMenuItem showHelp = new JMenuItem("Show help");
        showHelp.addActionListener(new HelpActionListener());
        help.add(showHelp);
        this.menuBar.add(help);
        this.getContentPane().add((Component)this.message, "North");
        this.getContentPane().add((Component)this.rows, "Center");
        this.setJMenuBar(this.menuBar);
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void flashMessage(String m) {
        ErrorThread thread = new ErrorThread(m);
        thread.start();
    }

    public void setMessage(String m) {
        this.message.setText(m);
        this.repaint();
    }

    public void highlightThumbnail(ThumbnailPanel tp) {
        this.highlighted = 0;
        while (this.images[this.highlighted].getThumbnail() != tp) {
            ++this.highlighted;
        }
        this.highlightThumbnail();
    }

    public void highlightThumbnail() {
        if (this.highlighted != -1) {
            ImageMaintainer it = this.images[this.highlighted];
            this.selectedImage.placeImage(it.getImage(), it.getFileName());
        } else {
            this.selectedImage.placeImage(null, null);
        }
        this.repaint();
    }

    public void setPreferredSizeOfBox() {
        if (this.numberImages == 0) {
            int w = 70;
            this.rows.setPreferredSize(new Dimension(2 * w, 100));
            return;
        }
        int w = 70 * Math.min(this.numberImages, 5);
        int h1 = this.images[0].getThumbnail().newGetHeight();
        int m = Math.min(this.numberImages, 5);
        int i = 1;
        while (i != m) {
            h1 = Math.max(h1, this.images[i].getThumbnail().newGetHeight());
            ++i;
        }
        h1 += 12;
        int h2 = 0;
        int i2 = 5;
        while (i2 < Math.max(this.numberImages, 5)) {
            h2 = Math.max(h2, this.images[i2].getThumbnail().newGetHeight());
            ++i2;
        }
        if (h2 != 0) {
            h2 += 12;
        }
        int minWidth = 140;
        this.rows.setPreferredSize(new Dimension(Math.max(minWidth, w), h1 + 15 + h2));
    }

    class HelpActionListener
    implements ActionListener {
        HelpActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String helps = "To load a new picture, use menu File item open. You can load .jpeg files and .gif files.\n\nTo close a picture, highlight it and use menu File item close.\n\nTo terminate the application, use either the close box or menu File item Exit.\n\nIn menu Image, you can use the following items, on the currently highlighted picture.\n    Invert \n    Transpose \n    Horizontally Reflect, \n    Vertically Reflect \nwhich perform obvious transformations on the highlighted picture.\nThis item restores the original picture:\n    Restore";
            TextWindow textWindow = new TextWindow(helps, "Image Help", 60);
        }
    }

    class RestActionListener
    implements ActionListener {
        RestActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ImageHandler.this.highlighted != -1) {
                ImageHandler.this.images[ImageHandler.this.highlighted].restore();
                ImageHandler.this.selectedImage.setImage(ImageHandler.this.images[ImageHandler.this.highlighted].getImage());
                ImageHandler.this.repaint();
            } else {
                ImageHandler.this.flashMessage(ImageHandler.NO_IMAGE);
            }
        }
    }

    class VRefActionListener
    implements ActionListener {
        VRefActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ImageHandler.this.highlighted != -1) {
                ImageHandler.this.images[ImageHandler.this.highlighted].vreflect();
                ImageHandler.this.selectedImage.setImage(ImageHandler.this.images[ImageHandler.this.highlighted].getImage());
                ImageHandler.this.repaint();
            } else {
                ImageHandler.this.flashMessage(ImageHandler.NO_IMAGE);
            }
        }
    }

    class HRefActionListener
    implements ActionListener {
        HRefActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ImageHandler.this.highlighted != -1) {
                ImageHandler.this.images[ImageHandler.this.highlighted].hreflect();
                ImageHandler.this.selectedImage.setImage(ImageHandler.this.images[ImageHandler.this.highlighted].getImage());
                ImageHandler.this.repaint();
            } else {
                ImageHandler.this.flashMessage(ImageHandler.NO_IMAGE);
            }
        }
    }

    class TransActionListener
    implements ActionListener {
        TransActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ImageHandler.this.highlighted != -1) {
                ImageHandler.this.images[ImageHandler.this.highlighted].transpose();
                ImageHandler.this.selectedImage.setImage(ImageHandler.this.images[ImageHandler.this.highlighted].getImage());
                ImageHandler.this.repaint();
            } else {
                ImageHandler.this.flashMessage(ImageHandler.NO_IMAGE);
            }
        }
    }

    class InvertActionListener
    implements ActionListener {
        InvertActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ImageHandler.this.highlighted != -1) {
                ImageHandler.this.images[ImageHandler.this.highlighted].invert();
                ImageHandler.this.selectedImage.setImage(ImageHandler.this.images[ImageHandler.this.highlighted].getImage());
                ImageHandler.this.repaint();
            } else {
                ImageHandler.this.flashMessage(ImageHandler.NO_IMAGE);
            }
        }
    }

    public class CloseActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ImageHandler.this.removeImage();
        }
    }

    class OpenActionListener
    implements ActionListener {
        OpenActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ImageHandler.this.numberImages == 10) {
                ImageHandler.this.flashMessage(ImageHandler.IMAGE_LIMIT_EXCEEDED);
                return;
            }
            String fileName = ImageMaintainer.getImageName();
            Image im = ImageMaintainer.getImage(fileName, ImageHandler.this.selectedImage);
            if (fileName == null) {
                return;
            }
            ImageHandler.this.addImage(new ImageMaintainer(im, fileName, ImageHandler.this.thisHandler));
            ImageHandler.this.selectedImage.placeImage(im, fileName);
        }
    }

    class ErrorThread
    extends Thread {
        String error;

        public ErrorThread(String er) {
            this.error = er;
        }

        public void run() {
            ImageHandler.this.setMessage(this.error);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ImageHandler.this.setMessage(ImageHandler.NORMAL);
        }
    }
}

