// Class Washable
// - generic class for Items that can be extracted and washed

import Item;
import MyMath;

abstract public class Washable extends Item {   

    protected Disposable garbage;

    protected Washable() { setGarbage(); }

    protected Washable(Disposable g) { garbage=g; }

    protected void setRetrievability() {
	if (garbage != null) 
	    retrievability = garbage.getRetrievability();
    }

    protected void setGarbage() {
	switch(MyMath.random(0,2)) {
	case 0: garbage = null; break;
	case 1: garbage = new Liquid(); break;
	case 2: garbage = new Solid(); break;
	default: break;
	}
    }

} // Class Washable
