//-----------------------------------------------------------------------------
// Class Tray:
// - an Item that holds a collection (a Vector) of other Items
// - Workers remove Items from the Tray, including the Tray if possible
//-----------------------------------------------------------------------------

import java.util.Vector;

public class Tray extends Washable { 

    //-------------------------------------------------------------------------
    // Initialize limits to counts of Items on current Tray:
    //-------------------------------------------------------------------------
       private final int MAXSPOONS     = MyMath.random(0,3); // Spoons
       private final int MAXFORKS      = MyMath.random(0,3); // Forks
       private final int MAXKNIVES     = MyMath.random(0,3); // Knives
       private final int MAXCUPS       = MyMath.random(0,1); // Cups
       private final int MAXGLASSES    = MyMath.random(0,2); // Glasses
       private final int MAXBOWLS      = MyMath.random(0,3); // Bowls
       private final int MAXPLATES     = MyMath.random(0,3); // Plates
       private final int MAXDISPOSABLE = MyMath.random(0,3); // Garbage ON Tray

    //-------------------------------------------------------------------------
    // Array of counts for each type of Item on Tray:
    //-------------------------------------------------------------------------
       private final int[] COUNTS = { MAXSPOONS, MAXFORKS, MAXKNIVES, 
				      MAXCUPS, MAXGLASSES, MAXBOWLS, 
				      MAXPLATES, MAXDISPOSABLE };

    //-------------------------------------------------------------------------
    // Count of total amount of Items put on Tray:
    //-------------------------------------------------------------------------
       private final int TOTALITEMS = 
	   MAXSPOONS + MAXFORKS + MAXKNIVES + MAXCUPS + 
	   MAXGLASSES + MAXBOWLS + MAXPLATES + MAXDISPOSABLE;

    //-------------------------------------------------------------------------
    // Initialize Vector to hold Items put on current Tray:
    //-------------------------------------------------------------------------
       private Vector items = new Vector(TOTALITEMS); 

    //-------------------------------------------------------------------------
    // Constructor Tray()
    // ==================
    // Create Tray with Items:
    //-------------------------------------------------------------------------
       public Tray() {
	   super(null);         // garbage on Tray taken care of inside $items$
	   setRetrievability(); // set Tray's retrievability factor
	   fillTray();          // put Items on Tray by filling $items$
       } // Constructor Tray
    
    //-------------------------------------------------------------------------
    // Method setRetrievability
    // ========================
    // Set the retrievability factor for the current Tray (easy):
    //-------------------------------------------------------------------------
       protected void setRetrievability() {
	   retrievability += Difficulty.easy;
       }

    //-------------------------------------------------------------------------
    // Fill Tray
    // =========
    // Precondition: The current Tray has no Items inside the $items$ Vector.
    // Fill the current Tray with a random amount of Items, using the 
    // initialized limits:
    //-------------------------------------------------------------------------
       private void fillTray() {
	   
	   // Fill $items$ with Items, one at a time:
	      for (int i=0 ; i<COUNTS.length ; i++)
		  
		  // Use limits for the counts for each type of Item:
		     for (int j=0 ; j<COUNTS[i] ; j++)
			 switch(i) {
			 case 0: items.addElement(new Spoon()); break;
			 case 1: items.addElement(new Fork());  break;
			 case 2: items.addElement(new Knife()); break;
			 case 3: items.addElement(new Glass()); break;
			 case 4: items.addElement(new Cup());   break;
			 case 5: items.addElement(new Bowl());  break;
			 case 6: items.addElement(new Plate()); break;
			 case 7: items.addElement(new Solid()); break;
			 default: break;
			 }

           // Quit the program if somehow too many Items were added to $items$:
	      if (items.size() > TOTALITEMS)
		  p6sp01.quitProgram("TOTALITEMS exceeded in Tray class!");
	      
       } // Method fillTray

    //-------------------------------------------------------------------------
    // Return the collection of Items on the current Tray:
    //-------------------------------------------------------------------------
       public Vector getItems() {
	   return items; 
       }
    
    //-------------------------------------------------------------------------
    // Return a Boolean value depending on whether or not
    // the current Tray is empty:
    //-------------------------------------------------------------------------
       public boolean isEmpty() { 
	   return items.isEmpty(); 
       }

} // Class Tray
