// Class Disposable
// - generic garbage class
// - using the name "Disposable" to distinguish from "Washable"

import Thing;
import Size;
import Quality;

abstract public class Disposable extends Item { 

    protected int quality;  // how disgusting is the garbage?
    
    // Construct "garbage":
    public Disposable() { 
	setGarbageType();
	setGarbageSize();
	setRetrievability();
    }
    
    // Rate the quality of the "garbage":
    private void setGarbageType() {
	switch(MyMath.random(0,2)) {
	case 0: quality = Quality.decent; break;
	case 1: quality = Quality.neutral; break;
	case 2: quality = Quality.vile; break;
	default: break;
	}
    }
    
    // Determine the quantity of the "garbage":
    private void setGarbageSize() {
	switch(MyMath.random(0,4)) {
	case 0: size = Size.tiny; break;
	case 1: size = Size.small; break;
	case 2: size = Size.medium; break;
	case 3: size = Size.large; break;
	case 4: size = Size.big; break;
	default: break;
	}
    }

} // Class Disposable
