//-----------------------------------------------------------------------------
// Class Dishroom
// - represents the location of the simulation (from Class p6sp01)
// - has the Belt and Workers
//-----------------------------------------------------------------------------

import java.io.*;
import java.util.Vector;

public class Dishroom extends Thing {

    //-------------------------------------------------------------------------
    // Initialize Belt variables:
    //-------------------------------------------------------------------------
       private int step;         // # of times 
       private int totalTrays;   // total Trays removed
       private int totalItems;   // total Items removed
       private int size;         // number of Workers and Trays
       private Belt belt;        // Belt that hold the incoming Trays
       private Worker[] workers; // Workers that extract everything

    //-------------------------------------------------------------------------
    // Constructor Dishroom(int size)
    // ==============================
    // Create a Dishroom that has the conveyor Belt and Workers that 
    // extract Items from Trays on the Belt:
    //-------------------------------------------------------------------------
       public Dishroom(int size) {	
	   this.size = size;       // set # of Trays and Workers
	   belt = new Belt(size);  // create new Belt

	   // Create array of Workers that will "know" their
	   // positions along the Belt:
	      workers = new Worker[size];     
	      for (int i=0 ; i < size ; i++)
		  workers[i]=new Worker(i);

       } // Constructor Dishroom

    //-------------------------------------------------------------------------
    // Method reset
    // ============
    // Reset the amount of extracted Trays and Items to zero:
    //-------------------------------------------------------------------------
       public void reset()   { totalTrays = totalItems = 0; }

    //-------------------------------------------------------------------------
    // Method getItems
    // ===============
    // Reset the amount of extracted Items:
    //-------------------------------------------------------------------------
       public int getItems() { return totalItems; }

    //-------------------------------------------------------------------------
    // Method getTrays
    // ===============
    // Return the amount of extracted Trays:
    //-------------------------------------------------------------------------
       public int getTrays() { return totalTrays; }

    //-------------------------------------------------------------------------
    // Method activate
    // ===============
    // Precondition: The Belt is not "moving," so Workers have not
    // begun extracting Items from Trays.
    // Action: Run the current simulation by filling the first Tray,
    // having Workers extract Items from Trays, and shifting the Trays that
    // remain to the next Worker "down" the line.
    // Postcondition: The Belt has stopped because the last Tray is not empty.
    //-------------------------------------------------------------------------
       public void activate() {
	   
	   while (!belt.stopBelt()) {
	       step++;                  // increment the current $step$
	       belt.fillTray();         // fill the first Tray
	       extractContents();       // Workers extract Items and Trays
	       belt.shiftTrays();       // Trays shift to the next Worker
	       decreaseEfficiencies();  // Workers' efficiencies decreased
	   }
	   
       } // Method activate
    
    //-------------------------------------------------------------------------
    // Method extractContents
    // ======================
    // Precondition: The Tray in front of each Worker (if it exists) has
    // Items (assuming they exist) that need to be removed.
    // Action: Each Worker attempts to extract Items from the Tray in front
    // of her/him.
    // Postcondition: Each Tray possibly has Items removed, including the 
    // Tray itself.
    //-------------------------------------------------------------------------
       private void extractContents() {

	   // Extract items from each Tray in front of each Worker,
	   // assuming the Tray exists:

	      for (int i = _______ ; ________ ; _____ ) {
		  
		  // Get current Tray:
		  
		  ___________ = ___________ ;

		  // If the Tray exists, extract Items:

		     if (tray != _______ )  {  // if no Tray, no Items
			 
			 // Items from current Tray:

			    ______________________ = _______________________;
 
			 // Items currently on Tray:

			    ______________________ = _______________________;

                         // Worker extracts Items from current Tray:

			    ______________________ = _______________________;

                         // Items left on Tray after extraction:

			    ______________________ = _______________________;
		
                         // Add removed Items to totalItems count:

			    ______________________ = _______________________;
		    
                         // If Tray is emptied of all item, increment
                         // totalTrays and remove the Tray from the Belt:
			    if (finalItems == 0) {

				______________________ ;

				______________________ ;

			    }
			    
		     } // done checking current Tray
		     
	      } // go to next Tray to keep extracting Items
	      
       } // Method extractContents

    //-------------------------------------------------------------------------
    // Method decreaseEfficiencies
    // ===========================
    // Precondition: The Worker's efficiencies are set.
    // Decrease the each Worker's effienciency based on how frequency of 
    // Trays the Worker's position along the Belt. Actually, this method
    // ought to be improved.
    //-------------------------------------------------------------------------
       private void decreaseEfficiencies() {
	   if (step % size == 0)
	       for (int i=0 ; i<size ; i++) 
		   workers[i].changeEfficiency();
       } // Method decreaseEfficiencies   


} // Class Dishroom
