//-----------------------------------------------------------------------------
// Class Belt
// - represents the Belt that holds the Trays
//-----------------------------------------------------------------------------

import java.util.Vector;

public class Belt extends Thing {
    
    //-------------------------------------------------------------------------
    // Measures of the amount of Trays on a Belt:
    //-------------------------------------------------------------------------
       private int size;       // # of Trays on a Belt
       private Tray[] trays;   // the Trays on a Belt
       private int firstTray;  // position of first Tray
       private int lastTray;   // position of last Tray
    
    //-------------------------------------------------------------------------
    // Constructor Belt(int size)
    // ==========================
    // Create new Belt with $size$ Trays:
    //-------------------------------------------------------------------------
       public Belt(int size) {
	   this.size = size;
	   trays = new Tray[size];
	   lastTray=size-1;
       } // Constructor Belt

    //-------------------------------------------------------------------------
    // Method fillTray
    // ===============
    // Precondition: The first Tray is empty.
    // Postcondition: The first Tray is automatically filled by calling the
    // $Tray()$ constructor.
    //-------------------------------------------------------------------------
       public void fillTray() {
	   trays[firstTray] = new Tray();
       }
    
    //-------------------------------------------------------------------------
    // Method shiftTrays
    // =================
    // Precondition: The Trays have had Items extracted. 
    // Postcondition: The Trays in front of each Worker are shifted to the 
    // next Worker "down" the Belt.
    //-------------------------------------------------------------------------
       public void shiftTrays() {
	   for (int i=lastTray ; i>firstTray ; i--)
	       if (trays[i-1] != null)
		   trays[i] = trays[i-1];
       } // Method shiftTrays

    //-------------------------------------------------------------------------
    // Method removeEmptyTray
    // ======================
    // Precondition: The ith Tray exists and is empty.
    // Remove the ith empty Tray:
    //-------------------------------------------------------------------------
       public void removeEmptyTray(int i) {
	   if (trays[i].getItems().size() == 0)
	       trays[i] = null;
       } // Method removeEmptyTray

    //-------------------------------------------------------------------------
    // Method getTray
    // ==============
    // Precondition: The ith Tray might exist or be $null$.
    // Return the ith Tray, even if the value is $null$:
    //-------------------------------------------------------------------------
       public Tray getTray(int i) {
	   return trays[i];
       }

    //-------------------------------------------------------------------------
    // Method stopBelt
    // ===============
    // Precondition: The last Tray might be empty or non-existent.
    // Return a Boolean value for whether or not the last Tray is empty:
    //-------------------------------------------------------------------------
       public boolean stopBelt() {
	   // If the last Tray does not exist, do not stop the Belt:
	      if (trays[lastTray] == null) 
		  return false;
           // Otherwise, stop the Belt:
	      return !trays[lastTray].isEmpty();

       } // Method stopBelt


} // Class Belt
