function test_popup()
% This function creates a popup menu and a text field.
% The the associated callback will cause the option 
% selected in the popup menu to be displayed in the
% text field.

% First, create a cell array of options
options{1} = 'Option 1';
options{2} = 'Option 2';
options{3} = 'Option 3';
options{4} = 'Option 4';
options{5} = 'Option 5';

h0 = figure('Color',[0.8 0.8 0.8], ...
   'Name','Test Popup Menu', ...
   'NumberTitle','off', ...
   'Position',[300 300 257 136], ...
   'Tag','Fig1');
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'BackgroundColor',[0.8 0.8 0.8], ...
   'Position',[45 45 70 17], ...
   'String','Option 1', ...
   'Style','text', ...
   'Tag','Label1');
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'Callback','test_popup_callback', ...
   'Position',[45 25 70 17], ...
   'String',options, ...
   'Style','popupmenu', ...
   'Value',1, ...
   'Tag','Popup1');
