function fig = temp_conversion()
%
%  Purpose: 
%    This program converts degrees F to degrees C and 
%    versa in the range 0-100 degrees C.  This function
%    creates the GUI for the program.  The original GUI
%    was created with guide, and then comments were added
%    to the code.
%
%  Record of revisions:
%      Date       Programmer        Description of change
%      ====       ==========        =====================
%     3/10/99    S. J. Chapman      Original code 
% 1.  3/14/99    S. J. Chapman      Added tool tips
%
load temp_conversion

% Define figure
h0 = figure('Units','points', ...
   'Color',[0.8 0.8 0.8], ...
   'Colormap',mat0, ...
   'FileName','D:\book\Matlab\rev2\chap10\temp_conversion.m', ...
   'MenuBar','none', ...
   'Name','Temperature Conversion', ...
   'NumberTitle','off', ...
   'PaperPosition',[18 180 576.0000000000001 432.0000000000002], ...
   'PaperUnits','points', ...
   'Position',mat1, ...
   'Tag','Fig1', ...
   'ToolBar','none');

% Create the degrees F label and edit box
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'BackgroundColor',[0.8 0.8 0.8], ...
   'ListboxTop',0, ...
   'Position',[26 71 59 14], ...
   'String','Degrees F', ...
   'Style','text', ...
   'Tag','Label1');
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'BackgroundColor',[1 1 1], ...
   'Callback','temp_conversion_callback Edit1', ...
   'ListboxTop',0, ...
   'Position',[105 71 59 14], ...
   'String','32.0', ...
   'Style','edit', ...
   'TooltipString','Enter temp in degrees F', ...
   'Tag','Edit1');

% Create the degrees C label and edit box
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'BackgroundColor',[0.8 0.8 0.8], ...
   'ListboxTop',0, ...
   'Position',[26 50 59 14], ...
   'String','Degrees C', ...
   'Style','text', ...
   'Tag','Label2');
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'BackgroundColor',[1 1 1], ...
   'Callback','temp_conversion_callback Edit2', ...
   'ListboxTop',0, ...
   'Position',[105 50 59 14], ...
   'String','0.0', ...
   'Style','edit', ...
   'TooltipString','Enter temp in degrees C', ...
   'Tag','Edit2');

% Create the slider
h1 = uicontrol('Parent',h0, ...
   'Units','points', ...
   'Callback','temp_conversion_callback Slider1', ...
   'ListboxTop',0, ...
   'Max',100, ...
   'Position',[46 22 99 13], ...
   'Style','slider', ...
   'TooltipString','Adjust temp by moving slider', ...
   'Tag','Slider1');
if nargout > 0, fig = h0; end
