import java.awt.*;

// An instance of class Face is a model of a face:
// a circle with two inner circles for the eyes and
// a mouth.
public class Face
{
protected int xFace; 	// The face has center (xFace,yFace)
protected int yFace;	// and radius rFace
protected int rFace;

// Constructor: a face with center (xp,yp) and radius rp
public Face(int xp, int yp, int rp) {
	xFace= xp;
	yFace= yp;
	rFace= rp;
	}

// Draw the face using Graphics g
public void drawFace(Graphics g) {
	g.drawOval(xFace-rFace, yFace-rFace, 2*rFace, 2*rFace);
	drawEyes(g);
	drawMouth(g);
	}
	
// Draw the mouth using Graphics g -- a line 1/3 of way
// down from center and rFace/8 long
public void drawMouth(Graphics g) {
	g.drawLine(xFace-rFace/8, yFace+rFace/3,
			   xFace+rFace/8, yFace+rFace/3);	
	}


// Draw eyes halfway up from the center of the face and 1/3 of
// the way to the left and right of the center. The radius of
// each eye is the maximum of 1 and r/8. Use Graphics g.
public void drawEyes(Graphics g) {
	Color c= g.getColor();
	g.setColor(Color.blue);
	
	// Calculate the y-coordinate y of the center of the eyes
	// and the radius r of the eyes
		int y= yFace - rFace/2;	//y-coordinate of center of eyes
		int r= rFace/8;			//radius of eyes
		if (r < 1)
			r= 1;
	// Draw the eyes
		g.fillOval(xFace-rFace/3-r, y-r, 2*r, 2*r);
		g.fillOval(xFace+rFace/3-r, y-r, 2*r, 2*r);
	
	g.setColor(c);
	}
	
}