import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/** An instance maintains a time of day */
public class Time implements Comparable<Time> {
    private int hr; // hour of the day, in 0..23
    private int min; // minute of the hour, in 0..59
    
    public @Override int compareTo(Time ob) {
        return 60*hr + min  -  (60*ob.hr + ob.min);
    }


    /** Constructor: An instance with hour h and minute m
     *   Precondition: ... */
    public Time(int h, int m) {
        hr= h;
        min= m;
    }

    /** return the hour of the day */
    public int getHour() {
        return hr;
    }

    /** return the minute of the hour */
    public int getMin() {
        return min;
    }

    /** Change the hour of the day to h */
    public void setHour(int h) {
        hr= h;
    }

    /** = a description of this object */
    public String toString() {
        return make2(hr) + ":" + make2(min);
    }

    /** = p, as a string with at least 2 chars
     * --prepend 0 if necessary */
    private String make2(int p) {
        if (0 <= p  &&  p < 10) {
            return "0" + p;
        }
        return "" + p;
    }

  
   
}



