#ifndef __C_TYPES_H
#define __C_TYPES_H

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winsock2.h>

#define		TEST_MSG_NULL		0
#define		TEST_MSG_STATUS		1
#define		TEST_MSG_SEND_RATE	2
#define		TEST_MSG_KILL		3
#define		TEST_MSG_SLEEP		4

#define		TEST_MSG_SINGLE 0x80

// Status
typedef struct Status
{
	PbcastParams pbcastParam;
	unsigned int sendRate;
	unsigned int recvRate;
	char		 status;	
} Status;

typedef struct Values
{
	unsigned int hashCode;
	unsigned int sendRate;
} Values;

union Data
{
	Status status;
	Values values;
};

typedef struct TestMsg
{
	unsigned char type;
	Data		  data;
} TestMsg;

typedef struct TronTestParam
{
	unsigned int mNumSubnets;
	double	     mPercentOutDrop;
	double		 mPercentInDrop;
	sockaddr_in	 mSubnetList[4];
} TronTestParam;

typedef struct TronTestHandles
{
	HWND	hMain;
	HWND	hCurrentNode;
	HWND	hViewSize;
	HWND	hSubnetSize;
	HWND	hGossipInterval;
	HWND	hFanout;
	HWND	hTimeToFail;
	HWND	hRetranReq;
	HWND	hRetranRec;
	HWND	hFullGosOut;
	HWND	hMinGosOut;
	HWND	hFullGosIn;
	HWND	hMinGosIn;
	HWND	hTime;
	HWND	hLastViewTime;
	HWND	hLastViewSize;
	HWND	hAlive;
	HWND	hSendRate;
	HWND	hSlider;
	HWND	hPbcastOut;
	HWND	hPbcastIn;
	HWND	hLastGapTime;
	HWND	hLocalNodeCheck;
	HWND	hRecvRate;
	HWND	hNetRecvRate;
} TronTestHandles;

#endif