#define VERSION .01

/*
 * main.cpp
 *
 * Simple test program for pbcast system.
 */
#define WIN32_LEAN_AND_MEAN

#include <stdio.h>
#include "Util\gError.h"
#include "cTrontest.h"
#include <commctrl.h>
#include <stdlib.h>
#include "resource.h"
#include "types.h"
#include <winsock2.h>
#include <winuser.h>

#define MAX_SEND_RATE 400

// Globals :-)
TronTestHandles  gHandle;
TronTestParam	 gParam;
cTrontest		 sim;
HANDLE			 mMainThreadHandle;	// thread handle of the main thread.
DWORD			 mMainThreadId;		// id of the main thread.
LRESULT		 	 sliderPos = 1;
LRESULT			 newPos;
bool			 gui = true;

// Prototypes
BOOL CALLBACK Dlg_Main(HWND hDlg, UINT msg, UINT wParam, LPARAM lParam);
BOOL CALLBACK Dlg_Min(HWND hDlg, UINT msg, UINT wParam, LPARAM lParam);
BOOL CALLBACK Dlg_Param(HWND hDlg, UINT msg, UINT wParam, LPARAM lParam);
DWORD WINAPI _SimThread(LPVOID lpParameter);
bool _Start();
bool _Stop();

/*-------------------------------------------------------------*/
/* Function: WinMain()										   */
/*															   */
/*-------------------------------------------------------------*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	lpszCmdLine = lpszCmdLine; //avoids compiler warning

	INITCOMMONCONTROLSEX ex;
	ex.dwSize = sizeof(ex);
	ex.dwICC  = ICC_INTERNET_CLASSES;
	InitCommonControlsEx(&ex);	//necessary :-(
	if(DialogBox (hInstance, MAKEINTRESOURCE(IDD_PARAMDLG), NULL, (DLGPROC)Dlg_Param) == -1) {
		return 1;
	}
	if(gui)
	{
		if(DialogBox (hInstance, MAKEINTRESOURCE(IDD_MAINDLG), NULL, (DLGPROC)Dlg_Main) == -1) {
			MessageBox(NULL, "DialogBox call failed", "DOH", MB_OK);
		}
	}
	else
	{
		_Start();
		if(DialogBox (hInstance, MAKEINTRESOURCE(IDD_MINGUI), NULL, (DLGPROC)Dlg_Min) == -1) {
			MessageBox(NULL, "DialogBox call failed", "DOH", MB_OK);
		}		
	}
	_Stop();	// Shut down thread.
	return 1;
} /* end WinMain */


/*-------------------------------------------------------------*/
/* Function: Dlg_Main()										   */
/*															   */
/*-------------------------------------------------------------*/
BOOL CALLBACK Dlg_Main(HWND hDlg, UINT msg, UINT wParam, LPARAM lParam)
{
	bool bRet = false;

	switch(msg) {
		case WM_COMMAND:
			switch(wParam)
			{
				case WM_DESTROY:
				case IDC_QUIT:
					bRet = true;
					sim.mRun = false;
					EndDialog(hDlg, msg);
					break;

				case IDC_KILL:
					sim.Kill();
					bRet = true;
					break;

				case IDC_KILLEMALL:
					sim.KillEmAll();
					bRet = true;
					break;

				case IDC_SLEEP:
					sim.MakeSleep();
					bRet = true;
					break;

				case IDC_SETFORALL:
					sim.SetForAll();
					bRet = true;
					break;
			}
			break;

		case WM_VSCROLL:
			switch(LOWORD(wParam))
			{
				case SB_LINEDOWN:
					sim.NodeUp();
					bRet = true;
					break;

				case SB_LINEUP:
					sim.NodeDown();
					bRet = true;
					break;
			}
			break;

		case WM_HSCROLL:
			if((HWND) lParam == gHandle.hSlider)
			{
				if(LOWORD(wParam) == TB_THUMBTRACK)
				{
					sim.mSliderWait = true;
					bRet = true;
				}
				else if(LOWORD(wParam) == TB_ENDTRACK)
				{
					sim.mSliderWait = false;
					//NOTE: I assume that the only control that sends WM_NOTIFY is the slider!!!
					char buffer[10];
					newPos = SendMessage(gHandle.hSlider, TBM_GETPOS, (WPARAM)0, (LPARAM)0);
					if(newPos != sliderPos) 
					{
						sliderPos = newPos;
						SetWindowText(gHandle.hSendRate, itoa(sliderPos, buffer, 10));
						sim.UpdateSendRate(sliderPos);
					}
					bRet = true;
				}
			}
			break;

		case WM_INITDIALOG:
			bRet = true;
			gHandle.hMain		    = hDlg;
			gHandle.hViewSize		= GetDlgItem(hDlg, IDC_VIEWSIZE);
			gHandle.hCurrentNode    = GetDlgItem(hDlg, IDC_CURRENTNODE);
			gHandle.hSubnetSize		= GetDlgItem(hDlg, IDC_SUBNETSIZE);
			gHandle.hGossipInterval = GetDlgItem(hDlg, IDC_GOSSIPINT);
			gHandle.hFanout			= GetDlgItem(hDlg, IDC_FANOUT);
			gHandle.hTimeToFail		= GetDlgItem(hDlg, IDC_TIMETOFAIL);
			gHandle.hRetranReq		= GetDlgItem(hDlg, IDC_RETRANREQ);
			gHandle.hRetranRec		= GetDlgItem(hDlg, IDC_RETRANREC);
			gHandle.hFullGosOut		= GetDlgItem(hDlg, IDC_FULLGOSOUT);
			gHandle.hMinGosOut		= GetDlgItem(hDlg, IDC_MINGOSOUT);
			gHandle.hFullGosIn		= GetDlgItem(hDlg, IDC_FULLGOSIN);
			gHandle.hMinGosIn		= GetDlgItem(hDlg, IDC_MINGOSIN);
			gHandle.hTime			= GetDlgItem(hDlg, IDC_TIME);
			gHandle.hLastViewTime	= GetDlgItem(hDlg, IDC_LASTVIEWTIME);
			gHandle.hLastViewSize	= GetDlgItem(hDlg, IDC_LASTVIEWSIZE);
			gHandle.hAlive			= GetDlgItem(hDlg, IDC_ALIVE);
			gHandle.hSlider			= GetDlgItem(hDlg, IDC_SENDRATESLIDE);
			gHandle.hSendRate		= GetDlgItem(hDlg, IDC_SENDRATE);
			gHandle.hPbcastOut		= GetDlgItem(hDlg, IDC_PBCASTOUT);
			gHandle.hLastGapTime	= GetDlgItem(hDlg, IDC_LASTGAPTIME);
			gHandle.hLocalNodeCheck = GetDlgItem(hDlg, IDC_LOCALNODECHECK);
			gHandle.hPbcastIn		= GetDlgItem(hDlg, IDC_PBCASTIN);
			gHandle.hRecvRate		= GetDlgItem(hDlg, IDC_RECVRATE);
			gHandle.hNetRecvRate    = GetDlgItem(hDlg, IDC_DATARECVRATE);
			SendMessage(gHandle.hSlider, TBM_SETRANGE, (WPARAM)(BOOL)TRUE, (LPARAM) MAKELONG(1, MAX_SEND_RATE));
			SendMessage(gHandle.hSlider, TBM_SETPOS, (WPARAM)(BOOL)TRUE, (LPARAM) (LONG) 1);
			if(!_Start())
			{
				EndDialog(hDlg, msg);
			}
			break;
	} /* end switch msg */

	return bRet;

} /* end Dlg_Main() */

/*-------------------------------------------------------------*/
/* Function: Dlg_Min()										   */
/*															   */
/*-------------------------------------------------------------*/
BOOL CALLBACK Dlg_Min(HWND hDlg, UINT msg, UINT wParam, LPARAM lParam)
{
	bool bRet = false;
	char buffer[10];

	switch(msg) {
		case WM_COMMAND:
			switch(wParam)
			{
				case WM_DESTROY:
				case IDC_QUIT:
					bRet = true;
					sim.mRun = false;
					EndDialog(hDlg, msg);
					break;

				case IDC_BUTTONSETFORALL:
					GetWindowText(gHandle.hSendRate, &buffer[0], sizeof(buffer));
					sim.SetForAll(atoi(buffer));
					bRet = true;
					break;

				case IDC_BUTTONSETRATE:
					GetWindowText(gHandle.hSendRate, &buffer[0], sizeof(buffer));
					sim.UpdateMySendRate(atoi(buffer));
					break;
			}
			break;

		case WM_INITDIALOG:
			bRet = true;
			gHandle.hMain		    = hDlg;
			gHandle.hCurrentNode    = GetDlgItem(hDlg, IDC_CURRENTNODE);
			gHandle.hLastViewTime	= GetDlgItem(hDlg, IDC_LASTVIEWTIME2);
			gHandle.hLastViewSize	= GetDlgItem(hDlg, IDC_LASTVIEWSIZE2);
			gHandle.hSendRate		= GetDlgItem(hDlg, IDC_SENDRATE);
			gHandle.hLastGapTime	= GetDlgItem(hDlg, IDC_LASTGAPTIME2);
			gHandle.hSendRate		= GetDlgItem(hDlg, IDC_RATEEDIT);
			SetWindowText(gHandle.hSendRate, "1");
			break;
	} /* end switch msg */

	return bRet;

} /* end Dlg_Min() */

/*-------------------------------------------------------------*/
/* Function: Dlg_Param()									   */
/*															   */
/*-------------------------------------------------------------*/
BOOL CALLBACK Dlg_Param(HWND hDlg, UINT msg, UINT wParam, LPARAM lParam)
{
	bool bRet = true;

	char	buffer[10];
	DWORD	outAddr;

	switch(msg) {
		case WM_COMMAND:
			switch(wParam)
			{
				case WM_DESTROY:
					EndDialog(hDlg, -1);
					break;

				case IDOK:
					gParam.mNumSubnets = 0;
					SendMessage(GetDlgItem(hDlg, IDC_IPADDRESS1), IPM_GETADDRESS, (WPARAM)0, (LPARAM)(LPDWORD)&outAddr);
					if(outAddr)
					{
						gParam.mSubnetList[gParam.mNumSubnets].sin_addr.s_addr = htonl(outAddr);
						gParam.mNumSubnets++;
					}
					SendMessage(GetDlgItem(hDlg, IDC_IPADDRESS2), IPM_GETADDRESS, (WPARAM)0, (LPARAM)(LPDWORD)&outAddr);
					if(outAddr)
					{
						gParam.mSubnetList[gParam.mNumSubnets].sin_addr.s_addr = htonl(outAddr);
						gParam.mNumSubnets++;
					}
					SendMessage(GetDlgItem(hDlg, IDC_IPADDRESS3), IPM_GETADDRESS, (WPARAM)0, (LPARAM)(LPDWORD)&outAddr);
					if(outAddr)
					{
						gParam.mSubnetList[gParam.mNumSubnets].sin_addr.s_addr = htonl(outAddr);
						gParam.mNumSubnets++;
					}
					GetDlgItemText(hDlg, IDC_PERCENTOUTDROP, buffer, 10);
					gParam.mPercentOutDrop = atof(buffer);
					GetDlgItemText(hDlg, IDC_PERCENTINDROP, buffer, 10);
					gParam.mPercentInDrop = atof(buffer);
					if(SendMessage(GetDlgItem(hDlg, IDC_NOGUI), BM_GETCHECK, (WPARAM)0, (LPARAM)0) == BST_CHECKED)
					{
						gui = false;
					}
					EndDialog(hDlg, msg);
					break;

				case IDC_CANCEL:
					EndDialog(hDlg, -1);
					break;

				default:
					bRet = false;
			}
			break;

		case WM_INITDIALOG:
			bRet = true;
			SendMessage(GetDlgItem(hDlg, IDC_IPADDRESS1), IPM_SETADDRESS, (WPARAM)0, (LPARAM)(DWORD)MAKEIPADDRESS(128, 84, 223, 255));
			SendMessage(GetDlgItem(hDlg, IDC_IPADDRESS2), IPM_SETADDRESS, (WPARAM)0, (LPARAM)(DWORD)MAKEIPADDRESS(128, 84, 248, 255));
			SetDlgItemText(hDlg, IDC_PERCENTOUTDROP, "0.0");
			SetDlgItemText(hDlg, IDC_PERCENTINDROP, "0.0");
			break;

		default:
			bRet = false;
	} /* end switch msg */

	return bRet;

} /* end Dlg_Param() */

bool _Stop()
{
	DWORD	retCode = STILL_ACTIVE;
	while(retCode == STILL_ACTIVE)
	{
		Sleep(3);
		GetExitCodeThread(mMainThreadHandle, &retCode);
	}
	return true;
}

bool _Start()
{
	// Thread settings vars
	LPSECURITY_ATTRIBUTES	lpThreadAttributes;
	DWORD					dwStackSize;
	LPTHREAD_START_ROUTINE	lpStartAddress;
	LPVOID					lpParameter;
	DWORD					dwCreationFlags;
	LPDWORD					lpThreadId;

	// Set up the main thread settings.
	lpThreadId			= &mMainThreadId;
	dwCreationFlags		= NULL;
	lpParameter			= NULL;	//Address of this object.		
	dwStackSize			= 0;	//Same as starting parent.
	lpStartAddress		= _SimThread;
	lpThreadAttributes	= NULL;

	// Start the main thread.
	mMainThreadHandle = CreateThread(
		lpThreadAttributes,  // pointer to security attributes
		dwStackSize,         // initial thread stack size
		lpStartAddress,      // pointer to thread function
		lpParameter,         // argument for new thread
		dwCreationFlags,     // creation flags
		lpThreadId           // pointer to receive thread ID
	);
	if(mMainThreadHandle == NULL)
	{
		return false;
	}
	return true;
}

DWORD WINAPI _SimThread(LPVOID lpParameter)
{
	DWORD		 retCode = 0;

	sim.RunTest();

	//Shut down the thread.
	ExitThread(retCode);

	//To avoid warning
	return retCode;
}