#ifndef __C_TRONTEST_H
#define __C_TRONTEST_H

#include "Protocol Stack/cProtocolStack.h"
#include "Network Layer/cNetworkLayer.h"
#include "Debug Layer/cDebugLayer.h"
#include "Pbcast Layer/cPbcastLayer.h"
#include "Pbcast Layer/cPbcastLayerParam.h"
#include "Util/cCriticalSection.h"

#define		STATUS_ALIVE	0
#define		STATUS_DEAD		1
#define		STATUS_SLEEP	2
#define		STATUS_DEFUNCT	3

typedef struct NodeStatus
{
	cEndpoint*	 ep;
	PbcastParams pbcastParam;
	DWORD		 timeToNextEvent;	// either wake up or send.
	DWORD		 sendInterval;		// interval at which this node sends.
	unsigned int seqNum;
	unsigned int sendRate;
	unsigned int recvRate;
	char		 status;
} NodeStatus;

/*
 * cTronSim.h
 *
 * Tests tron using the simulator.
 */
class cTrontest : public cDeliver, cView, cErrorCallback
{

  public:
	bool Deliver(cEndpoint* sender, cMsgBuffer* buffer, int messageType);
	bool ViewHandler(cViewIterator* view);
	bool ErrorCallback(cObject* param, unsigned int type);
	void RunTest();

	// Node navigation
	void NodeUp();
	void NodeDown();

	// Node tricks
	void Kill();
	void KillEmAll();
	void MakeSleep();
	void UpdateSendRate(unsigned int rate);
	void SetForAll();
	void SetForAll(unsigned int rate);
	void UpdateMySendRate(unsigned int rate);

	bool mRun;
	bool mSliderWait;

  private:
	bool _ParseParameters();
	bool _Setup();
	bool _Shutdown();
	void _WPrintNode();	// windows print node.
	void _WPrintNode(unsigned int index);
	void _UpdateSlider(long value);

	// Members
	cCriticalSection mCS;
	unsigned int	 mNumReceived;
	unsigned int     mNumLiveNodes;
	unsigned int	 mCurrentIndex;
	unsigned int	 mNumNodes;
	unsigned int	 mMyIndex;
	cEndpoint*		 mMyEp;
	bool			 mReady;
	NodeStatus		 mMyStatus;
	long			 mOldSliderVal;
	PbcastParams	 mOldParam;
	DWORD			 mLastGapTime;

	unsigned int	 mNetRecvRate;

	// Per node
	NodeStatus*		 mStatus;

	// Stack parameters
	cNetworkLayerParam	mNetParam;
	cDebugLayerParam	mDebugParam;
	cPbcastLayerParam	mPbcastParam;

	// Stack
	cProtocolStack*  mStack;
	cNetworkLayer*	 mNetLayer;
	cDebugLayer*	 mDebugLayer;
	cPbcastLayer*	 mPbcastLayer;
};

#endif