#define VERSION .01

/*
 * main.cpp
 *
 * Simple test program for pbcast system.
 */
#include <stdio.h>
#include "Util\gError.h"
#include "cTronSim.h"
#include <commctrl.h>
#include <stdlib.h>
#include "resource.h"
#include "types.h"

#define MAX_SEND_RATE 30

// Globals :-)
TronSimHandles  gHandle;
TronSimParam	gParam;
cTronSim		sim;
HANDLE			mMainThreadHandle;	// thread handle of the main thread.
DWORD			mMainThreadId;		// id of the main thread.
LRESULT			sliderPos = 0;
LRESULT			newPos;

// Prototypes
BOOL CALLBACK Dlg_Main(HWND hDlg, UINT msg, UINT wParam, LPARAM lParam);
BOOL CALLBACK Dlg_Param(HWND hDlg, UINT msg, UINT wParam, LPARAM lParam);
DWORD WINAPI _SimThread(LPVOID lpParameter);
bool _Start();
bool _Stop();

/*-------------------------------------------------------------*/
/* Function: WinMain()										   */
/*															   */
/*-------------------------------------------------------------*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	lpszCmdLine = lpszCmdLine; //avoids compiler warning
	InitCommonControls();	//necessary :-(
	if(DialogBox (hInstance, MAKEINTRESOURCE(IDD_PARAMDLG), NULL, (DLGPROC)Dlg_Param) == -1) {
		return 1;
	}
	if(DialogBox (hInstance, MAKEINTRESOURCE(IDD_MAINDLG), NULL, (DLGPROC)Dlg_Main) == -1) {
		MessageBox(NULL, "DialogBox call failed", "DOH", MB_OK);
	}
	_Stop();	// Stop main thread after dialog quits -- to prevent lockup.
	return 1;
} /* end WinMain */


/*-------------------------------------------------------------*/
/* Function: Dlg_Main()										   */
/*															   */
/*-------------------------------------------------------------*/
BOOL CALLBACK Dlg_Main(HWND hDlg, UINT msg, UINT wParam, LPARAM lParam)
{
	bool bRet = true;

	switch(msg) {
		case WM_COMMAND:
			switch(wParam)
			{
				case WM_DESTROY:
				case IDC_QUIT:
					sim.mRun = false;
					EndDialog(hDlg, msg);
					break;

				case IDC_KILL:
					sim.Kill();
					break;

				case IDC_SLEEP:
					sim.Sleep();
					break;

				case IDC_SETFORALL:
					sim.SetForAll();
					break;

				default:
					bRet = false;
			}
			break;

		case WM_HSCROLL:
			switch(LOWORD(wParam))
			{
				case SB_LINELEFT:
					sim.AddressLeft();
					break;

				case SB_LINERIGHT:
					sim.AddressRight();
					break;
			}
			break;

		case WM_VSCROLL:
			switch(LOWORD(wParam))
			{
				case SB_LINEDOWN:
					sim.SubnetDown();
					break;

				case SB_LINEUP:
					sim.SubnetUp();
					break;
			}
			break;

		case WM_NOTIFY: 
			//NOTE: I assume that the only control that sends WM_NOTIFY is the slider!!!
			char buffer[10];
			newPos = SendMessage(gHandle.hSlider, TBM_GETPOS, (WPARAM)0, (LPARAM)0);
			if(newPos != sliderPos) 
			{
				sliderPos = newPos;
				SetWindowText(gHandle.hSendRate, itoa(sliderPos, buffer, 10));
				sim.UpdateSendRate(sliderPos);
			}
			break;

		case WM_INITDIALOG:
			bRet = true;
			gHandle.hViewSize		= GetDlgItem(hDlg, IDC_VIEWSIZE);
			gHandle.hCurrentAddress = GetDlgItem(hDlg, IDC_CURRENTADDR);
			gHandle.hCurrentSubnet  = GetDlgItem(hDlg, IDC_CURRENTSUBNET);
			gHandle.hSubnetSize		= GetDlgItem(hDlg, IDC_SUBNETSIZE);
			gHandle.hGossipInterval = GetDlgItem(hDlg, IDC_GOSSIPINT);
			gHandle.hFanout			= GetDlgItem(hDlg, IDC_FANOUT);
			gHandle.hTimeToFail		= GetDlgItem(hDlg, IDC_TIMETOFAIL);
			gHandle.hRetranReq		= GetDlgItem(hDlg, IDC_RETRANREQ);
			gHandle.hRetranRec		= GetDlgItem(hDlg, IDC_RETRANREC);
			gHandle.hFullGosOut		= GetDlgItem(hDlg, IDC_FULLGOSOUT);
			gHandle.hMinGosOut		= GetDlgItem(hDlg, IDC_MINGOSOUT);
			gHandle.hFullGosIn		= GetDlgItem(hDlg, IDC_FULLGOSIN);
			gHandle.hMinGosIn		= GetDlgItem(hDlg, IDC_MINGOSIN);
			gHandle.hTime			= GetDlgItem(hDlg, IDC_TIME);
			gHandle.hLastViewTime	= GetDlgItem(hDlg, IDC_LASTVIEWTIME);
			gHandle.hLastViewSize	= GetDlgItem(hDlg, IDC_LASTVIEWSIZE);
			gHandle.hAlive			= GetDlgItem(hDlg, IDC_ALIVE);
			gHandle.hSlider			= GetDlgItem(hDlg, IDC_SENDRATESLIDE);
			gHandle.hSendRate		= GetDlgItem(hDlg, IDC_SENDRATE);
			gHandle.hPbcastOut		= GetDlgItem(hDlg, IDC_PBCASTOUT);
			gHandle.hPbcastIn		= GetDlgItem(hDlg, IDC_PBCASTIN);
			gHandle.hLastGapTime	= GetDlgItem(hDlg, IDC_LASTGAPTIME);
			SendMessage(gHandle.hSlider, TBM_SETRANGE, (WPARAM)(BOOL)TRUE, (LPARAM) MAKELONG(0, MAX_SEND_RATE));
			SendMessage(gHandle.hSlider, TBM_SETPOS, (WPARAM)(BOOL)TRUE, (LPARAM) (LONG) 0);
			if(!_Start())
			{
				EndDialog(hDlg, msg);
			}
			break;

		default:
			bRet = false;
	} /* end switch msg */

	return bRet;

} /* end Dlg_Main() */

/*-------------------------------------------------------------*/
/* Function: Dlg_Param()									   */
/*															   */
/*-------------------------------------------------------------*/
BOOL CALLBACK Dlg_Param(HWND hDlg, UINT msg, UINT wParam, LPARAM lParam)
{
	bool bRet = true;

	char	buffer[10];


	switch(msg) {
		case WM_COMMAND:
			switch(wParam)
			{
				case WM_DESTROY:
					EndDialog(hDlg, -1);
					break;

				case IDOK:
					GetDlgItemText(hDlg, IDC_NUMSUBNETS, buffer, 10);
					gParam.mNumSubnets = atoi(buffer);
					GetDlgItemText(hDlg, IDC_NUMADDR, buffer, 10);
					gParam.mNodesPerSubnet = atoi(buffer);
					GetDlgItemText(hDlg, IDC_PERCENTOUTDROP, buffer, 10);
					gParam.mPercentOutDrop = atof(buffer);
					GetDlgItemText(hDlg, IDC_PERCENTINDROP, buffer, 10);
					gParam.mPercentInDrop = atof(buffer);
					EndDialog(hDlg, msg);
					break;

				case IDC_CANCEL:
					EndDialog(hDlg, -1);
					break;

				default:
					bRet = false;
			}
			break;

		case WM_INITDIALOG:
			bRet = true;
			SetDlgItemText(hDlg, IDC_NUMSUBNETS, "1");
			SetDlgItemText(hDlg, IDC_NUMADDR, "1");
			SetDlgItemText(hDlg, IDC_PERCENTOUTDROP, "0.0");
			SetDlgItemText(hDlg, IDC_PERCENTINDROP, "0.0");
			break;

		default:
			bRet = false;
	} /* end switch msg */

	return bRet;

} /* end Dlg_Param() */

bool _Stop()
{
	DWORD	retCode = STILL_ACTIVE;
	while(retCode == STILL_ACTIVE)
	{
		Sleep(3);
		GetExitCodeThread(mMainThreadHandle, &retCode);
	}
	return true;
}

bool _Start()
{
	// Thread settings vars
	LPSECURITY_ATTRIBUTES	lpThreadAttributes;
	DWORD					dwStackSize;
	LPTHREAD_START_ROUTINE	lpStartAddress;
	LPVOID					lpParameter;
	DWORD					dwCreationFlags;
	LPDWORD					lpThreadId;

	// Set up the main thread settings.
	lpThreadId			= &mMainThreadId;
	dwCreationFlags		= NULL;
	lpParameter			= NULL;	//Address of this object.		
	dwStackSize			= 0;	//Same as starting parent.
	lpStartAddress		= _SimThread;
	lpThreadAttributes	= NULL;

	// Start the main thread.
	mMainThreadHandle = CreateThread(
		lpThreadAttributes,  // pointer to security attributes
		dwStackSize,         // initial thread stack size
		lpStartAddress,      // pointer to thread function
		lpParameter,         // argument for new thread
		dwCreationFlags,     // creation flags
		lpThreadId           // pointer to receive thread ID
	);
	if(mMainThreadHandle == NULL)
	{
		return false;
	}
	return true;
}

DWORD WINAPI _SimThread(LPVOID lpParameter)
{
	DWORD		 retCode = 0;

	sim.RunTest(6, NULL);

	//Shut down the thread.
	ExitThread(retCode);

	//To avoid warning
	return retCode;
}