#ifndef __C_TRONSIM_H
#define __C_TRONSIM_H

#include "Protocol Stack/cProtocolStack.h"
#include "SimNet Layer/cSimNetLayer.h"
#include "Debug Layer/cDebugLayer.h"
#include "Pbcast Layer/cPbcastLayer.h"

class cSimEngine;

#define		STATUS_ALIVE	0
#define		STATUS_DEAD		1
#define		STATUS_SLEEP	2

typedef struct TronSimParam
{
	unsigned int mNumSubnets;
	unsigned int mNodesPerSubnet;
	double	     mPercentOutDrop;
	double		 mPercentInDrop;
	unsigned int mNumNodes;
} TronSimParam;

typedef struct NodeStatus
{
	DWORD		 timeToNextEvent;	// either wake up or send.
	DWORD		 sendInterval;		// interval at which this node sends.
	unsigned int seqNum;
	unsigned int sendRate;
	char		 status;
} NodeStatus;

/*
 * cTronSim.h
 *
 * Tests tron using the simulator.
 */
class cTronSim : public cDeliver, cView, cErrorCallback
{

  public:
	bool Deliver(cEndpoint* sender, cMsgBuffer* buffer, int messageType);
	bool ViewHandler(cViewIterator* view);
	bool ErrorCallback(cObject* param, unsigned int type);
	void RunTest(unsigned int argc, char** argv);

	// Node navigation
	void AddressLeft();
	void AddressRight();
	void SubnetUp();
	void SubnetDown();

	// Node tricks
	void Kill();
	void Sleep();
	void UpdateSendRate(unsigned int rate);
	void SetForAll();

	bool			mRun;

	// Current node
	unsigned int	mCurrentSubnet;
	unsigned int	mCurrentAddress;

  private:
	bool _ParseParameters(int argc, char* argv[]);
	bool _Setup();
	bool _Shutdown();
	void _InputHandler();
	void _PrintNode();
	void _WPrintNode();	// windows print node.
	void _WPrintNode(unsigned int index);
	void _ComputeCurrentIndex();

	// Simulation members
	TronSimParam	 mParam;
	cSimEngine*		 mEngine;
	cProtocolStack** mStacks;
	unsigned int	 mFullViews;
	unsigned int	 mNumReceived;
	unsigned int     mNumLiveNodes;
	unsigned int	 mCurrentIndex;
	unsigned int	 mNumNodes;

	PbcastParams	 mOldParam;

	// Stack parameters
	cSimNetLayerParam	mSimParam;
	cDebugLayerParam	mDebugParam;
	cPbcastLayerParam	mPbcastParam;

	// Per stack
	cSimNetLayer**	mSimNetLayers;
	cDebugLayer**	mDebugLayers;
	cPbcastLayer**	mPbcastLayers;
	NodeStatus*		mStatus;
};

#endif