// gError.cpp
#include "gError.h"
#include <stdlib.h>

ostream *gErrorStream = 0;
bool	 gErrorPrintInfo = true;

void gSetErrorStream(ostream &errStream)
{
	gErrorStream = &errStream;
}

void gSetPrintInfo(bool value)
{
	gErrorPrintInfo = value;
}

void gError(char* s, int line, const char* file)
{
	if(!gErrorStream) { return; }
	(*gErrorStream) << "[" << file << ":" << line << "] <" << "ERROR" << ">: " << s << endl;	
}


void gInfo(char* s, int line, const char* file)
{
	if(!gErrorPrintInfo) { return; }
	if(!gErrorStream) { return; }
	(*gErrorStream) << "[" << file << ":" << line << "] <" << "INFO" << ">: " << s << endl;	
}

void gAbort(char* s, int line, const char* file)
{
	if(!gErrorStream) { return; }
	(*gErrorStream) << "[" << file << ":" << line << "] <" << "ABORT" << ">: " << s << endl;
	exit(1);
}