#ifndef __CSTACK_H__
#define __CSTACK_H__

#include "cCriticalSection.h"

// Stack exception class
class cStackException { 

 public: 
	cStackException(char *buf)
	{
		strncpy(mString, buf, 127);
		mString[127] = '\0';
	}
	~cStackException() { ; }

	char *ToString()
	{
		return mString;
	}
 private:
	char	mString[128];
};

//cStack class
class cStack
{

 protected:

 public:
		
	//Constructor(s)
	cStack(int size);	

	//Destructor
	~cStack();

	//Public Functions
	bool	Push(void *data);
	bool	Pop(void **data);
	void*	Pop();
	int		GetSize() { return mSize; }
	bool	Resize(int newSize);
	int		GetNumElements()	{ return mStackPtr; }
	void	Lock()				{ mCS.Enter(); }
	void	Unlock()			{ mCS.Leave(); }

	// Mutex
	cCriticalSection	mCS;

 private:

	//Member Vars
	void	**mStack;
	int		  mStackPtr;
	int		  mSize;
};

#endif
