/*
 * cStack.cpp
 * 
 * Class impl. for generic Stack.
 *
 * Authors:  ted
 */
#include "cStack.h"
#include <assert.h>

#ifndef NULL
	#define NULL 0
#endif

/*
 * cStack::cStack()
 *
 * Purpose:	Create a new stack.
 * IN:		size	-> The starting size of the stack.
 * OUT:		-
 * Cond:	-
 * PostCnd:	The stack is set up.
 * Throws:	cStackException
 * Return:	-
 */
cStack::cStack(int size)
{
	mSize			= size;
	mStack			= NULL;
	mStackPtr		= 0;

	// Alloc stack.
	mStack = new void*[size];
	if(!mStack)
	{  
		throw cStackException("<cStack::cStack>: Unable to alloc the stack space.");
	}
}

/*
 * cStack::~cStack()
 *
 * Purpose:	Destroy the stack.
 * IN:		-
 * OUT:		-
 * Cond:	-
 * PostCnd:	The queue is cleaned up.
 * Return:	-
 */
cStack::~cStack()
{
	mCS.Enter();
	if(mStack) { delete[] mStack; }
	mCS.Leave();
}

/*
 * cStack::Resize()
 *
 * Purpose:	Attempt to resize the stack.
 * IN:		newSize		-> The new size for the stack.
 * OUT:		-
 * Cond:	The new size must be larger then the number of elements in stack.
 * PostCnd:	The stack is resized, if successful.
 * Return:	-
 */
bool cStack::Resize(int newSize)
{
	void **newStack;

	mCS.Enter();

	if(newSize < mStackPtr)
	{
		mCS.Leave();
		return false;	// New size not big enough to fit number of elements.
	}

	newStack = new void*[newSize];
	if(!newStack)
	{
		mCS.Leave();
		return false;
	}
	if(mStack)
	{
		for(int i = 0; i < mStackPtr; i++)
		{
			newStack[i] =  mStack[i];
		}
		delete[] mStack;
	}
	mStack = newStack;
	mSize  = newSize;

	mCS.Leave();
	return true;
}

/*
 * cStack::Push()
 *
 * Purpose:	Add an element to the stack.
 * IN:		data	-> A pointer to the obj to put on stack.
 * OUT:		-
 * Cond:	-
 * PostCnd:	The element is placed on the stack.
 * Return:	true if success, else fail.
 */
bool cStack::Push(void *data)
{
	bool	retVal;

	mCS.Enter();

	if(mStackPtr != mSize)
	{
		mStack[mStackPtr] = data;
		mStackPtr++;
		retVal = true;
	}
	else
	{
		retVal = false;
	}

	mCS.Leave();
	return retVal;
}

/*
 * cStack::Pop()
 *
 * Purpose:	Pop an element off the stack.
 * IN:		-
 * OUT:		-
 * Cond:	-
 * PostCnd:	The element is popped off the stack.
 * Return:	Data value, or NULL if fail.
 */
void*	cStack::Pop()
{
	void *retVal;

	mCS.Enter();

	if(mStackPtr != 0)
	{
		mStackPtr--;
		retVal = mStack[mStackPtr];
	}
	else
	{
		retVal = NULL;
	}
	
	mCS.Leave();
	return retVal;
}

/*
 * cStack::Pop()
 *
 * Purpose:	Pop an element off the stack.
 * IN:		-
 * OUT:		data	-> Pointer to the element off the stack.
 * Cond:	-
 * PostCnd:	The element is popped off the stack.
 * Return:	Data value, or NULL if fail.
 */
bool	cStack::Pop(void **data)
{
	bool	retVal;

	mCS.Enter();

	if(mStackPtr != 0)
	{
		mStackPtr--;
		*data = mStack[mStackPtr];
		retVal = true;
	}
	else
	{
		*data = NULL;
		retVal = false;
	}
	
	mCS.Leave();
	return retVal;
}