#ifndef __C_REGISTERLIST_H
#define __C_REGISTERLIST_H

#include "Interfaces/cObject.h"
#include "Protocol Stack/cHandle.h"
#include "cFifo.h"

/*
 * cRegisterList.h
 *
 * A list of registered observers.
 */
class cRegisterList : public cObject
{
  public:
	  cRegisterList(int size);
	  ~cRegisterList();
	  bool					AddObject(cHandle* handle, cObject* object);
	  bool					RemoveObject(cHandle handle);
	  cIterator*			GetIterator();

	  // Locking
	  bool		Lock();
	  bool		Unlock();

  private:
	cFifo*	mList;
	cFifoIterator	mIterator;
};

#endif
