/*
 * cRegisterList.cpp
 *
 * Implementation of registration list.
 */
#include "cRegisterList.h"
#include "cException.h"

/*
 * cRegisterList::cRegisterList()
 *
 * Purpose:	Creates a register list of max entries equal to size.
 * IN:		size		-> The maximum number of registered entries.
 * Cond:	-
 * PostCnd:	The registerlist is set up.
 * Return:	-
 */
cRegisterList::cRegisterList(int size)
{
	mList = NULL;
	mList = new cFifo(size);
	if(!mList)
	{
		throw cException("<cRegisterList::cRegisterList>: Unable to alloc the list structure.");
	}
}

/*
 * cRegisterList::~cRegisterList()
 *
 * Purpose:	Destructor
 */
cRegisterList::~cRegisterList()
{
	if(mList)
	{
		delete mList;
	}
}

/*
 * cRegisterList::AddObject()
 *
 * Purpose:	Adds an object to the registration list.
 * IN:		object		-> Object to add to the list.
 * Cond:	-
 * PostCnd:	The object is added to the registration list.
 * Return:	A handle that can be used to deregister the object.
 */
bool cRegisterList::AddObject(cHandle* handle, cObject* object)
{
	Node *node = mList->Push(object);
	if(!node)
	{
		return false;
	}
	handle->mHandle = (void *)node;
	return true;
}

/*
 * cRegisterList::RemoveObject()
 *
 * Purpose:	Removes an object from the registration list based on the handle.
 * IN:		handle	-> Handle for the object to remove.
 * Cond:	Object should be in registration list.
 * PostCnd:	Object is removed from the registration list.
 * Return:	true if success, otherwise false.
 */
bool	cRegisterList::RemoveObject(cHandle handle)
{
	return mList->Delete((Node *)handle.mHandle);
}


cIterator* cRegisterList::GetIterator()
{
	mIterator = mList->GetIterator();
	return (cIterator *)&mIterator; 
}

bool	cRegisterList::Lock()
{
	mList->Lock();
	return true;
}

bool	cRegisterList::Unlock()
{
	mList->Unlock();
	return true;
}