#ifndef __CHASHTABLE_H__
#define __CHASHTABLE_H__

#include "Interfaces/cObject.h"

#include "Node.h"
#include "cCriticalSection.h"

class cHashTable;

// Hahs exception class.
class cHashException { 

 public: 
	cHashException(char *buf)
	{
		strncpy(mString, buf, 127);
		mString[127] = '\0';
	}
	~cHashException() { ; }

	char *ToString()
	{
		return mString;
	}
 private:
	char	mString[128];
};

// Iterator over the fifo list.
class cHashTableIterator : public cIterator
{
  public:
	cHashTableIterator(cHashTable* table);
	cHashTableIterator() { mTable = NULL; }
	bool		Done();
	cObject*	GetData();
	bool		GetNext();
	bool		DeleteCurrent();
	
  private:
	cHashTable*		mTable;
	Node*			mCurrent;
	unsigned int	mIndex;
};

//cHashTable class.
class cHashTable
{

 protected:

 public:
	friend class cHashTableIterator;
	// Constructor(s)
	cHashTable(int size);	

	// Destructor
	~cHashTable();

	// Public Functions
	Node*	Insert(cHashObject* key, cHashObject* hObj);
	Node*	Find(cHashObject* key, cHashObject** result);
	bool	Delete(Node *node);
	bool	Delete(cHashObject* key);
	void	Lock()		{ mCS.Enter(); }
	void	Unlock()	{ mCS.Leave(); }
	cIterator* GetIterator() { mIter = cHashTableIterator(this); return &mIter; }
	unsigned int GetNumElements() { return mNumElements; }

	// Mutex
	cCriticalSection	mCS;

 private:
	 void	_PushFreeList(Node *node);
	 Node*	_PopFreeList();
	 int	_Hash(cHashObject* key);
	 void	_ResetNode(Node *node);

	//Member Vars
	Node		 *mNodeBlock;
	Node		 *mFreeList;
	Node		**mTable;
	Node		 *mSentinelArray;
	unsigned int  mTableSize;
	unsigned int  mNumElements;
	cHashTableIterator	mIter;
};

#endif
