#ifndef __CFIFO_H__
#define __CFIFO_H__

#include "Interfaces/cObject.h"
#include "Node.h"
#include "cCriticalSection.h"
#include "Protocol Stack/cHandle.h"

class cFifo;

// Fifo exception class.
class cFifoException { 

 public: 
	cFifoException(char *buf)
	{
		strncpy(mString, buf, 127);
		mString[127] = '\0';
	}
	~cFifoException() { ; }

	char *ToString()
	{
		return mString;
	}
 private:
	char	mString[128];
};

// Iterator over the fifo list.
class cFifoIterator : public cIterator
{
  public:
	cFifoIterator()				{ mSentinel = mNode = NULL; }
	cFifoIterator(Node* node, cFifo* fifo)	{ mFifo = fifo; mSentinel = node; mNode = mSentinel->next; }
	bool		Done()			{ return (mNode == mSentinel);  }
	cObject*	GetData();
	bool		GetNext()		{ mNode = mNode->next; return Done(); }
	bool		DeleteCurrent();
	
  private:
	Node*	mSentinel;
	Node*	mNode;
	cFifo*	mFifo;
};


//cFifo class
class cFifo
{

 protected:

 public:
		
	//Constructor(s)
	cFifo(int size);	

	//Destructor
	~cFifo();

	//Public Functions
	Node*	Push(cObject *data);
	bool	Pop(cObject **data);
	Node*	Peek(cObject **data);		// Peeks at data of next element to remove.
	bool	Delete(Node *node);
	void	Lock()  { mCS.Enter(); }// Lock this data structure.
	void	Unlock(){ mCS.Leave(); }// Unlocks this data structure.
	int		GetNumElements()	{ return mNumElements; }
	cFifoIterator GetIterator() { return cFifoIterator(mSentinel, this); }

	// Mutex
	cCriticalSection	mCS;

 private:
	 void	_PushFreeList(Node *node);
	 Node*	_PopFreeList();
	 void	_ResetNode(Node *node);

	//Member Vars
	Node	 *mFreeList;
	Node	 *mBack;
	Node	 *mSentinel;
	int		  mSize;
	int		  mNumElements;
};

#endif
