#ifndef __C_OBJECT_H
#define __C_OBJECT_H

/*
 * CObject.h
 * 
 * Standard base object type.
 */
class cObject { };

class cHashObject : public cObject
{
  public:
	virtual bool Equals(cHashObject* hObj)=0;
	virtual bool LessThan(cHashObject* hObj)=0;
	virtual unsigned int HashCode()=0;
	virtual void AddRef()=0;
	virtual void Release()=0;
};

class cIterator : public cObject
{
  public:
	virtual bool		Done()=0;
	virtual cObject*	GetData()=0;
	virtual bool		GetNext()=0;
	virtual bool		DeleteCurrent()=0;
};

#ifndef NULL
  #define NULL 0
#endif

#endif