#ifndef __C_LAYER_H
#define __C_LAYER_H

#include "Interfaces/cObject.h"
#include "Interfaces/cDeliver.h"
#include "Interfaces/cErrorCallback.h"
#include "Interfaces/cView.h"
#include "Interfaces/cParam.h"

#include "Protocol Stack/cLayerInfo.h"
#include "Protocol Stack/cGroup.h"
#include "Protocol Stack/cMsgBuffer.h"
#include "Protocol Stack/cHandle.h"


#define MSG_TYPE_STANDARD	0	// layers assume it is intended for them.
#define MSG_TYPE_UNICAST	1	// requires network layer
#define MSG_TYPE_BCAST		2	// requires network layer
#define MSG_TYPE_MULTICAST	3	// Requires network layer
#define MSG_TYPE_PBCAST		4	// Requires pbcast  layer
#define MSG_TYPE_NULL		5

/*
 * cLayer.h
 *
 * Interface for a communications layer.
 */
class cLayer : public cObject
{

  public:

	/* --Standard Methods-- */

	// Initialization
	virtual bool Init(cLayer* layerBelow, cParam* param)=0;

	// Cleanup
	virtual bool Cleanup()=0;

	// Sending of messages.
	virtual bool Send(cGroup* dest, cMsgBuffer* buffer, int messageType)=0;

	// Callback Registration/Unregisteration
	virtual bool RegisterDeliverCallback(cHandle* handle, cDeliver* callback)=0;
	virtual bool UnregisterDeliverCallback(cHandle handle)=0;
	virtual bool RegisterViewCallback(cHandle* handle, cView* callback)=0;
	virtual bool UnregisterViewCallback(cHandle handle)=0;
	virtual bool RegisterErrorCallback(cHandle* handle, cErrorCallback* callback)=0;
	virtual bool UnregisterErrorCallback(cHandle handle)=0;

	// Scheduling timeslice
	virtual bool Schedule()=0;

	// Layer information
	cLayerInfo* GetLayerInfo() { return &mLayerInfo; }

	// Callback Methods

  protected:

	// Member Variables
	cLayer*		mLayerBelow;
	cLayerInfo	mLayerInfo;
};

#endif
