#ifndef __C_ERRORCALLBACK_H
#define __C_ERRORCALLBACK_H

#include "Interfaces/cObject.h"

// The following are the possible values for type and how to interpret their paramaeters
#define	ASYNCH_ERROR_EP_FAIL	1
	// This occurs if a remote endpoint is detected as having failed.
	// cObject: a cEndpoint that is equivalent to the endpoint that appears to have failed.

#define ASYNCH_ERROR_MSG_GAP	2
	// This occurs if a layer detects a known gap in the delivery sequence.
	// cObject: NULL

#define ASYNCH_ERROR_SND_FAIL	3
	// This occurs if the eventual sending of a cMsgBuffer on the network fails.
	// cObject: a cMsgBuffer that is the buffer that was trying to be sent.


/*
 * cErrorCallback.h
 *
 * Interface for a error callbacks.
 */
class cErrorCallback : public cObject
{

  public:

	// Callback method
	virtual bool ErrorCallback(cObject* param, unsigned int type)=0;
};

#endif