#ifndef __C_ENDPOINTFACTORY_H
#define __C_ENDPOINTFACTORY_H

#include "Interfaces/cObject.h"
#include "Endpoint/cEndpoint.h"
#include <winsock2.h>

/*
 * cEndpointFactory.h
 *
 * Endpoint factory class that allocates standard endpoint types.
 */
class cEndpointFactory : public cObject
{
  public:

	static cEndpoint*	AllocIPEndpoint(char* address, u_short port);
	static cEndpoint*	AllocSimEndpoint(unsigned int subnet, unsigned int address);
	static bool			ReleaseEndpoint(cEndpoint* ep);

						// Allocates a serialized endpoint from the given buffer, updates the buffer address and size params.
	static cEndpoint*	AllocEndpoint(char** buffer, int *size);
	static cEndpoint*	AllocEndpoint(int type);

	static void			ReportStats(ostream &stream);

  protected:

  private:
	static unsigned int	mEpAlloc;
	static unsigned int mEpFree;
};

#endif