#ifndef __C_ENDPOINT_H
#define __C_ENDPOINT_H

#include <ostream.h>
#include <Interfaces/cObject.h>

class cEndpointFactory;

/* ENDPOINT TYPES */
#define		ENDPOINT_TYPE_NULL	0
#define		ENDPOINT_TYPE_IP	1
#define		ENDPOINT_TYPE_SIM	2

#define		MAX_ENDPOINT_SIZE	11

/*
 * cEndpoint.h
 *
 * Endpoint class.
 */
class cEndpoint : public cHashObject
{
  public:


	// Marshalling
	virtual char*			Serialize(char* buffer, int *size)=0;
	virtual char*			Deserialize(char *buffer, int *size)=0;

	virtual	unsigned int	HashCode()=0;
	virtual unsigned int	GetSize()=0;					// The size that this ep will take when serialized.
	virtual void			Print(ostream &errStream)=0;	// Print to the given stream
	virtual bool			Equals(cHashObject* hObj)=0;
	virtual bool			LessThan(cHashObject* hObj)=0;
	virtual bool			IsSameSubnet(cEndpoint* ep) { return false; }
	virtual bool			SubnetLessThan(cEndpoint* ep)=0;
	virtual cEndpoint*		AllocCopy()=0;
	unsigned int			GetType() { return mType; }

	// Mem
	void AddRef(void) { mRefCount++; }
	void Release(void);

  protected:
	unsigned char		mType;
	int					mRefCount;
};

#endif