#define WIN32_LEAN_AND_MEAN

#include <winsock2.h>
#include <stdlib.h>
#include <memory.h>
#include <ostream.h>

#define UPDATE_INTERVAL  1000
#define MCAST_IP		 "224.0.0.69"
#define MCAST_PORT		  10477

SOCKET		gMcastSock;
sockaddr_in	gMcastAddr;
unsigned long	seqNum = 0;
char		buf[sizeof(seqNum)];

bool InitSockets();
void Sender(unsigned int rate);
void Receiver(unsigned int rate);
bool ShutdownSockets();

void main(int argc, char* argv[])
{
	int rate;

	if(argc < 2)
	{
		cerr << "Usage: mcast <send | recv> <rate>" << endl;
		exit(1);
	}
	if(!InitSockets())
	{
		cerr << "Unable to initialize mcast socket." << endl;
		exit(1);
	}
	if(argc > 2)
	{
		rate = atoi(argv[2]);
	}
	else
	{
		rate = 300;
	}

	cerr << "Starting test.  Setting rate to " << rate << endl;
	if(strcmp(argv[1], "send") == 0)
	{
		Sender(rate);
	}
	else
	{
		Receiver(rate);
	}
	ShutdownSockets();
}

void Sender(unsigned int rate)
{
	DWORD	sendInterval;
	DWORD	nextSendTime = GetTickCount();
	DWORD	nextUpdateTime = GetTickCount() + UPDATE_INTERVAL;
	DWORD	now;
	DWORD	min;

	int		nRet;
	sendInterval = 1000/rate;
	cerr << "Send interval is at: " << sendInterval << endl;

	unsigned oldSeqNumVal = 1;
	nextSendTime = GetTickCount();
	while(1)
	{
		do
		{
			min = min(nextSendTime, nextUpdateTime);
			now = GetTickCount();
			if(now < min)
			{
				Sleep(min - now);
			}
		} while (now < min);
		if(now >= nextSendTime)
		{
			seqNum++;
			memcpy(buf, &seqNum, sizeof(seqNum));
			nRet = sendto(gMcastSock, buf, sizeof(buf), 0, (sockaddr *)&gMcastAddr, sizeof(gMcastAddr));
			if(nRet == SOCKET_ERROR)
			{
				cerr << "Unable to send on socket." << endl;
				return;
			}
			nextSendTime += sendInterval;
		}
		if(GetAsyncKeyState('Q') & 0x01)
		{
			cerr << "Exiting..." << endl;
			return;
		}

		if(now > nextUpdateTime)
		{
			cerr << "Rate: " << 1000*(seqNum-oldSeqNumVal) / UPDATE_INTERVAL << endl;
			nextUpdateTime = now + UPDATE_INTERVAL;
			oldSeqNumVal = seqNum;
		}
	}
}


void Receiver(unsigned int rate)
{
	unsigned oldSeqNumVal = 1;
	DWORD	 lastUpdateTime = 0;
	DWORD	 nextUpdateTime = GetTickCount() + UPDATE_INTERVAL;
	DWORD	 now;
	int	addrSize;
	int nRet;
	unsigned long seqNumIn;
	bool		  seenFirst = false;

	while(1)
	{
		addrSize = sizeof(gMcastAddr);
		nRet = recvfrom(gMcastSock, buf, sizeof(buf), 0, (sockaddr *)&gMcastAddr, &addrSize);
		if(nRet == SOCKET_ERROR)
		{
			if(WSAGetLastError() != WSAEWOULDBLOCK)
			{
				cerr << "Strange error on recv: " << WSAGetLastError() << endl;
				return;
			}
		}
		else
		{
			memcpy(&seqNumIn, buf, sizeof(unsigned long));
			if(!seenFirst)
			{
				oldSeqNumVal = seqNum = seqNumIn;
				cerr << "First seqNum seen is: " << seqNum << endl;
				seenFirst = true;
			}
			if(seqNum != seqNumIn)
			{
				cerr << "Seqnum mismatch.  Got " << seqNumIn << ", expect " << seqNum << endl;
			}
			seqNum++;
		}
		if(GetAsyncKeyState('Q') & 0x01)
		{
			cerr << "Exiting..." << endl;
			return;
		}
		now = GetTickCount();
		if(now > nextUpdateTime)
		{
			cerr << "Rate: " << 1000*(seqNum-oldSeqNumVal) / (now-lastUpdateTime) << endl;
			nextUpdateTime = now + UPDATE_INTERVAL;
			lastUpdateTime = now;
			oldSeqNumVal = seqNum;
		}
	}
}

bool InitSockets()
{
	int nRet;
	WSADATA	wsaData;

	// Set up the local address
	memset(&gMcastAddr, 0, sizeof(sockaddr_in));
	gMcastAddr.sin_family		= AF_INET;
	gMcastAddr.sin_port			= htons(MCAST_PORT);
	gMcastAddr.sin_addr.s_addr	= INADDR_ANY;

	nRet = WSAStartup(0x0202, &wsaData);
	if(nRet)
	{
		cerr << "*WSAStartup failed." << endl;
		return false;
	}

	// Create the socket
	DWORD dwFlags = WSA_FLAG_MULTIPOINT_C_LEAF | WSA_FLAG_MULTIPOINT_D_LEAF;
	gMcastSock = WSASocket(AF_INET, SOCK_DGRAM, IPPROTO_UDP, NULL, NULL, dwFlags);
	if(gMcastSock == INVALID_SOCKET)
	{
		cerr << "*Unable to create socket." << endl;
		return false;
	}

	// Bind the socket
	nRet = bind(gMcastSock, (sockaddr *)&gMcastAddr, sizeof(gMcastAddr));
	if(nRet == SOCKET_ERROR)
	{
		cerr << "*Unable to bind socket." << endl;
		return false;
	}

	gMcastAddr.sin_addr.s_addr = inet_addr(MCAST_IP);
	nRet = WSAJoinLeaf(gMcastSock, (sockaddr *)&gMcastAddr, sizeof(gMcastAddr), NULL, NULL, NULL, NULL, JL_BOTH);
	if(nRet == SOCKET_ERROR)
	{
		cerr << "*Unable to join leaf." << endl;
		return false;
	}
	return true;
}

bool ShutdownSockets()
{
	closesocket(gMcastSock);
	WSACleanup();
	return true;
}