#include "bcast.h"
#include "Protocol Stack/cProtocolStack.h"
#include "Protocol Stack/cBufferManager.h"
#include "Endpoint/cEndpointFactory.h"
#include "Util\gError.h"
#include "Network Layer/cNetworkLayer.h"

#define	 SEND_INTERVAL	3000

/*
 * cBcast::Deliver()
 *
 * Purpose:	Receives any incoming message.
 * Note:	Doesn't need a CS because runs in same thread as the View Handler.
 * IN:		sender			-> the message sender ep
 *			buffer			-> the message
 *			messageType		-> type of message, IGNORED
 * Return:	true if success, else false.
 */
bool cBcast::Deliver(cEndpoint* sender, cMsgBuffer* buffer, int messageType)
{
	cerr << "Deliver: " << mNum++ << endl;
	return true;
}

void cBcast::RunTest(int argc, char* argv[])
{
	mRun = true;	// Start test.
	mNum = 0;
	DWORD	nextSend = 0;

	if(!_ParseParameters())
	{
		gAbort("Unable to parse command line parameters.", __LINE__, __FILE__);
	}
	if(!_Setup())
	{
		gAbort("Unable to set up protocol stack.", __LINE__, __FILE__);
	}

	cEndpoint* dest = cEndpointFactory::AllocIPEndpoint(argv[1], mNetParam.mMulticastPort);
	cGroup*	group = new cGroup(1);
	group->AddEndpoint(dest);
	
	mStack->Start();
	DWORD now;
	while(mRun)
	{
		now  = cProtocolStack::GetTime();
		if(now > nextSend)
		{
			mStack->Send(group, "Hello.", sizeof("Hello."), MSG_TYPE_BCAST);
			nextSend = now + SEND_INTERVAL;
		}
	}
	mStack->Stop();

	if(!_Shutdown())
	{
		gAbort("Unable to shut down properly.", __LINE__, __FILE__);
	}
}


/*
 * cTrontest::_ParseParameters()
 *
 * Purpose:	Parses the command line parameters.
 * IN:		-
 * OUT:		-
 * Cond:	-
 * PostCnd:	All of the *LayerParams should be set up.
 * Throws:	-
 * Return:	true if success, else false.
 */
bool cBcast::_ParseParameters()
{
	mNetParam.ResetToDefault();

	// Handle Net Layer params.
	cEndpoint* mcastEp;
	mcastEp = cEndpointFactory::AllocIPEndpoint("224.0.0.69", mNetParam.mMulticastPort);
	if(!mcastEp)     { return false; }
	mNetParam.mMulticastGroup = (cIPEndpoint *)mcastEp;
	mNetParam.mNetworkOptions = cNetworkLayerParam::UNRELIABLE_BROADCAST | cNetworkLayerParam::UNRELIABLE_MULTICAST;
	return true;
}

/*
 * cTrontest::_Setup()
 *
 * Purpose:	Sets up all of the protocol stacks.  Assumes that the *LayerParams are set up.
 * IN:		-
 * OUT:		-
 * Cond:	All of the *LayerParams should be set up.
 * PostCnd:	-
 * Throws:	-
 * Return:	true if success, else false.
 */
bool cBcast::_Setup()
{
	cHandle				handle;

	// Alloc all of the protocol stacks, layers, etc.
	mStack		  = new cProtocolStack("");
	mNetLayer	  = new cNetworkLayer();
	if(!mStack || !mNetLayer) { return false; }

	// Build the stack.
	if(!(mStack->AddLayer(mNetLayer, &mNetParam)))
	{
		return false;
	}
	if(!(mStack->RegisterDeliverCallback(&handle, this)))
	{
		return false;
	}
	return true;
}

/*
 * cTrontest::_Shutdown()
 *
 * Purpose:	Shuts down the protocol stack and frees everything.
 * IN:		-
 * OUT:		-
 * Cond:	All of the protocol stacks should be set up.
 * PostCnd:	-
 * Throws:	-
 * Return:	true if success, else false.
 */
bool cBcast::_Shutdown()
{
	// Free up extra endpoints.
	mStack->Cleanup();
	delete mStack;
	delete mNetLayer;
	return true;
}

