/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.IIOP;

import IE.Iona.OrbixWeb.IIOP.IOR;
import IE.Iona.OrbixWeb.IIOP.TaggedComponent;

public class iiopBody {
    public byte major;
    public byte minor;
    public String host;
    public int port;
    public int keyLen;
    public byte[] objectKey;
    public TaggedComponent[] components;
    protected int sslport;
    private IOR[] inboundProxies;
    private TaggedComponent firewallComp;

    public iiopBody() {
    }

    public iiopBody(iiopBody iiopBody2) {
        this.major = iiopBody2.major;
        this.minor = iiopBody2.minor;
        this.host = iiopBody2.host;
        this.port = iiopBody2.port;
        this.keyLen = iiopBody2.keyLen;
        this.objectKey = new byte[iiopBody2.objectKey.length];
        System.arraycopy(iiopBody2.objectKey, 0, this.objectKey, 0, iiopBody2.objectKey.length);
        if (iiopBody2.components != null) {
            this.components = new TaggedComponent[iiopBody2.components.length];
            System.arraycopy(iiopBody2.components, 0, this.components, 0, iiopBody2.components.length);
        }
    }

    public iiopBody(byte by, byte by2, String string, int n, byte[] byArray, TaggedComponent[] taggedComponentArray) {
        this.major = by;
        this.minor = by2;
        this.host = string;
        this.port = n;
        this.objectKey = byArray;
        this.keyLen = byArray.length;
        this.components = taggedComponentArray;
    }

    public byte[] object() {
        return this.objectKey;
    }

    public synchronized int getSSLPort() {
        if (this.sslport != 0) {
            return this.sslport;
        }
        if (this.components == null || this.major < 1 || this.minor < 1) {
            return 0;
        }
        int n = 0;
        while (n < this.components.length) {
            if (this.components[n].extractSSLTag()) {
                this.sslport = this.components[n].SSL_port;
            }
            ++n;
        }
        return this.sslport;
    }

    public boolean isFirewallProfile() {
        if (this.firewallComp != null) {
            return true;
        }
        if (this.components == null || this.major < 1 || this.minor < 1) {
            return false;
        }
        int n = 0;
        while (n < this.components.length) {
            if (this.components[n].tag == 3457) {
                this.firewallComp = this.components[n];
                return true;
            }
            ++n;
        }
        return false;
    }

    public IOR iterateInboundProxies(IOR iOR) {
        if (!this.isFirewallProfile() || !this.firewallComp.extractInboundProxiesTag() || this.firewallComp.InboundProxies_iors == null) {
            return null;
        }
        if (iOR == null) {
            return this.firewallComp.InboundProxies_iors[0];
        }
        int n = 0;
        while (n < this.firewallComp.InboundProxies_iors.length) {
            if (this.firewallComp.InboundProxies_iors[n] == iOR && n + 1 < this.firewallComp.InboundProxies_iors.length) {
                return this.firewallComp.InboundProxies_iors[n + 1];
            }
            ++n;
        }
        return null;
    }

    public IOR iterateInboundProxies() {
        return this.iterateInboundProxies(null);
    }

    public void removeComponent(TaggedComponent taggedComponent) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.components.length) {
            if (this.components[n2] == taggedComponent) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            return;
        }
        if (this.components.length == 1) {
            this.components = null;
            return;
        }
        try {
            TaggedComponent[] taggedComponentArray = new TaggedComponent[this.components.length - 1];
            System.arraycopy(this.components, 0, taggedComponentArray, 0, n);
            System.arraycopy(this.components, n + 1, taggedComponentArray, n, this.components.length - 1 - n);
            this.components = taggedComponentArray;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("-- Error!");
            arrayIndexOutOfBoundsException.printStackTrace();
            return;
        }
    }

    public String toString() {
        return "IOPProfile[IIOP" + this.major + "." + this.minor + " host=" + this.host + " port=" + this.port + " " + new String(this.objectKey, 0) + (this.major >= 1 && this.minor >= 1 && this.components != null ? ", " + this.components.length + " components" : "") + "]";
    }
}

