/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.IIOP;

import IE.Iona.OrbixWeb.IIOP.CDRcoder;
import IE.Iona.OrbixWeb.IIOP.TaggedComponent;
import IE.Iona.OrbixWeb.IIOP.iiopBody;

public class TaggedProfile {
    public int profileID;
    public int profileLen;
    public iiopBody profileBody;
    public byte[] multiBody;

    public TaggedProfile() {
    }

    public TaggedProfile(TaggedProfile taggedProfile) {
        this.profileID = taggedProfile.profileID;
        this.profileLen = taggedProfile.profileLen;
        if (this.profileID == 0) {
            this.profileBody = new iiopBody(taggedProfile.profileBody);
            this.multiBody = null;
            return;
        }
        this.profileBody = null;
        this.multiBody = new byte[this.profileLen];
        System.arraycopy(taggedProfile.multiBody, 0, this.multiBody, 0, this.profileLen);
    }

    iiopBody getBody() {
        return this.profileBody;
    }

    protected void makeMultiComponentBody(TaggedComponent[] taggedComponentArray) {
        int n = taggedComponentArray.length;
        CDRcoder cDRcoder = new CDRcoder(128 * taggedComponentArray.length + 1);
        cDRcoder.insertCoderSex();
        cDRcoder.write_ulong(n);
        int n2 = 0;
        while (n2 < n) {
            cDRcoder.write_ulong(taggedComponentArray[n2].tag);
            cDRcoder.write_ulong(taggedComponentArray[n2].data.length);
            cDRcoder.write_octet_array(taggedComponentArray[n2].data, 0, taggedComponentArray[n2].data.length);
            ++n2;
        }
        this.profileLen = cDRcoder.length();
        this.multiBody = new byte[this.profileLen];
        System.arraycopy(cDRcoder.buffer(), 0, this.multiBody, 0, this.profileLen);
    }
}

