/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.Features;

import IE.Iona.OrbixWeb.Features.Config;
import java.util.Vector;

public class SecurityPolicy {
    protected int entityType;
    protected boolean canSecureAccept;
    protected boolean canInsecureAccept;
    protected boolean canSecureConnect;
    protected boolean canInsecureConnect;
    protected boolean canInsecureConnectForAllowedIFs;
    protected boolean trySecureConnectFirst;
    protected Vector allowedInsecureInterfaces;

    public SecurityPolicy() {
        this.resetSecurityPolicy();
    }

    public synchronized void resetSecurityPolicy() {
        try {
            this.setEntityType("SEC_ENT_INSECURE_SERVER_INSECURE_CLIENT");
        }
        catch (Exception exception) {
            System.out.println("Bad default security entity: SEC_ENT_INSECURE_SERVER_INSECURE_CLIENT");
            exception.printStackTrace();
        }
        this.allowedInsecureInterfaces = new Vector();
    }

    public synchronized void setEntityType(int n) {
        this.entityType = n;
        this.canSecureAccept = false;
        this.canInsecureAccept = false;
        this.canSecureConnect = false;
        this.canInsecureConnect = false;
        this.canInsecureConnectForAllowedIFs = false;
        this.trySecureConnectFirst = true;
        switch (n) {
            case 1: {
                this.canSecureConnect = true;
                return;
            }
            case 2: {
                this.canSecureConnect = true;
                this.canInsecureConnectForAllowedIFs = true;
                return;
            }
            case 3: {
                this.canSecureConnect = true;
                this.canInsecureConnect = true;
                this.trySecureConnectFirst = false;
                return;
            }
            case 4: {
                this.canInsecureConnect = true;
                return;
            }
            case 5: {
                this.canSecureAccept = true;
                return;
            }
            case 6: {
                this.canInsecureAccept = true;
                return;
            }
            case 7: {
                this.canSecureAccept = true;
                this.canInsecureAccept = true;
                return;
            }
            case 8: {
                this.canSecureAccept = true;
                this.canSecureConnect = true;
                return;
            }
            case 9: {
                this.canSecureAccept = true;
                this.canSecureConnect = true;
                this.canInsecureConnectForAllowedIFs = true;
                return;
            }
            case 10: {
                this.canSecureAccept = true;
                this.canSecureConnect = true;
                this.canInsecureConnect = true;
                this.trySecureConnectFirst = false;
                return;
            }
            case 11: {
                this.canSecureAccept = true;
                this.canInsecureAccept = true;
                this.canSecureConnect = true;
                return;
            }
            case 12: {
                this.canSecureAccept = true;
                this.canInsecureAccept = true;
                this.canSecureConnect = true;
                this.canInsecureConnectForAllowedIFs = true;
                return;
            }
            case 13: {
                this.canSecureAccept = true;
                this.canInsecureAccept = true;
                this.canInsecureConnect = true;
                return;
            }
            case 14: {
                this.canInsecureAccept = true;
                this.canInsecureConnect = true;
                return;
            }
        }
    }

    public void setEntityType(String string) {
        this.setEntityType(SecurityPolicy.stringToSecEntType(string));
    }

    public synchronized void allowInsecureInterface(String string) {
        String string2 = this.getAllowedInsecureInterface(string);
        if (string2 != null) {
            return;
        }
        this.allowedInsecureInterfaces.addElement(string);
    }

    public synchronized void blockInsecureInterface(String string) {
        String string2 = this.getAllowedInsecureInterface(string);
        if (string2 == null) {
            return;
        }
        this.allowedInsecureInterfaces.removeElement(string2);
    }

    private synchronized String getAllowedInsecureInterface(String string) {
        int n = this.allowedInsecureInterfaces.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.allowedInsecureInterfaces.elementAt(n2);
            if (string2 != null && string.equals(string2)) {
                return string2;
            }
            ++n2;
        }
        return null;
    }

    public static int stringToSecEntType(String string) {
        if (string.equals("SEC_ENT_SECURE_CLIENT")) {
            return 1;
        }
        if (string.equals("SEC_ENT_SEMI_SECURE_CLIENT")) {
            return 2;
        }
        if (string.equals("SEC_ENT_SEMI_INSECURE_CLIENT")) {
            return 3;
        }
        if (string.equals("SEC_ENT_INSECURE_CLIENT")) {
            return 4;
        }
        if (string.equals("SEC_ENT_SECURE_SERVER")) {
            return 5;
        }
        if (string.equals("SEC_ENT_INSECURE_SERVER")) {
            return 6;
        }
        if (string.equals("SEC_ENT_SEMI_SECURE_SERVER")) {
            return 7;
        }
        if (string.equals("SEC_ENT_SECURE_SERVER_SECURE_CLIENT")) {
            return 8;
        }
        if (string.equals("SEC_ENT_SECURE_SERVER_SEMI_SECURE_CLIENT")) {
            return 9;
        }
        if (string.equals("SEC_ENT_SECURE_SERVER_SEMI_INSECURE_CLIENT")) {
            return 10;
        }
        if (string.equals("SEC_ENT_SEMI_SECURE_SERVER_SECURE_CLIENT")) {
            return 11;
        }
        if (string.equals("SEC_ENT_SEMI_SECURE_SERVER_SEMI_SECURE_CLIENT")) {
            return 12;
        }
        if (string.equals("SEC_ENT_SEMI_SECURE_SERVER_INSECURE_CLIENT")) {
            return 13;
        }
        if (string.equals("SEC_ENT_INSECURE_SERVER_INSECURE_CLIENT")) {
            return 14;
        }
        throw new IllegalArgumentException("Unknown sec ent type " + string);
    }

    public static String secEntTypeToString(int n) {
        if (n == 1) {
            return "SEC_ENT_SECURE_CLIENT";
        }
        if (n == 2) {
            return "SEC_ENT_SEMI_SECURE_CLIENT";
        }
        if (n == 3) {
            return "SEC_ENT_SEMI_INSECURE_CLIENT";
        }
        if (n == 4) {
            return "SEC_ENT_INSECURE_CLIENT";
        }
        if (n == 5) {
            return "SEC_ENT_SECURE_SERVER";
        }
        if (n == 6) {
            return "SEC_ENT_INSECURE_SERVER";
        }
        if (n == 7) {
            return "SEC_ENT_SEMI_SECURE_SERVER";
        }
        if (n == 8) {
            return "SEC_ENT_SECURE_SERVER_SECURE_CLIENT";
        }
        if (n == 9) {
            return "SEC_ENT_SECURE_SERVER_SEMI_SECURE_CLIENT";
        }
        if (n == 10) {
            return "SEC_ENT_SECURE_SERVER_SEMI_INSECURE_CLIENT";
        }
        if (n == 11) {
            return "SEC_ENT_SEMI_SECURE_SERVER_SECURE_CLIENT";
        }
        if (n == 12) {
            return "SEC_ENT_SEMI_SECURE_SERVER_SEMI_SECURE_CLIENT";
        }
        if (n == 13) {
            return "SEC_ENT_SEMI_SECURE_SERVER_INSECURE_CLIENT";
        }
        if (n == 14) {
            return "SEC_ENT_INSECURE_SERVER_INSECURE_CLIENT";
        }
        return null;
    }

    public synchronized boolean getCanSecureAccept() {
        return this.canSecureAccept;
    }

    public synchronized boolean getCanInsecureAccept() {
        return this.canInsecureAccept;
    }

    public synchronized boolean getCanSecureConnect() {
        return this.canSecureConnect;
    }

    public synchronized boolean getCanInsecureConnect() {
        return this.canInsecureConnect;
    }

    public synchronized boolean getCanInsecureConnectForAllowedIFs() {
        return this.canInsecureConnectForAllowedIFs;
    }

    public synchronized boolean getTrySecureConnectFirst() {
        return this.trySecureConnectFirst;
    }

    public boolean isAllowedInsecureInterface(String string) {
        return this.canInsecureConnect || this.canInsecureConnectForAllowedIFs && this.getAllowedInsecureInterface(string) != null;
    }

    public synchronized boolean getAuthenticateClients() {
        return Config.get_SECURITY_AUTHENTICATE_CLIENTS();
    }

    public String toString() {
        return "[OrbixWeb Security Policy " + SecurityPolicy.secEntTypeToString(this.entityType) + "]";
    }
}

