/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.Features;

import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.Features.JvmSupport;
import IE.Iona.OrbixWeb._CORBA;
import java.applet.Applet;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.INITIALIZE;

public class Config {
    private static boolean _valid_fields;
    private static boolean _dii_copy_args;
    private static boolean _dsi_copy_args;
    private static boolean _multi_thread_server;
    private static boolean _use_bidir_iiop;
    private static boolean _bind_using_iiop;
    private static boolean _iors_use_dns;
    private static boolean _direct_dispatch;
    private static int _orbixd_iiop_port;
    private static int _orbixd_port;
    private static int _buffer_size;
    private static int _buffer_resize;
    private static int _default_or_kind;
    protected static Applet applet;
    protected static Properties configuration;
    protected static Properties defaultconf;
    protected static Properties cffile;
    protected static Hashtable cache;
    private static boolean usingDefaultsWarningOutput;
    private static boolean suppressWarnings;
    private static boolean foundConfigFile;
    private static final String defaults = "IT_ACCEPT_CONNECTIONS=true\nIT_ALWAYS_CHECK_LOCAL_OBJS=false\nIT_ANY_BUFFER_SIZE=512\nIT_BIND_USING_IIOP=true\nIT_BUFFER_RESIZE=50000\nIT_BUFFER_SIZE=8192\nIT_CONNECTION_TIMEOUT=300000\nIT_DETECT_APPLET_SANDBOX=true\nIT_DII_COPY_ARGS=false\nIT_DIRECT_DISPATCH=false\nIT_DSI_COPY_ARGS=false\nIT_HTTP_TUNNEL_HOST=\nIT_HTTP_TUNNEL_PORT=0\nIT_HTTP_TUNNEL_PREFERRED=false\nIT_HTTP_TUNNEL_PROTO=\nIT_IIOP_LISTEN_PORT=0\nIT_IIOP_PROXY_HOST=\nIT_IIOP_PROXY_PORT=0\nIT_IIOP_PROXY_PREFERRED=false\nIT_IIOP_USE_LOCATOR=true\nIT_IMPL_READY_IF_CONNECTED=true\nIT_IORS_USE_DNS=false\nIT_KEEP_ALIVE_FORWARDER_CONN=true\nIT_LISTENER_PRIORITY=5\nIT_LOCAL_HOSTNAME=\nIT_LOCAL_DOMAIN=\nIT_LOCATE_ATTEMPTS=2\nIT_MARSHAL_NULLS_OK=true\nIT_MULTI_THREADED_SERVER=false\nIT_NAMES_SERVER=NS\nIT_TRADING_SERVER=TDR\nIT_NON_COPYING_ANYS=false\nIT_NS_HOSTNAME=localhost\nIT_NS_IP_ADDR=\nIT_NS_PORT=1571\nIT_OBJECT_CONNECT_TIMEOUT=-1\nIT_OBJECT_TABLE_LOAD_FACTOR=0.75\nIT_OBJECT_TABLE_SIZE=1789\nIT_ORBIXD_SSL_IIOP_PORT=1572\nIT_ORBIXD_IIOP_PORT=1571\nIT_ORBIXD_PORT=1570\nIT_READER_PRIORITY=3\nIT_REQ_CACHE_SIZE=10\nIT_SECURITY_DEFAULT_ENTITY=SEC_ENT_INSECURE_SERVER_INSECURE_CLIENT\nIT_SECURITY_AUTHENTICATE_CLIENTS=false\nIT_SSL_IIOP_LISTEN_PORT=0\nIT_USE_BIDIR_IIOP=false\nIT_USE_EXTENDED_CAPABILITIES=true\nIT_INITIAL_REFERENCES=\nOrbix=BOA\npingDuringBind=true\nsetDiagnostics=1\nIT_CONNECT_TABLE_SIZE_DEFAULT=100\nIT_LOCATOR_HOPS=3\nIT_DEFAULT_CLASSPATH=.\nIT_CLASSPATH_SWITCH=-classpath\nIT_IMPL_IS_READY_TIMEOUT=30000\nIT_IMP_REP_PATH=.\nIT_DAEMON_SERVER_BASE=2000\nIT_DAEMON_SERVER_RANGE=2000\nIT_JAVA_INTERPRETER=java\nIT_JAVA_COMPILER=javac\nIT_NAMES_REPOSITORY_PATH=.\nIT_NAMES_HASH_TABLE_SIZE=23\nIT_NAMES_HASH_TABLE_LOAD_FACTOR=0.5\nIT_NAMES_TIMEOUT=\n";
    private static final int numDefaults = 50;

    public static String getConfigItem(String string) {
        String string2 = string.indexOf(".") < 0 ? "OrbixWeb." + string : string;
        String string3 = (String)Config.getCache().get(string2);
        if (string3 != null) {
            return string3;
        }
        string3 = Config.getConfiguration().getProperty(string2);
        if (string3 != null || applet != null && (string3 = applet.getParameter(string2)) != null || cffile != null && (string3 = cffile.getProperty(string2)) != null || (string3 = Config.getDefaults().getProperty(string)) != null) {
            Config.getCache().put(string2, string3);
            return string3;
        }
        return "";
    }

    public static synchronized void zeroConfiguration() {
        configuration = null;
        applet = null;
        usingDefaultsWarningOutput = false;
        Config.invalidateCache();
    }

    public static synchronized void setConfiguration(Properties properties) {
        Config.addPropertiesOver(Config.getConfiguration(), properties);
        Config.invalidateCache();
    }

    public static synchronized void setConfigItem(String string, String string2) {
        if (string.indexOf(".") < 0) {
            string = "OrbixWeb." + string;
        }
        if (string2 == null) {
            ((Hashtable)Config.getConfiguration()).remove(string);
        } else {
            ((Hashtable)Config.getConfiguration()).put(string, string2);
        }
        Config.invalidateCacheItem(string);
    }

    public static synchronized Properties getConfiguration() {
        if (configuration == null) {
            configuration = new Properties();
        }
        return configuration;
    }

    public static void readProperties(Properties properties) throws INITIALIZE {
        String string;
        Config.addPropertiesOver(Config.getConfiguration(), properties);
        if (properties.getProperty("OrbixWeb.useDefaults", "false").equalsIgnoreCase("true")) {
            suppressWarnings = true;
        }
        if ((string = properties.getProperty("OrbixWeb.config")) != null) {
            Config.readConfigFile(string, false, true);
        }
        Config.invalidateCache();
    }

    public static void readAppletTags(Applet applet) throws INITIALIZE {
        String string;
        Config.applet = applet;
        String string2 = Config.applet.getParameter("OrbixWeb.useDefaults");
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            suppressWarnings = true;
        }
        if ((string = Config.applet.getParameter("OrbixWeb.config")) == null) {
            string = "OrbixWeb.properties";
        }
        Config.readConfigFile(string, true, true);
        Config.invalidateCache();
    }

    public static void readCommandLineArguments(String[] stringArray) throws INITIALIZE {
        Config.readCommandLineArguments("-OrbixWeb.", stringArray);
    }

    public static void readCommandLineArguments(String string, String[] stringArray) throws INITIALIZE {
        Properties properties = new Properties();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            if (stringArray[n].length() >= string.length() && stringArray[n].substring(0, string.length()).equalsIgnoreCase(string) && (n2 = stringArray[n].indexOf(61)) >= 0) {
                String string2 = stringArray[n].substring(string.length(), n2);
                String string3 = stringArray[n].substring(n2 + 1);
                if (string2.equals("useDefaults") && string3.equalsIgnoreCase("true")) {
                    suppressWarnings = true;
                }
                if (string2.equals("config")) {
                    Config.readConfigFile(string3, false, true);
                } else {
                    ((Hashtable)properties).put("OrbixWeb." + string2, string3);
                }
            }
            ++n;
        }
        Config.addPropertiesOver(Config.getConfiguration(), properties);
        Config.invalidateCache();
    }

    public static void readConfigFileFromClasspath() {
        if (!foundConfigFile && !JvmSupport.runningInApplet()) {
            String string = System.getProperty("java.class.path");
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator, false);
            try {
                String string2 = null;
                int n = stringTokenizer.countTokens();
                while (n > 0) {
                    string2 = stringTokenizer.nextToken();
                    foundConfigFile = Config.readConfigFile(String.valueOf(string2) + File.separator + "OrbixWeb.properties", false, false);
                    if (foundConfigFile) {
                        return;
                    }
                    --n;
                }
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            catch (SecurityException securityException) {
                System.err.println("[OrbixWeb: security exception trying to read config file]");
                return;
            }
        }
    }

    public static void printWarningIfNecessary() {
        if (!usingDefaultsWarningOutput && !suppressWarnings) {
            System.err.println("[OrbixWeb warning: failed to load the configuration file \"OrbixWeb.properties\", using defaults]");
            usingDefaultsWarningOutput = true;
        }
    }

    private static boolean readConfigFile(String string, boolean bl, boolean bl2) {
        cffile = new Properties();
        try {
            InputStream inputStream = JvmSupport.openInputStream(string, bl);
            cffile.load(inputStream);
            inputStream.close();
            usingDefaultsWarningOutput = true;
            return true;
        }
        catch (IOException iOException) {
            if (bl2 && !suppressWarnings) {
                System.err.println("OrbixWeb warning: cannot find configuration, using defaults: " + iOException);
            }
            return false;
        }
        catch (SecurityException securityException) {
            System.err.println("[OrbixWeb: security exception trying to read config file]");
            return false;
        }
    }

    protected static void addPropertiesOver(Properties properties, Properties properties2) {
        int n = "OrbixWeb.".length();
        Enumeration enumeration = ((Hashtable)properties2).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() <= n || !string.substring(0, n).equalsIgnoreCase("OrbixWeb.")) continue;
            ((Hashtable)properties).put(string, ((Hashtable)properties2).get(string));
        }
    }

    protected static void addPropertiesUnder(Properties properties, Properties properties2) {
        int n = "OrbixWeb.".length();
        Enumeration enumeration = ((Hashtable)properties2).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() <= n || !string.substring(0, n).equalsIgnoreCase("OrbixWeb.") || ((Hashtable)properties).get(string) != null) continue;
            ((Hashtable)properties).put(string, ((Hashtable)properties2).get(string));
        }
    }

    private static synchronized Properties getDefaults() {
        if (defaultconf == null) {
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(defaults);
            try {
                defaultconf = new Properties();
                defaultconf.load(stringBufferInputStream);
            }
            catch (Exception exception) {
                System.err.println("ERROR - default configuration is bad!");
                exception.printStackTrace();
            }
        }
        return defaultconf;
    }

    public static synchronized void invalidateCache() {
        _valid_fields = false;
        cache = new Hashtable(50);
        ORB.diag = Config.getDiag();
        if (_CORBA.Orbix != null) {
            _CORBA.Orbix.setHostname(Config.get_LOCAL_HOSTNAME());
            _CORBA.Orbix.getSecurityPolicy().setEntityType(Config.get_SECURITY_DEFAULT_ENTITY());
        }
    }

    public static synchronized void invalidateCacheItem(String string) {
        _valid_fields = false;
        Config.getCache().remove(string);
        if (string.equals("OrbixWeb.setDiagnostics")) {
            ORB.diag = Config.getDiag();
            return;
        }
        if (_CORBA.Orbix != null && string.equals("OrbixWeb.IT_LOCAL_HOSTNAME")) {
            _CORBA.Orbix.setHostname(Config.get_LOCAL_HOSTNAME());
            return;
        }
        if (_CORBA.Orbix != null && string.equals("OrbixWeb.IT_SECURITY_DEFAULT_ENTITY")) {
            _CORBA.Orbix.getSecurityPolicy().setEntityType(Config.get_SECURITY_DEFAULT_ENTITY());
        }
    }

    private static synchronized Hashtable getCache() {
        if (cache == null) {
            Config.invalidateCache();
        }
        return cache;
    }

    public static String getOrbType() {
        String string = Config.getConfigItem("Orbix");
        return string;
    }

    public static int getDiag() {
        try {
            String string = Config.getConfigItem("setDiagnostics");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static boolean getPingDuringBind() {
        String string = Config.getConfigItem("pingDuringBind");
        return Boolean.valueOf(string);
    }

    public static boolean get_BIND_USING_IIOP() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _bind_using_iiop;
    }

    public static int get_ORBIXD_PORT() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _orbixd_port;
    }

    public static int get_ORBIXD_IIOP_PORT() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _orbixd_iiop_port;
    }

    public static int get_ORBIXD_SSL_IIOP_PORT() {
        try {
            String string = Config.getConfigItem("IT_ORBIXD_SSL_IIOP_PORT");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static boolean get_ACCEPT_CONNECTIONS() {
        String string = Config.getConfigItem("IT_ACCEPT_CONNECTIONS");
        return Boolean.valueOf(string);
    }

    public static int get_IIOP_LISTEN_PORT() {
        try {
            String string = Config.getConfigItem("IT_IIOP_LISTEN_PORT");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int get_SSL_IIOP_LISTEN_PORT() {
        try {
            String string = Config.getConfigItem("IT_SSL_IIOP_LISTEN_PORT");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int get_OBJECT_TABLE_SIZE() {
        try {
            String string = Config.getConfigItem("IT_OBJECT_TABLE_SIZE");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static float get_OBJECT_TABLE_LOAD_FACTOR() {
        String string = Config.getConfigItem("IT_OBJECT_TABLE_LOAD_FACTOR");
        return Float.valueOf(string).floatValue();
    }

    public static String get_LOCAL_HOSTNAME() {
        String string = Config.getConfigItem("IT_LOCAL_HOSTNAME");
        return string;
    }

    public static String get_LOCAL_DOMAIN() {
        String string = Config.getConfigItem("IT_LOCAL_DOMAIN");
        return string;
    }

    public static short get_LISTENER_PRIORITY() {
        try {
            String string = Config.getConfigItem("IT_LISTENER_PRIORITY");
            return (short)Integer.valueOf(string).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static short get_READER_PRIORITY() {
        try {
            String string = Config.getConfigItem("IT_READER_PRIORITY");
            return (short)Integer.valueOf(string).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int get_BUFFER_SIZE() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _buffer_size;
    }

    public static int get_BUFFER_RESIZE() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _buffer_resize;
    }

    public static int get_ANY_BUFFER_SIZE() {
        try {
            String string = Config.getConfigItem("IT_ANY_BUFFER_SIZE");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int get_CONNECTION_TIMEOUT() {
        try {
            String string = Config.getConfigItem("IT_CONNECTION_TIMEOUT");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int get_OBJECT_CONNECT_TIMEOUT() {
        try {
            String string = Config.getConfigItem("IT_OBJECT_CONNECT_TIMEOUT");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static short get_LOCATOR_HOPS() {
        try {
            String string = Config.getConfigItem("IT_LOCATOR_HOPS");
            return (short)Integer.valueOf(string).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static short get_CONNECT_TABLE_SIZE_DEFAULT() {
        try {
            String string = Config.getConfigItem("IT_CONNECT_TABLE_SIZE_DEFAULT");
            return (short)Integer.valueOf(string).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static short get_REQ_CACHE_SIZE() {
        try {
            String string = Config.getConfigItem("IT_REQ_CACHE_SIZE");
            return (short)Integer.valueOf(string).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String get_NS_HOSTNAME() {
        String string = Config.getConfigItem("IT_NS_HOSTNAME");
        return string;
    }

    public static String get_NS_IP_ADDR() {
        String string = Config.getConfigItem("IT_NS_IP_ADDR");
        return string;
    }

    public static String get_NAMES_SERVER() {
        String string = Config.getConfigItem("IT_NAMES_SERVER");
        return string;
    }

    public static String get_TRADING_SERVER() {
        String string = Config.getConfigItem("IT_TRADING_SERVER");
        return string;
    }

    public static int get_NS_PORT() {
        try {
            String string = Config.getConfigItem("IT_NS_PORT");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static boolean get_IIOP_USE_LOCATOR() {
        String string = Config.getConfigItem("IT_IIOP_USE_LOCATOR");
        return Boolean.valueOf(string);
    }

    public static short get_LOCATE_ATTEMPTS() {
        try {
            String string = Config.getConfigItem("IT_LOCATE_ATTEMPTS");
            return (short)Integer.valueOf(string).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static boolean get_MULTI_THREADED_SERVER() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _multi_thread_server;
    }

    public static boolean get_IMPL_READY_IF_CONNECTED() {
        String string = Config.getConfigItem("IT_IMPL_READY_IF_CONNECTED");
        return Boolean.valueOf(string);
    }

    public static boolean get_IORS_USE_DNS() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _iors_use_dns;
    }

    public static boolean get_ALWAYS_CHECK_LOCAL_OBJS() {
        String string = Config.getConfigItem("IT_ALWAYS_CHECK_LOCAL_OBJS");
        return Boolean.valueOf(string);
    }

    public static boolean get_MARSHAL_NULLS_OK() {
        String string = Config.getConfigItem("IT_MARSHAL_NULLS_OK");
        return Boolean.valueOf(string);
    }

    public static boolean get_DII_COPY_ARGS() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _dii_copy_args;
    }

    public static boolean get_DSI_COPY_ARGS() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _dsi_copy_args;
    }

    public static boolean get_NON_COPYING_ANYS() {
        String string = Config.getConfigItem("IT_NON_COPYING_ANYS");
        return Boolean.valueOf(string);
    }

    public static boolean get_DIRECT_DISPATCH() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _direct_dispatch;
    }

    public static boolean get_KEEP_ALIVE_FORWARDER_CONN() {
        String string = Config.getConfigItem("IT_KEEP_ALIVE_FORWARDER_CONN");
        return Boolean.valueOf(string);
    }

    public static boolean get_USE_BIDIR_IIOP() {
        if (!_valid_fields) {
            Config.update_fields();
        }
        return _use_bidir_iiop;
    }

    public static boolean get_USE_EXTENDED_CAPABILITIES() {
        String string = Config.getConfigItem("IT_USE_EXTENDED_CAPABILITIES");
        return Boolean.valueOf(string);
    }

    public static boolean get_SECURITY_AUTHENTICATE_CLIENTS() {
        String string = Config.getConfigItem("IT_SECURITY_AUTHENTICATE_CLIENTS");
        return Boolean.valueOf(string);
    }

    public static boolean get_IIOP_PROXY_PREFERRED() {
        String string = Config.getConfigItem("IT_IIOP_PROXY_PREFERRED");
        return Boolean.valueOf(string);
    }

    public static String get_IIOP_PROXY_HOST() {
        String string = Config.getConfigItem("IT_IIOP_PROXY_HOST");
        return string;
    }

    public static int get_IIOP_PROXY_PORT() {
        try {
            String string = Config.getConfigItem("IT_IIOP_PROXY_PORT");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static boolean get_HTTP_TUNNEL_PREFERRED() {
        String string = Config.getConfigItem("IT_HTTP_TUNNEL_PREFERRED");
        return Boolean.valueOf(string);
    }

    public static String get_HTTP_TUNNEL_HOST() {
        String string = Config.getConfigItem("IT_HTTP_TUNNEL_HOST");
        return string;
    }

    public static int get_HTTP_TUNNEL_PORT() {
        try {
            String string = Config.getConfigItem("IT_HTTP_TUNNEL_PORT");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String get_HTTP_TUNNEL_PROTO() {
        String string = Config.getConfigItem("IT_HTTP_TUNNEL_PROTO");
        return string;
    }

    public static String get_SECURITY_DEFAULT_ENTITY() {
        String string = Config.getConfigItem("IT_SECURITY_DEFAULT_ENTITY");
        return string;
    }

    public static String get_INITIAL_REFERENCES() {
        String string = Config.getConfigItem("IT_INITIAL_REFERENCES");
        return string;
    }

    public static String get_DEFAULT_CLASSPATH() {
        String string = Config.getConfigItem("IT_DEFAULT_CLASSPATH");
        return string;
    }

    public static int get_IMPL_IS_READY_TIMEOUT() {
        try {
            String string = Config.getConfigItem("IT_IMPL_IS_READY_TIMEOUT");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String get_IMP_REP_PATH() {
        String string = Config.getConfigItem("IT_IMP_REP_PATH");
        return string;
    }

    public static int get_DAEMON_SERVER_BASE() {
        try {
            String string = Config.getConfigItem("IT_DAEMON_SERVER_BASE");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int get_DAEMON_SERVER_RANGE() {
        try {
            String string = Config.getConfigItem("IT_DAEMON_SERVER_RANGE");
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String get_JAVA_INTERPRETER() {
        String string = Config.getConfigItem("IT_JAVA_INTERPRETER");
        return string;
    }

    public static String get_OUTBOUND_IIOP_PROXY() {
        String string = Config.getConfigItem("IT_OUTBOUND_IIOP_PROXY");
        return string;
    }

    public static String get_INTRANET_DOMAINS() {
        String string = Config.getConfigItem("IT_INTRANET_DOMAINS");
        return string;
    }

    public static boolean get_DETECT_APPLET_SANDBOX() {
        String string = Config.getConfigItem("IT_DETECT_APPLET_SANDBOX");
        return Boolean.valueOf(string);
    }

    public static String defaultConfigFile() {
        String string = System.getProperty("line.separator", "\n");
        try {
            DataInputStream dataInputStream = new DataInputStream(new StringBufferInputStream(defaults));
            String string2 = "# OrbixWeb properties file. You really should use \"owconfig\" to edit this." + string;
            string2 = String.valueOf(string2) + "# Note that backslash is an escape character in this format, so any paths on" + string;
            string2 = String.valueOf(string2) + "# NT or Windows 95 need to use double backslashes!" + string;
            String string3 = null;
            while ((string3 = dataInputStream.readLine()) != null) {
                string2 = String.valueOf(string2) + "OrbixWeb." + string3 + string;
            }
            dataInputStream.close();
            return string2;
        }
        catch (IOException iOException) {
            System.err.println("Failed to read defaults: " + iOException);
            return null;
        }
    }

    private static synchronized void update_fields() {
        String string = Config.getConfigItem("IT_DII_COPY_ARGS");
        _dii_copy_args = Boolean.valueOf(string);
        string = Config.getConfigItem("IT_DSI_COPY_ARGS");
        _dsi_copy_args = Boolean.valueOf(string);
        string = Config.getConfigItem("IT_MULTI_THREADED_SERVER");
        _multi_thread_server = Boolean.valueOf(string);
        string = Config.getConfigItem("IT_USE_BIDIR_IIOP");
        _use_bidir_iiop = Boolean.valueOf(string);
        string = Config.getConfigItem("IT_BIND_USING_IIOP");
        _bind_using_iiop = Boolean.valueOf(string);
        string = Config.getConfigItem("IT_IORS_USE_DNS");
        _iors_use_dns = Boolean.valueOf(string);
        string = Config.getConfigItem("IT_DIRECT_DISPATCH");
        _direct_dispatch = Boolean.valueOf(string);
        try {
            string = Config.getConfigItem("IT_ORBIXD_PORT");
            _orbixd_port = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            string = Config.getConfigItem("IT_ORBIXD_IIOP_PORT");
            _orbixd_iiop_port = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            string = Config.getConfigItem("IT_BUFFER_SIZE");
            _buffer_size = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            string = Config.getConfigItem("IT_BUFFER_RESIZE");
            _buffer_resize = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {}
        _valid_fields = true;
    }

    static {
        _bind_using_iiop = true;
        _orbixd_iiop_port = 1571;
        _orbixd_port = 1570;
        _buffer_size = 8192;
        _buffer_resize = 50000;
    }
}

