/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.CORBA;

import IE.Iona.OrbixWeb.CORBA.ConnectTable;
import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.Features.JvmSupport;
import IE.Iona.OrbixWeb.IIOP.IOR;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class SocketConnection {
    protected InputStream in_socket;
    protected OutputStream out_socket;
    protected Socket data_socket;
    public int port;
    public String host;
    public IOR target_object;

    public SocketConnection() {
    }

    public SocketConnection(Socket socket) throws IOException {
        this.data_socket = socket;
        this.in_socket = this.data_socket.getInputStream();
        this.out_socket = this.data_socket.getOutputStream();
        this.host = null;
        try {
            this.host = this.data_socket.getInetAddress().getHostName();
        }
        catch (Exception exception) {
            System.out.println("[OrbixWeb: failed to resolve hostname using DNS due to security restrictions]");
        }
        if (this.host == null) {
            try {
                this.host = this.data_socket.getInetAddress().getHostAddress();
            }
            catch (Exception exception) {
                System.out.println("[OrbixWeb: failed to get IP address of connection " + this.data_socket.toString() + " due to security restrictions]");
                throw new IOException(exception.toString());
            }
        }
        this.port = this.data_socket.getPort();
        this.target_object = null;
    }

    public SocketConnection(String string, int n, IOR iOR) throws IOException {
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            int n2 = 0;
            while (n2 < inetAddressArray.length) {
                try {
                    this.data_socket = new Socket(inetAddressArray[n2], n);
                    break;
                }
                catch (Exception exception) {
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
        if (this.data_socket == null) {
            this.data_socket = new Socket(this.avoidAppletSecurityBug(string), n);
        }
        this.in_socket = this.data_socket.getInputStream();
        this.out_socket = this.data_socket.getOutputStream();
        this.host = string;
        this.port = n;
        this.target_object = iOR;
    }

    public synchronized void close() throws IOException {
        this.data_socket.close();
        this.data_socket = null;
        this.in_socket = null;
        this.out_socket = null;
        this.host = null;
        this.port = 0;
        this.target_object = null;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out_socket.write(byArray, n, n2);
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 != 0) {
            int n3;
            for (int i = 0; i < n2; i += n3) {
                n3 = this.in_socket.read(byArray, i + n, n2 - i);
                if (n3 >= 0) continue;
                throw new EOFException();
            }
            return;
        }
        if (n == 0) {
            byArray[0] = 0;
        }
    }

    public void testConnection() throws IOException {
        if (this.data_socket == null) {
            throw new SocketException("connection is closed");
        }
    }

    public String avoidAppletSecurityBug(String string) {
        String string2;
        if (ORB.codeBase != null && JvmSupport.runningInApplet() && ConnectTable.HostCompare(string, string2 = ORB.codeBase.getHost())) {
            string = string2;
        }
        return string;
    }

    public String toString() {
        return "SocketConnection[" + this.data_socket.toString() + "]";
    }

    public Object getConnectionObject() {
        return this.data_socket;
    }

    public boolean authenticationFailed() {
        return false;
    }

    public void completeHandshake() {
    }
}

