/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.CORBA;

import IE.Iona.OrbixWeb.CORBA.BaseObject;
import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.CORBA.ObjectRef;
import IE.Iona.OrbixWeb.CORBA.ServerObjectMgr;
import IE.Iona.OrbixWeb.Features.Config;
import IE.Iona.OrbixWeb.IIOP.IOR;
import IE.Iona.OrbixWeb._CORBA;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.StringHolder;

public class ServerObjectTable {
    Hashtable objectTable = new Hashtable(Config.get_OBJECT_TABLE_SIZE(), Config.get_OBJECT_TABLE_LOAD_FACTOR());

    public synchronized void cleanUp() {
        Enumeration enumeration = this.objectTable.elements();
        ServerObjectMgr serverObjectMgr = null;
        BaseObject baseObject = null;
        try {
            while (true) {
                serverObjectMgr = (ServerObjectMgr)enumeration.nextElement();
                baseObject = (BaseObject)serverObjectMgr.getObj();
                baseObject._save(0);
                this.remove(serverObjectMgr);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.objectTable.clear();
            System.gc();
            return;
        }
    }

    protected synchronized short changeObjectMarker(String string, String string2, String string3) {
        ServerObjectMgr serverObjectMgr = (ServerObjectMgr)this.objectTable.get(string3);
        if (serverObjectMgr != null) {
            return -1;
        }
        ServerObjectMgr serverObjectMgr2 = this.findObject(string2, string);
        if (serverObjectMgr2 == null) {
            return 0;
        }
        this.remove(string2, string);
        if (_CORBA.Orbix.doUseLoaders()) {
            StringHolder stringHolder = new StringHolder(string3);
            if (serverObjectMgr2.getObj()._loader().rename(serverObjectMgr2.getObj(), stringHolder)) {
                string3 = stringHolder.value;
            }
        }
        ((BaseObject)serverObjectMgr2.getObj())._updateMarker(string3);
        this.record(serverObjectMgr2);
        return 1;
    }

    public ServerObjectMgr findObject(String string, String string2) {
        ServerObjectMgr serverObjectMgr;
        if (string == null || string.equals("")) {
            serverObjectMgr = _CORBA.Orbix.orbixObjectTable().consultByType(string2);
            if (serverObjectMgr == null && ORB.diag >= 2) {
                System.out.println("[ Anonymous bind failed on type '" + string2 + "' ]");
            }
        } else {
            serverObjectMgr = _CORBA.Orbix.orbixObjectTable().consultByMarker(string, string2);
        }
        return serverObjectMgr;
    }

    public synchronized void record(ServerObjectMgr serverObjectMgr) {
        ServerObjectMgr serverObjectMgr2;
        String string = serverObjectMgr.getMarker();
        String string2 = serverObjectMgr.getInterfaceType();
        if (ORB.diag >= 2) {
            System.out.println("Recording object " + string + " of type " + string2);
        }
        if ((serverObjectMgr2 = (ServerObjectMgr)this.objectTable.get(string)) == serverObjectMgr) {
            return;
        }
        if (serverObjectMgr2 != null) {
            String string3 = "object marker already in use : " + string;
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new BAD_PARAM(string3, 12228, completionStatus);
        }
        this.objectTable.put(string, serverObjectMgr);
        String[] stringArray = serverObjectMgr.getImplObj()._ids();
        int n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n];
            String string4 = this.mangleTypeID(string2);
            serverObjectMgr2 = (ServerObjectMgr)this.objectTable.get(string4);
            if (serverObjectMgr2 == null) {
                if (ORB.diag >= 2) {
                    System.out.println("[ Recording object for anonymous bind for type " + string2 + " ]");
                }
                this.objectTable.put(string4, serverObjectMgr);
            }
            ++n;
        }
        if (this.objectTable.get(":CORBA_Object") == null) {
            this.objectTable.put(":CORBA_Object", serverObjectMgr);
        }
    }

    public ServerObjectMgr consultByMarker(String string, String string2) {
        ServerObjectMgr serverObjectMgr;
        if (ORB.diag >= 2) {
            System.out.println("[ Consulting Object Table by marker " + string + " ]");
        }
        if ((serverObjectMgr = (ServerObjectMgr)this.objectTable.get(string)) == null) {
            return serverObjectMgr;
        }
        String string3 = string2;
        try {
            int n = string3.length();
            if (string3.charAt(n - 1) == '\u0000') {
                string3 = string3.substring(0, n - 1);
            }
        }
        catch (Exception exception) {}
        if (serverObjectMgr.getInterfaceType().equals(string3)) {
            return serverObjectMgr;
        }
        if (string3.equals("CORBA_Object")) {
            return serverObjectMgr;
        }
        String[] stringArray = serverObjectMgr.getImplObj()._ids();
        boolean bl = false;
        int n = 0;
        while (!bl && n < stringArray.length) {
            if (string3.equals(IOR.toOrbixType(stringArray[n]))) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        return serverObjectMgr;
    }

    public ServerObjectMgr consultByType(String string) {
        if (ORB.diag >= 2) {
            System.out.println("[ Consulting Object Table by type " + string + " ]");
        }
        String string2 = this.mangleInterfaceType(string);
        return (ServerObjectMgr)this.objectTable.get(string2);
    }

    public void reSize(int n) {
    }

    public synchronized void reOrganise(String string) {
        Enumeration enumeration = this.objectTable.elements();
        while (enumeration.hasMoreElements()) {
            ServerObjectMgr serverObjectMgr = (ServerObjectMgr)enumeration.nextElement();
            if (serverObjectMgr == null) continue;
            serverObjectMgr.changeImplementation(string);
        }
    }

    public void remove(ServerObjectMgr serverObjectMgr) {
        this.remove(serverObjectMgr.getMarker(), serverObjectMgr.getInterfaceType());
    }

    public synchronized void remove(String string, String string2) {
        ServerObjectMgr serverObjectMgr = null;
        serverObjectMgr = (ServerObjectMgr)this.objectTable.get(string);
        this.objectTable.remove(string);
        if (serverObjectMgr != null) {
            ServerObjectMgr serverObjectMgr2;
            String[] stringArray = serverObjectMgr.getImplObj()._ids();
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                String string3 = this.mangleTypeID(string2);
                serverObjectMgr2 = (ServerObjectMgr)this.objectTable.get(string3);
                if (serverObjectMgr2 != null && serverObjectMgr2.getImplObj() == serverObjectMgr.getImplObj()) {
                    this.objectTable.remove(string3);
                }
                ++n;
            }
            serverObjectMgr2 = (ServerObjectMgr)this.objectTable.get(":CORBA_Object");
            if (serverObjectMgr2 != null && serverObjectMgr2.getImplObj() == serverObjectMgr.getImplObj()) {
                this.objectTable.remove(":CORBA_Object");
            }
        }
    }

    public String mangleTypeID(String string) {
        return this.mangleInterfaceType(IOR.toOrbixType(string));
    }

    public String mangleInterfaceType(String string) {
        return ":" + string;
    }

    public boolean isEmpty() {
        return this.objectTable.isEmpty();
    }

    public Vector serverObjects(String string) {
        Vector<ObjectRef> vector = new Vector<ObjectRef>(this.objectTable.size());
        Enumeration enumeration = this.objectTable.elements();
        while (enumeration.hasMoreElements()) {
            ServerObjectMgr serverObjectMgr = (ServerObjectMgr)enumeration.nextElement();
            if (serverObjectMgr == null || string != null && !serverObjectMgr.getObj()._implementation().equals(string)) continue;
            vector.addElement(serverObjectMgr.getObj());
        }
        return vector;
    }
}

