/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.CORBA;

import IE.Iona.OrbixWeb.CORBA.ClientConnection;
import IE.Iona.OrbixWeb.CORBA.EventHandler;
import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.CORBA.SocketConnection;
import IE.Iona.OrbixWeb.Features.Config;
import IE.Iona.OrbixWeb._CORBA;
import java.io.IOException;
import java.net.Socket;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

public class ServerConnection
extends ClientConnection {
    private static int _numClients;

    public ServerConnection(Socket socket) {
        try {
            this.socket = new SocketConnection(socket);
        }
        catch (IOException iOException) {
            String string = iOException.toString();
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new COMM_FAILURE(string, 10088, completionStatus);
        }
        catch (Exception exception) {
            String string = exception.toString();
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new COMM_FAILURE(string, 10088, completionStatus);
        }
        this.startReceiver();
    }

    protected ServerConnection() {
    }

    protected void startReceiver() {
        this.is_open = true;
        this.port = this.socket.port;
        this.host = this.socket.host;
        if (_CORBA.connection_callback != null) {
            _CORBA.connection_callback.OpenCallBack(this.server, this.getConnectionObject());
        }
        this.recv_thread = new Thread((Runnable)this, this.toString());
        try {
            this.recv_thread.setDaemon(true);
            this.recv_thread.setPriority(Config.get_READER_PRIORITY());
            this.recv_thread.setName(this.toString());
        }
        catch (Exception exception) {
            System.out.println("Ignore Previous exception");
        }
        this._fromClient = true;
        ++_numClients;
        if (ORB.diag >= 1) {
            System.out.println("[ " + _CORBA.Orbix.myServer() + ": New Connection (" + this.host + ":" + this.port + ") ]");
        }
        this.recv_thread.start();
    }

    public boolean close() {
        EventHandler.unTrackServerConnection(this);
        return super.close();
    }

    public String toString() {
        return "OrbixWeb Server Reader: " + this.socket.toString();
    }

    protected boolean isSecureConnection() {
        return false;
    }

    protected static int numClients() {
        return _numClients;
    }

    protected static void addClient() {
        ++_numClients;
    }

    protected static void removeClient() {
        --_numClients;
    }
}

