/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.CORBA;

import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.CORBA.SocketConnection;
import IE.Iona.OrbixWeb.Features.Config;
import IE.Iona.OrbixWeb.IIOP.IOR;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Vector;

public class HttpSocketConnection
extends SocketConnection {
    private String[] toBase64Table;
    private byte[] fromBase64Table;
    private byte[] b640tobyte0Table;
    private byte[] b641tobyte0Table;
    private byte[] b641tobyte1Table;
    private byte[] b642tobyte1Table;
    private byte[] b642tobyte2Table;
    private byte[] replyBuf;
    private int replyCursor;
    private Boolean readingResponse = Boolean.FALSE;
    private Thread waitingReaderThread;
    protected URLConnection conn;
    public int port;
    public String host;
    public IOR target_object;
    public String httpProto;
    public String httpHost;
    public int httpPort;
    static Vector testedHttpServers = null;

    public HttpSocketConnection(String string, int n, IOR iOR) throws IOException, UnknownHostException {
        this.host = string;
        this.port = n;
        this.target_object = iOR;
        if (Config.get_HTTP_TUNNEL_HOST() != null) {
            this.httpHost = Config.get_HTTP_TUNNEL_HOST();
            this.httpPort = Config.get_HTTP_TUNNEL_PORT();
            this.httpProto = Config.get_HTTP_TUNNEL_PROTO();
            return;
        }
        if (ORB.codeBase != null) {
            this.httpHost = ORB.codeBase.getHost();
            this.httpPort = ORB.codeBase.getPort();
            this.httpProto = ORB.codeBase.getProtocol();
            return;
        }
        this.httpHost = null;
        this.httpPort = 0;
        this.httpProto = null;
    }

    public synchronized void close() throws IOException {
        this.conn = null;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object;
        this.replyBuf = null;
        if (this.httpHost == null || this.httpHost.equals("") || this.httpProto == null || this.httpProto.equals("") || this.httpPort == 0) {
            throw new SocketException("HTTP tunneling only enabled for applets");
        }
        try {
            object = new URL(String.valueOf(this.httpProto) + "://" + this.httpHost + ":" + this.httpPort + "/cgi-bin/tunnel?host=" + this.host + "&port=" + this.port + (this.target_object != null ? "&ior=" + this.target_object.to_string() : ""));
            this.conn = ((URL)object).openConnection();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("MalformedURLException: " + malformedURLException);
        }
        object = null;
        this.conn.setDoOutput(true);
        this.conn.getRequestProperty("Content-type");
        Object object2 = this.conn.getOutputStream();
        new PrintStream((OutputStream)object2);
        String string = this.toBase64(byArray, n, n2);
        char[] cArray = ("data=" + string).toCharArray();
        byte[] byArray2 = new byte[cArray.length];
        int n3 = 0;
        while (n3 < cArray.length) {
            byArray2[n3] = (byte)cArray[n3];
            ++n3;
        }
        ((OutputStream)object2).write(byArray2, 0, byArray2.length);
        ((OutputStream)object2).flush();
        ((OutputStream)object2).close();
        InputStream inputStream = this.conn.getInputStream();
        if (inputStream == null) {
            throw new IOException("failed to get HTTP reply");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string2 = this.conn.getContentType();
        if (string2 != null && string2.equals("application/octet-stream")) {
            int n4 = this.conn.getContentLength();
            if (n4 < 0) {
                throw new SocketException("connection was closed before reply");
            }
            object = new byte[n4];
            dataInputStream.readFully((byte[])object, 0, n4);
            dataInputStream.close();
        } else {
            String string3;
            String string4 = "";
            while ((string3 = dataInputStream.readLine()) != null) {
                string4 = String.valueOf(string4) + string3.trim();
            }
            dataInputStream.close();
            if (string4.regionMatches(true, 0, "<html>", 0, 6)) {
                throw new SocketException("got a HTTP error: " + string4);
            }
            object = this.fromBase64(string4);
            string4 = null;
        }
        this.conn = null;
        object2 = this.readingResponse;
        synchronized (object2) {
            this.readingResponse = Boolean.TRUE;
            this.replyBuf = (byte[])object;
            object = null;
            this.readingResponse = Boolean.FALSE;
        }
        if (this.waitingReaderThread != null) {
            object2 = this.waitingReaderThread;
            synchronized (object2) {
                this.waitingReaderThread.notify();
                return;
            }
        }
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 != 0) {
            Object object;
            while (this.replyBuf == null || this.replyCursor > this.replyBuf.length) {
                this.waitingReaderThread = Thread.currentThread();
                object = this.waitingReaderThread;
                synchronized (object) {
                    try {
                        this.waitingReaderThread.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            object = this.readingResponse;
            synchronized (object) {
                try {
                    System.arraycopy(this.replyBuf, this.replyCursor, byArray, n, n2);
                    this.replyCursor += n2;
                    if (this.replyCursor >= this.replyBuf.length) {
                        this.replyBuf = null;
                        this.replyCursor = 0;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.replyBuf = null;
                    this.replyCursor = 0;
                    throw new EOFException("overran end of reply message");
                }
                return;
            }
        }
        if (n == 0) {
            byArray[0] = 0;
        }
    }

    public void testConnection() throws IOException {
        if (this.httpHost == null || this.httpHost.equals("") || this.httpProto == null || this.httpProto.equals("") || this.httpPort == 0) {
            throw new SocketException("HTTP tunneling only enabled for applets");
        }
        try {
            String string = String.valueOf(this.httpProto) + "://" + this.httpHost + ":" + this.httpPort + "/cgi-bin/tunnel?test";
            if (testedHttpServers == null) {
                testedHttpServers = new Vector(3, 5);
            } else if (testedHttpServers.contains(string)) {
                return;
            }
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            if (inputStream != null) {
                String string2;
                String string3 = "";
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                while ((string2 = dataInputStream.readLine()) != null) {
                    string3 = String.valueOf(string3) + string2;
                }
                dataInputStream.close();
            }
            testedHttpServers.addElement(string);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (SocketException socketException) {
            throw socketException;
        }
        catch (Exception exception) {
            throw new SocketException(exception.toString());
        }
    }

    public Object getConnectionObject() {
        return this.conn;
    }

    public String toString() {
        if (this.host != null && this.port > 0) {
            return "[HTTPSocket: host=" + this.host + " port=" + this.port + " connection=" + (this.conn == null ? "closed" : this.conn.toString()) + "]";
        }
        return "[HTTPSocket: closed]";
    }

    private String toBase64(byte[] byArray, int n, int n2) {
        byte by;
        byte by2;
        byte by3;
        this.initBase64Tables();
        int n3 = (int)((double)n2 * 1.33) + 4;
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n4 = n;
        while (n4 < n + n2 - 6) {
            by3 = byArray[n4];
            by2 = byArray[++n4];
            by = byArray[++n4];
            ++n4;
            stringBuffer.append(this.toBase64Table[(by3 & 0xFC) >> 2]);
            stringBuffer.append(this.toBase64Table[(by3 & 3) << 4 | (by2 & 0xF0) >> 4]);
            stringBuffer.append(this.toBase64Table[(by2 & 0xF) << 2 | (by & 0xC0) >> 6]);
            stringBuffer.append(this.toBase64Table[by & 0x3F]);
        }
        while (n4 < n + n2) {
            int n5 = 0;
            by3 = byArray[n4++];
            if (n4 >= n + n2) {
                by2 = 0;
                n5 = 2;
            } else {
                by2 = byArray[n4];
                ++n4;
            }
            if (n4 >= n + n2) {
                by = 0;
                n5 = n5 != 0 ? n5 : 1;
            } else {
                by = byArray[n4];
                ++n4;
            }
            stringBuffer.append(String.valueOf(this.toBase64Table[(by3 & 0xFC) >> 2]) + this.toBase64Table[(by3 & 3) << 4 | (by2 & 0xF0) >> 4]);
            if (n5 == 2) {
                stringBuffer.append("==");
                continue;
            }
            if (n5 == 1) {
                stringBuffer.append(String.valueOf(this.toBase64Table[(by2 & 0xF) << 2 | (by & 0xC0) >> 6]) + "=");
                continue;
            }
            stringBuffer.append(String.valueOf(this.toBase64Table[(by2 & 0xF) << 2 | (by & 0xC0) >> 6]) + this.toBase64Table[by & 0x3F]);
        }
        return stringBuffer.toString();
    }

    private byte[] fromBase64(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length % 4 != 0) {
            return null;
        }
        this.initBase64Tables();
        int n = (int)((double)cArray.length * 0.75);
        if (n % 3 > 1) {
            --n;
        }
        byte[] byArray = new byte[n < 3 ? 3 : n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            int n4;
            int n5;
            int n6;
            byte by;
            if (cArray[n3] == '=') continue;
            try {
                char c;
                while ((c = cArray[n3]) == '=' || c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                    ++n3;
                }
                by = this.fromBase64Table[c];
                ++n3;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            try {
                char c;
                while ((c = cArray[n3]) == '=' || c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                    ++n3;
                }
                n6 = this.fromBase64Table[c];
                ++n3;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n6 = -1;
            }
            try {
                char c;
                while ((c = cArray[n3]) == '=' || c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                    ++n3;
                }
                n5 = this.fromBase64Table[c];
                ++n3;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n5 = -1;
            }
            try {
                char c;
                while ((c = cArray[n3]) == '=' || c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                    ++n3;
                }
                n4 = this.fromBase64Table[c];
                ++n3;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n4 = -1;
            }
            int n7 = 0;
            if (n4 == -1) {
                n4 = 0;
                n7 = 1;
            }
            if (n5 == -1) {
                n5 = 0;
                n7 = 2;
            }
            if (n6 == -1) {
                n6 = 0;
                n7 = 3;
            }
            if ((long)n2 > (long)byArray.length - 3L) {
                byte[] byArray2 = new byte[byArray.length << 1];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            byArray[n2++] = (byte)(this.b640tobyte0Table[by] | this.b641tobyte0Table[n6]);
            if (n7 >= 2) continue;
            byArray[n2++] = (byte)(this.b641tobyte1Table[n6] | this.b642tobyte1Table[n5]);
            if (n7 >= 1) continue;
            byArray[n2++] = (byte)(this.b642tobyte2Table[n5] | n4);
        }
        if (n2 < byArray.length) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, 0, byArray3, 0, n2);
            byArray = byArray3;
        }
        return byArray;
    }

    private void initBase64Tables() {
        if (this.toBase64Table != null) {
            return;
        }
        this.toBase64Table = new String["ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".length()];
        int n = 0;
        while (n < "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".length()) {
            this.toBase64Table[n] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".substring(n, n + 1);
            ++n;
        }
        this.fromBase64Table = new byte[256];
        int n2 = 0;
        while (n2 < 256) {
            this.fromBase64Table[n2] = n2 >= 65 && n2 <= 90 ? (int)(n2 - 65) : (n2 >= 97 && n2 <= 122 ? (int)(26 + (n2 - 97)) : (n2 >= 48 && n2 <= 57 ? (int)(52 + (n2 - 48)) : (n2 == 43 ? 62 : (n2 == 47 ? 63 : 0))));
            ++n2;
        }
        this.b640tobyte0Table = new byte[64];
        this.b641tobyte0Table = new byte[64];
        this.b641tobyte1Table = new byte[64];
        this.b642tobyte1Table = new byte[64];
        this.b642tobyte2Table = new byte[64];
        int n3 = 0;
        while (n3 < 64) {
            this.b640tobyte0Table[n3] = (byte)(n3 << 2);
            this.b641tobyte0Table[n3] = (byte)((n3 & 0x30) >> 4 & 0xFF);
            this.b641tobyte1Table[n3] = (byte)((n3 & 0xF) << 4 & 0xFF);
            this.b642tobyte1Table[n3] = (byte)((n3 & 0x3C) >> 2 & 0xFF);
            this.b642tobyte2Table[n3] = (byte)((n3 & 3) << 6 & 0xFF);
            ++n3;
        }
    }
}

