/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.CORBA;

import IE.Iona.OrbixWeb.CORBA.BOA;
import IE.Iona.OrbixWeb.CORBA.Listener;
import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.CORBA.ServerConnection;
import IE.Iona.OrbixWeb.CORBA.ServerRequest;
import IE.Iona.OrbixWeb.Features.Config;
import IE.Iona.OrbixWeb.Features.JvmSupport;
import IE.Iona.OrbixWeb._CORBA;
import java.util.Vector;

public class EventHandler
implements Runnable {
    private Listener[] _listeners;
    private Thread[] _listenerThreads;
    private int _num_ports;
    private boolean _accept_requests;
    private static Vector srvConns = new Vector();
    public static final int ANY_PORT_PLAIN = -1;
    public static final int ANY_PORT_SSL = -2;

    public EventHandler() {
    }

    public EventHandler(int[] nArray) {
        if (nArray == null || !Config.get_ACCEPT_CONNECTIONS()) {
            return;
        }
        this._num_ports = nArray.length;
        this._listeners = new Listener[this._num_ports];
        this._listenerThreads = new Thread[this._num_ports];
        int n = 0;
        while (n < this._num_ports) {
            boolean bl;
            int n2 = nArray[n];
            boolean bl2 = bl = n2 == Config.get_SSL_IIOP_LISTEN_PORT() || n2 == -2;
            if (n2 == -2 || n2 == -1) {
                n2 = 0;
            }
            this._listeners[n] = bl ? (_CORBA.Orbix.getSecurityPolicy().getCanSecureAccept() ? this.newListener(n2, "IE.Iona.OrbixWeb.SSL.SSLListener") : null) : this.newListener(n2, "IE.Iona.OrbixWeb.CORBA.Listener");
            ++n;
        }
    }

    protected Listener newListener(int n, String string) {
        Listener listener = null;
        try {
            Class<?> clazz = Class.forName(string);
            listener = (Listener)clazz.newInstance();
        }
        catch (Exception exception) {
            if (ORB.diag >= 2) {
                System.out.println("Failed to instantiate listener object: " + exception);
            }
            return null;
        }
        listener.Bind(n);
        return listener;
    }

    public void cleanUp() {
        int n = 0;
        while (n < this._num_ports) {
            if (this._listeners[n] != null) {
                this._listeners[n].close();
            }
            this._listeners[n] = null;
            ++n;
        }
    }

    public synchronized void acceptClients(boolean bl) {
        int n = 0;
        while (n < this._num_ports) {
            block11: {
                try {
                    if (bl) {
                        try {
                            if (this._listenerThreads[n] != null && this._listenerThreads[n].isAlive()) {
                                return;
                            }
                            this._listenerThreads[n] = new Thread(this._listeners[n]);
                            if (!JvmSupport.runningInApplet()) {
                                try {
                                    this._listenerThreads[n].setPriority(Config.get_LISTENER_PRIORITY());
                                    this._listenerThreads[n].setName("OrbixWeb Server Listener thread");
                                }
                                catch (Exception exception) {
                                    System.out.println("[OrbixWeb: to suppress that exception, use the applet ORB.init() method]");
                                }
                            }
                            this._listenerThreads[n].start();
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {}
                        break block11;
                    }
                    if (this._listeners[n] != null && this._listeners[n].isListening()) {
                        this._listeners[n].stopListening();
                    }
                }
                catch (NullPointerException nullPointerException) {}
            }
            ++n;
        }
    }

    public boolean clientsAccepted() {
        if (this._num_ports <= 0) {
            return false;
        }
        if (this._listeners[0] != null) {
            return this._listeners[0].isListening();
        }
        return false;
    }

    public void acceptRequests(boolean bl) {
        this._accept_requests = bl;
        if (!bl) {
            Thread thread = _CORBA.Orbix.mainServerThread();
            synchronized (thread) {
                _CORBA.Orbix.mainServerThread().notifyAll();
                return;
            }
        }
    }

    public boolean requestsAccepted() {
        return this._accept_requests;
    }

    public int port(int n) {
        if (this._listeners == null || this._listeners.length <= n || this._listeners[n] == null) {
            return -1;
        }
        return this._listeners[n].port();
    }

    public void run() {
        _CORBA.Orbix.processEvents(Config.get_OBJECT_CONNECT_TIMEOUT());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServerRequest nextRequest(int n) {
        boolean bl;
        boolean bl2 = bl = n == -1;
        while (this._accept_requests) {
            ServerRequest serverRequest = _CORBA.Orbix.globRequestCache().get_next_request();
            if (serverRequest != null) {
                return serverRequest;
            }
            if (n == 0) {
                return null;
            }
            try {
                Thread thread = _CORBA.Orbix.mainServerThread();
                synchronized (thread) {
                    long l = System.currentTimeMillis();
                    if (bl) {
                        _CORBA.Orbix.mainServerThread().wait();
                    } else {
                        _CORBA.Orbix.mainServerThread().wait(n);
                    }
                    if (!bl && System.currentTimeMillis() > l + (long)n) {
                        if (!BOA.noHangup) return null;
                        if (!_CORBA.Orbix.anyClientsConnected()) return null;
                        return null;
                    }
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return null;
    }

    public void finalize() {
        this.cleanUp();
        EventHandler.killServerConnections();
    }

    public static void killServerConnections() {
        if (srvConns != null) {
            Vector vector = srvConns;
            synchronized (vector) {
                int n = 0;
                while (n < srvConns.size()) {
                    ServerConnection serverConnection = (ServerConnection)srvConns.elementAt(n);
                    try {
                        if (serverConnection != null) {
                            serverConnection.close();
                        }
                    }
                    catch (Exception exception) {}
                    ++n;
                }
                srvConns.removeAllElements();
                srvConns = null;
                return;
            }
        }
    }

    public static void trackServerConnection(ServerConnection serverConnection) {
        if (srvConns != null) {
            Vector vector = srvConns;
            synchronized (vector) {
                srvConns.addElement(serverConnection);
                return;
            }
        }
    }

    public static void unTrackServerConnection(ServerConnection serverConnection) {
        if (srvConns != null) {
            Vector vector = srvConns;
            synchronized (vector) {
                srvConns.removeElement(serverConnection);
                return;
            }
        }
    }
}

