/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.CORBA;

import IE.Iona.OrbixWeb.CORBA.BaseObject;
import IE.Iona.OrbixWeb.CORBA.ClientConnection;
import IE.Iona.OrbixWeb.CORBA.DaemonMgr;
import IE.Iona.OrbixWeb.CORBA.ErrorMsgs;
import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.Features.Config;
import IE.Iona.OrbixWeb.Features.JvmSupport;
import IE.Iona.OrbixWeb._CORBA;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class ConnectTable
implements Runnable {
    private static final String LOCALHOST = "localhost";
    private Thread cleanupThread;
    private int maxsize = Config.get_CONNECT_TABLE_SIZE_DEFAULT();
    private long cleanupTime;
    protected Hashtable table;
    private ClientConnection mostrecent;
    private ClientConnection leastrecent;
    private Hashtable hostnameCache;
    private Hashtable hostPortList;
    private int num_daemons;
    private DaemonMgr[] daemons;

    public ConnectTable(int n) {
        if (n < 1) {
            n = 1;
        }
        this.maxsize = n;
        this.table = new Hashtable();
        this.cleanupThread = null;
        this.cleanupTime = System.currentTimeMillis();
        this.hostnameCache = new Hashtable(Config.get_OBJECT_TABLE_SIZE());
        this.hostPortList = new Hashtable(Config.get_OBJECT_TABLE_SIZE());
        this.num_daemons = 0;
        this.daemons = new DaemonMgr[3];
    }

    public synchronized void run() {
        do {
            long l = System.currentTimeMillis() - this.cleanupTime;
            while (l < (long)Config.get_CONNECTION_TIMEOUT()) {
                try {
                    this.wait((long)Config.get_CONNECTION_TIMEOUT() - l);
                }
                catch (InterruptedException interruptedException) {}
                l = System.currentTimeMillis() - this.cleanupTime;
            }
            this.cleanup();
        } while (this.table.size() != 0);
        if (ORB.diag >= 2) {
            System.out.println("-- Connection cleanup thread stopping");
        }
    }

    public synchronized void setMaxSize(int n) {
        if (n < 1) {
            n = 1;
        }
        this.maxsize = n;
        if (this.table.size() > this.maxsize) {
            this.cleanup();
        }
    }

    public synchronized Enumeration elements() {
        return this.table.elements();
    }

    public synchronized void enterConnection(ClientConnection clientConnection) {
        ClientConnection clientConnection2 = (ClientConnection)this.table.get(clientConnection.key);
        if (clientConnection2 == null) {
            this.table.put(clientConnection.key, clientConnection);
        }
    }

    public synchronized ClientConnection holdConnection(BaseObject baseObject, int n) {
        ClientConnection clientConnection = null;
        String string = baseObject._get_key();
        String string2 = baseObject._host();
        if (string != null) {
            clientConnection = (ClientConnection)this.table.get(string);
        }
        if (clientConnection == null) {
            if (baseObject._kind == 1) {
                string = String.valueOf(baseObject._serverKey(n)) + "@" + string2 + ":" + ":_iiop_:";
                clientConnection = this._getConnection(string, baseObject);
                if (clientConnection == null) {
                    Enumeration enumeration = this.hostnameCache.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        if (!ConnectTable.HostCompare(string3, string2) || (clientConnection = this._getConnection(string = String.valueOf(baseObject._serverKey(n)) + "@" + string3 + ":" + ":_iiop_:", baseObject)) == null) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                string = String.valueOf(baseObject._implementation()) + "@" + baseObject._host() + ":" + baseObject._marker();
                clientConnection = this._getConnection(string, baseObject);
                if (clientConnection == null && (clientConnection = this._getConnection(string = String.valueOf(baseObject._implementation()) + "@" + string2 + ":*", baseObject)) == null) {
                    Enumeration enumeration = this.hostnameCache.keys();
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        if (!ConnectTable.HostCompare(string4, string2) || (clientConnection = this._getConnection(String.valueOf(baseObject._implementation()) + "@" + string4 + ":" + baseObject._marker(), baseObject)) == null && (clientConnection = this._getConnection(String.valueOf(baseObject._implementation()) + "@" + string4 + ":*", baseObject)) == null) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        if (clientConnection == null) {
            if (ORB.diag >= 2) {
                System.out.println("-- No matching connection for key " + string);
            }
            this.map_host(string2);
            clientConnection = new ClientConnection(baseObject, n);
            baseObject._getProt().openConnection(clientConnection, baseObject);
            if (!(clientConnection.policy.equals("per_method") || clientConnection.server.equals("IT_daemon") && baseObject._kind != 1)) {
                this.table.put(clientConnection.key, clientConnection);
                if (this.cleanupThread == null || !this.cleanupThread.isAlive()) {
                    if (ORB.diag >= 2) {
                        System.out.println("-- Connection cleanup thread starting");
                    }
                    if (Config.get_CONNECTION_TIMEOUT() > 0) {
                        this.cleanupThread = new Thread(this);
                        if (!JvmSupport.runningInApplet()) {
                            try {
                                this.cleanupThread.setDaemon(true);
                                this.cleanupThread.setName("OrbixWeb Connection Monitor thread");
                            }
                            catch (Exception exception) {
                                System.out.println("-- Ignore previous exception.");
                            }
                        }
                        this.cleanupThread.start();
                    }
                }
            } else if (ORB.diag >= 2) {
                System.out.println("-- New connection is per-method, so not put in table");
            }
            baseObject._set_key(clientConnection.key);
        }
        ++clientConnection.refcount;
        this.access(clientConnection);
        if (this.table.size() > this.maxsize) {
            this.cleanup();
        }
        return clientConnection;
    }

    public synchronized void releaseConnection(ClientConnection clientConnection) {
        --clientConnection.refcount;
        if (clientConnection.refcount < 0) {
            String string = ErrorMsgs.getMessage(10144, null);
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new INTERNAL(string, 10144, completionStatus);
        }
    }

    public synchronized void cleanup() {
        ClientConnection clientConnection;
        this.cleanupTime = System.currentTimeMillis();
        ClientConnection clientConnection2 = this.leastrecent;
        while (clientConnection2 != null && !clientConnection2.server.equals("IT_daemon") && this.cleanupTime - clientConnection2.accesstime > (long)Config.get_CONNECTION_TIMEOUT()) {
            clientConnection = clientConnection2.prev;
            this.closeConnection(clientConnection2.key);
            clientConnection2 = clientConnection;
        }
        if (this.table.size() > this.maxsize) {
            int n = this.table.size() - this.maxsize + this.maxsize * 20 / 100;
            clientConnection2 = this.leastrecent;
            while (clientConnection2 != null && n > 0) {
                clientConnection = clientConnection2.prev;
                if (this.destroyConnection(clientConnection2.key)) {
                    --n;
                }
                clientConnection2 = clientConnection;
            }
        }
    }

    public synchronized boolean closeConnection(String string) {
        if (string == null) {
            return false;
        }
        ClientConnection clientConnection = (ClientConnection)this.table.get(string);
        if (clientConnection == null) {
            return true;
        }
        if (clientConnection.refcount > 0) {
            return false;
        }
        return this.destroyConnection(clientConnection.key);
    }

    public boolean is_open(String string) {
        ClientConnection clientConnection = (ClientConnection)this.table.get(string);
        if (clientConnection == null) {
            return false;
        }
        return clientConnection.is_open;
    }

    public synchronized void destroyAllConnections() {
        try {
            Enumeration enumeration = this.elements();
            while (true) {
                ClientConnection clientConnection = (ClientConnection)enumeration.nextElement();
                this.table.remove(clientConnection.key);
                clientConnection.finalize();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.table.clear();
            System.gc();
            return;
        }
    }

    public synchronized boolean destroyConnection(String string) {
        ClientConnection clientConnection = (ClientConnection)this.table.get(string);
        if (clientConnection == null) {
            return true;
        }
        if (clientConnection.refcount > 0) {
            return false;
        }
        clientConnection.close();
        this.destroy(clientConnection);
        clientConnection = null;
        return true;
    }

    public void destroy(ClientConnection clientConnection) {
        if (clientConnection.prev != null) {
            clientConnection.prev.next = clientConnection.next;
        }
        if (clientConnection.next != null) {
            clientConnection.next.prev = clientConnection.prev;
        }
        if (this.mostrecent == clientConnection) {
            this.mostrecent = clientConnection.next;
        }
        if (this.leastrecent == clientConnection) {
            this.leastrecent = clientConnection.prev;
        }
        clientConnection.prev = null;
        clientConnection.next = null;
        this.table.remove(clientConnection.key);
        if (clientConnection.server.equals("IT_daemon")) {
            this.remove_daemon(clientConnection.host);
        }
    }

    protected void access(ClientConnection clientConnection) {
        if (!clientConnection.server.equals("IT_daemon")) {
            clientConnection.accesstime = System.currentTimeMillis();
            if (clientConnection == this.mostrecent) {
                return;
            }
            if (clientConnection.prev != null) {
                clientConnection.prev.next = clientConnection.next;
            }
            if (clientConnection.next != null) {
                clientConnection.next.prev = clientConnection.prev;
            }
            if (clientConnection == this.leastrecent) {
                this.leastrecent = clientConnection.prev;
            }
            if (this.leastrecent == null) {
                this.leastrecent = clientConnection;
            }
            clientConnection.prev = null;
            clientConnection.next = this.mostrecent;
            if (this.mostrecent != null) {
                this.mostrecent.prev = clientConnection;
            }
            this.mostrecent = clientConnection;
        }
    }

    public synchronized DaemonMgr get_daemon(String string) {
        return this.get_daemon(string, false);
    }

    public synchronized DaemonMgr get_daemon(String string, boolean bl) {
        int n = 0;
        while (n < this.num_daemons) {
            if (ConnectTable.HostCompare(this.daemons[n]._host(), string) && (!bl || this.daemons[n]._protocolKind() != 1)) {
                return this.daemons[n];
            }
            ++n;
        }
        DaemonMgr daemonMgr = DaemonMgr._bind("", string, bl);
        this.add_daemon(daemonMgr);
        return daemonMgr;
    }

    public synchronized void add_daemon(DaemonMgr daemonMgr) {
        if (this.num_daemons >= this.daemons.length) {
            DaemonMgr[] daemonMgrArray = new DaemonMgr[this.num_daemons + 3];
            System.arraycopy(this.daemons, 0, daemonMgrArray, 0, this.num_daemons);
            this.daemons = daemonMgrArray;
        }
        this.daemons[this.num_daemons] = daemonMgr;
        ++this.num_daemons;
    }

    public synchronized void remove_daemon(String string) {
        int n = 0;
        while (n < this.num_daemons) {
            if (ConnectTable.HostCompare(this.daemons[n]._host(), string)) {
                while (n < this.num_daemons - 1) {
                    this.daemons[n] = this.daemons[n + 1];
                    ++n;
                }
                --this.num_daemons;
                return;
            }
            ++n;
        }
    }

    public synchronized void map_host(String string) {
        if (this.hostnameCache.get(string) != null) {
            return;
        }
        this.hostnameCache.put(string, Boolean.TRUE);
    }

    public void setHostPort(String string, int n) {
        if (string == null) {
            return;
        }
        Enumeration enumeration = this.hostPortList.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!ConnectTable.HostCompare(string, string2)) continue;
            this.hostPortList.put(string2, new Integer(n));
            return;
        }
        this.hostPortList.put(string, new Integer(n));
    }

    public int getHostPort(String string) {
        if (string != null) {
            Enumeration enumeration = this.hostPortList.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!ConnectTable.HostCompare(string, string2)) continue;
                return (Integer)this.hostPortList.get(string2);
            }
        }
        return Config.get_ORBIXD_PORT();
    }

    public static boolean HostCompare(String string, String string2) {
        InetAddress[] inetAddressArray;
        InetAddress[] inetAddressArray2;
        if (string.equals(LOCALHOST)) {
            string = ConnectTable.getLocalhostNetworkName();
        }
        if (string2.equals(LOCALHOST)) {
            string2 = ConnectTable.getLocalhostNetworkName();
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        String string3 = string;
        String string4 = string2;
        if (string.indexOf(".") <= 0 && !(inetAddressArray2 = Config.get_LOCAL_DOMAIN()).equals("")) {
            string3 = String.valueOf(string3) + "." + (String)inetAddressArray2;
        }
        if (string2.indexOf(".") <= 0 && !(inetAddressArray2 = Config.get_LOCAL_DOMAIN()).equals("")) {
            string4 = String.valueOf(string4) + "." + (String)inetAddressArray2;
        }
        if (string3.equalsIgnoreCase(string4)) {
            return true;
        }
        try {
            inetAddressArray2 = InetAddress.getAllByName(string);
            inetAddressArray = InetAddress.getAllByName(string2);
        }
        catch (Exception exception) {
            return false;
        }
        int n = 0;
        while (n < inetAddressArray2.length) {
            int n2 = 0;
            while (n2 < inetAddressArray.length) {
                if (inetAddressArray2[n].equals(inetAddressArray[n2])) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    private static String getLocalhostNetworkName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return LOCALHOST;
        }
    }

    private ClientConnection _getConnection(String string, BaseObject baseObject) {
        ClientConnection clientConnection = (ClientConnection)this.table.get(string);
        if (clientConnection != null) {
            if (clientConnection.getConnectionType() == 1 && !_CORBA.Orbix.getSecurityPolicy().getCanSecureConnect()) {
                return null;
            }
            if (clientConnection.getConnectionType() == 0 && !_CORBA.Orbix.getSecurityPolicy().isAllowedInsecureInterface(baseObject._interfaceMarker())) {
                return null;
            }
            if (ORB.diag >= 2) {
                System.out.println("-- Found matching connection for key " + string);
                if (!clientConnection.is_open && ORB.diag >= 2) {
                    System.out.println("-- Connection is not open");
                }
            }
            if (!clientConnection.policy.equals("per_method")) {
                baseObject._set_key(clientConnection.key);
            }
        }
        return clientConnection;
    }

    protected void finalize() {
        this.destroyAllConnections();
        try {
            if (this.cleanupThread != null) {
                this.cleanupThread.stop();
            }
            this.cleanupThread = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void clear() {
        this.table.clear();
    }

    protected DaemonMgr[] getDaemonConnections() {
        return this.daemons;
    }
}

