/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.CORBA;

import IE.Iona.OrbixWeb.CORBA.BaseObject;
import IE.Iona.OrbixWeb.CORBA.ConnectTable;
import IE.Iona.OrbixWeb.CORBA.ErrorMsgs;
import IE.Iona.OrbixWeb.CORBA.ExceptionHelper;
import IE.Iona.OrbixWeb.CORBA.HttpSocketConnection;
import IE.Iona.OrbixWeb.CORBA.InitService;
import IE.Iona.OrbixWeb.CORBA.MarshalBuffer;
import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.CORBA.ObjectRef;
import IE.Iona.OrbixWeb.CORBA.Request;
import IE.Iona.OrbixWeb.CORBA.ServerConnection;
import IE.Iona.OrbixWeb.CORBA.SocketConnection;
import IE.Iona.OrbixWeb.CORBA.octetSeqHolder;
import IE.Iona.OrbixWeb.Features.Config;
import IE.Iona.OrbixWeb.Features.IT_reqTransformer;
import IE.Iona.OrbixWeb.Features.JvmSupport;
import IE.Iona.OrbixWeb.IIOP.FirewallProfile;
import IE.Iona.OrbixWeb.IIOP.IIOP;
import IE.Iona.OrbixWeb.IIOP.IIOPProt;
import IE.Iona.OrbixWeb.IIOP.IOR;
import IE.Iona.OrbixWeb.IIOP.iiopBody;
import IE.Iona.OrbixWeb.OrbixProt.OrbixProt;
import IE.Iona.OrbixWeb.SSL.SSLSocketConnection;
import IE.Iona.OrbixWeb._CORBA;
import IE.Iona.OrbixWeb._OrbixWeb;
import java.io.IOException;
import java.net.UnknownHostException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

public class ClientConnection
implements Runnable {
    public int refcount;
    public String key;
    public ClientConnection next;
    public ClientConnection prev;
    public long accesstime;
    public String policy;
    public boolean is_open;
    protected boolean connection_failed;
    public ClientConnection daemon_conn;
    private int num_requests;
    private int max_requests;
    private int[] req_seqn;
    private Request[] reqs;
    private int[] resp_type;
    private int[] resp_offset;
    private byte[][] resp_data;
    private byte[] resp_sex;
    protected int seqn = 1;
    protected SocketConnection socket;
    public String user_name;
    public int port;
    public BaseObject target_object;
    public String host;
    public String server;
    public String marker;
    public String remote_marker;
    public String remote_user;
    public int remote_pid;
    protected Thread recv_thread;
    public static final int IT_MSG_REQ = 0;
    public static final int IT_MSG_REPLY = 1;
    public static final int IT_MSG_SYS_EXCEPTION = 2;
    public static final int IT_MSG_PROTOCOL = 3;
    public static final int IT_MSG_USER_EXCEPTION = 4;
    public static final int USE_DIRECT_CONN = 0;
    public static final int USE_DIRECT_SSL = 1;
    public static final int USE_HTTP_TUNNELLING = 2;
    public static final int USE_IIOP_PROXY = 3;
    public boolean _fromClient = false;
    private boolean _isIIOPConnection = true;
    private int connection_type;
    private boolean _isBiDir = false;
    private static int _biDirKey;
    protected static BaseObject iiopProxyRef;
    protected static String iiopProxyKey;
    private static Exception lastConnectFailure;
    private byte[] fixed_marshal_buffer;
    private byte[] fixed_timeout_buffer;
    private byte[] fixed_failure_buffer;

    public ClientConnection() {
        this.host = "";
        this.server = "";
        this.marker = "*";
        this.key = String.valueOf(this.server) + "@" + this.host + ":" + this.marker;
        this.policy = "shared";
        this.connection_type = 0;
        this.user_name = _CORBA.Orbix.get_principal_string();
    }

    public ClientConnection(BaseObject baseObject, int n) {
        this.target_object = baseObject;
        this.host = baseObject._host();
        this.server = baseObject._implementation();
        this.marker = baseObject._marker();
        if (this.server == null) {
            this.server = String.valueOf(baseObject._port());
        }
        if (this.marker == null) {
            this.marker = "";
        }
        this.key = String.valueOf(baseObject._serverKey(n)) + "@" + this.host + ":" + baseObject._markerKey();
        this.policy = "shared";
        this.connection_type = n;
        this._initRequestCache();
        this.user_name = _CORBA.Orbix.get_principal_string();
    }

    private void _initRequestCache() {
        this.max_requests = Config.get_REQ_CACHE_SIZE();
        this.req_seqn = new int[this.max_requests];
        this.reqs = new Request[this.max_requests];
        this.resp_type = new int[this.max_requests];
        this.resp_offset = new int[this.max_requests];
        this.resp_data = new byte[this.max_requests][];
        this.resp_sex = new byte[this.max_requests];
    }

    private SocketConnection FirewallConnect() throws Exception {
        Object object;
        Object object2;
        IOR iOR = FirewallProfile.outboundProxy();
        IOR iOR2 = this.target_object._getIOR();
        if (iOR2 == null) {
            throw new Error("got non-IIOP objref in FirewallConnect");
        }
        iiopBody iiopBody2 = null;
        iiopBody iiopBody3 = iOR2.iterateIopProfiles();
        while (iiopBody3 != null) {
            if (iiopBody3.isFirewallProfile()) {
                iiopBody2 = iiopBody3;
            }
            if (iOR != null) {
                object2 = iOR.iterateIopProfiles();
                while (object2 != null) {
                    if (((iiopBody)object2).port == iiopBody3.port && ConnectTable.HostCompare(((iiopBody)object2).host, iiopBody3.host)) {
                        SocketConnection socketConnection = this.connectWithIopProfile(iiopBody3);
                        if (socketConnection != null) {
                            return socketConnection;
                        }
                        throw lastConnectFailure;
                    }
                    object2 = iOR.iterateIopProfiles((iiopBody)object2);
                }
            }
            iiopBody3 = iOR2.iterateIopProfiles(iiopBody3);
        }
        if (iOR != null) {
            object2 = iOR.iterateIopProfiles();
            while (object2 != null) {
                object = FirewallProfile.connectViaProxy(iOR2, (iiopBody)object2, iOR);
                if (object != null) {
                    this.target_object._setIOR(((FirewallProfile)object).objViaProxy._getIOR());
                    this.target_object._set_key(((FirewallProfile)object).keyViaProxy);
                    throw new IIOP("reroute connection via proxy (handled internally)", 10699, CompletionStatus.COMPLETED_NO);
                }
                object2 = iOR.iterateIopProfiles((iiopBody)object2);
            }
        } else if (iiopBody2 != null) {
            object2 = iiopBody2.iterateInboundProxies();
            while (object2 != null) {
                object = ((IOR)object2).iterateIopProfiles();
                while (object != null) {
                    FirewallProfile firewallProfile;
                    if (FirewallProfile.isIntranetHost(((iiopBody)object).host) && (firewallProfile = FirewallProfile.connectViaProxy(iOR2, (iiopBody)object, (IOR)object2)) != null) {
                        this.target_object._setIOR(firewallProfile.objViaProxy._getIOR());
                        this.target_object._set_key(firewallProfile.keyViaProxy);
                        throw new IIOP("reroute connection via proxy (handled internally)", 10699, CompletionStatus.COMPLETED_NO);
                    }
                    object = ((IOR)object2).iterateIopProfiles((iiopBody)object);
                }
                object2 = iiopBody2.iterateInboundProxies((IOR)object2);
            }
        }
        object2 = iOR2.iterateIopProfiles();
        while (object2 != null) {
            if (FirewallProfile.isIntranetHost(((iiopBody)object2).host)) {
                object = this.connectWithIopProfile((iiopBody)object2);
                if (object != null) {
                    return object;
                }
                throw lastConnectFailure;
            }
            object2 = iOR2.iterateIopProfiles((iiopBody)object2);
        }
        throw new COMM_FAILURE(ErrorMsgs.getMessage(12084, null), 12084, CompletionStatus.COMPLETED_NO);
    }

    private SocketConnection connectWithIopProfile(iiopBody iiopBody2) {
        int n = iiopBody2.port == Config.get_ORBIXD_IIOP_PORT() || this.server.equals("IT_daemon") ? 1 : ORB.max_connect_retries + 1;
        int n2 = 1;
        while (n2 <= n) {
            try {
                if (this.connection_type == 1) {
                    return new SSLSocketConnection(iiopBody2.host, iiopBody2.getSSLPort(), this.target_object._getIOR());
                }
                return new SocketConnection(iiopBody2.host, iiopBody2.port, this.target_object._getIOR());
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {}
                if (n2 == n) {
                    lastConnectFailure = iOException;
                    return null;
                }
            }
            catch (Exception exception) {
                lastConnectFailure = exception;
                return null;
            }
            ++n2;
        }
        return null;
    }

    private SocketConnection IIOPConnect(String string, int n) throws Exception {
        if (string == null || string.equals("") || n == 0) {
            throw new IOException("host or port are invalid: forbidden by security policy?");
        }
        if (this.connection_type == 1) {
            if (!_CORBA.Orbix.getSecurityPolicy().getCanSecureConnect()) {
                throw new IOException("security policy does not allow secure connections");
            }
        } else if (!_CORBA.Orbix.getSecurityPolicy().isAllowedInsecureInterface(this.target_object._interfaceMarker())) {
            throw new IOException("security policy does not allow insecure connections");
        }
        switch (this.connection_type) {
            case 2: {
                HttpSocketConnection httpSocketConnection = new HttpSocketConnection(string, n, this.target_object._getIOR());
                ((SocketConnection)httpSocketConnection).testConnection();
                return httpSocketConnection;
            }
            case 0: 
            case 1: 
            case 3: {
                return this.FirewallConnect();
            }
        }
        if (ORB.diag > 2) {
            System.err.println("-- assert: unknown conn type " + this.connection_type);
        }
        Exception exception = new Exception();
        exception.printStackTrace();
        return null;
    }

    private SocketConnection OrbixProtConnect(String string, int n) throws Exception {
        int n2 = n == Config.get_ORBIXD_PORT() || this.server.equals("IT_daemon") ? 1 : ORB.max_connect_retries + 1;
        IOException iOException = null;
        int n3 = 1;
        while (n3 <= n2) {
            try {
                return new SocketConnection(string, n, null);
            }
            catch (IOException iOException2) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {}
                iOException = iOException2;
                ++n3;
            }
        }
        throw iOException;
    }

    public synchronized void openConnection(boolean bl) {
        this._isIIOPConnection = bl;
        try {
            if (!this._isIIOPConnection) {
                this.fixed_marshal_buffer = OrbixProt.fixed_marshal_buffer;
                this.fixed_timeout_buffer = OrbixProt.fixed_timeout_buffer;
                this.fixed_failure_buffer = OrbixProt.fixed_failure_buffer;
                this.socket = this.OrbixProtConnect(this.host, this.port);
            } else {
                this.fixed_marshal_buffer = IIOPProt.fixed_marshal_buffer;
                this.fixed_timeout_buffer = IIOPProt.fixed_timeout_buffer;
                this.fixed_failure_buffer = IIOPProt.fixed_failure_buffer;
                this.socket = this.IIOPConnect(this.host, this.port);
            }
            if (_CORBA.connection_callback != null) {
                _CORBA.connection_callback.OpenCallBack(this.server, this.getConnectionObject());
                return;
            }
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (UnknownHostException unknownHostException) {
            if (this.daemon_conn != null) {
                _CORBA.Orbix.connect_table.releaseConnection(this.daemon_conn);
                this.daemon_conn = null;
            }
            String string = this.host;
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new COMM_FAILURE(string, 10086, completionStatus);
        }
        catch (IOException iOException) {
            if (this.daemon_conn != null) {
                _CORBA.Orbix.connect_table.releaseConnection(this.daemon_conn);
                this.daemon_conn = null;
            }
            if (this.server.equals("IT_daemon")) {
                String string = String.valueOf(this.host) + "/" + this.port;
                CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
                throw new COMM_FAILURE(string, 12082, completionStatus);
            }
            String string = String.valueOf(this.host) + "/" + this.port;
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new COMM_FAILURE(string, 10091, completionStatus);
        }
        catch (Exception exception) {
            if (this.daemon_conn != null) {
                _CORBA.Orbix.connect_table.releaseConnection(this.daemon_conn);
                this.daemon_conn = null;
            }
            String string = this.host;
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new NO_PERMISSION(string, 12121, completionStatus);
        }
    }

    public synchronized void completeConnect() {
        this.is_open = true;
        this.recv_thread = new Thread((Runnable)this, this.toString());
        if (!JvmSupport.runningInApplet()) {
            try {
                this.recv_thread.setDaemon(true);
            }
            catch (Exception exception) {
                System.out.println("[OrbixWeb: to suppress that exception, use the applet ORB.init() method]");
            }
        }
        this.recv_thread.start();
        if (ORB.diag >= 1) {
            if (this._isIIOPConnection) {
                System.out.print("[New IIOP Connection (");
            } else {
                System.out.print("[New Connection (");
            }
            System.out.println(String.valueOf(this.host) + "," + this.server + ", " + this.remote_marker + "," + this.remote_user + ",pid=" + this.remote_pid + ") ]");
        }
    }

    public String toString() {
        return "OrbixWeb Client Reader thread connected to : " + (this.socket != null ? this.socket.toString() : "[closed socket]");
    }

    public synchronized boolean close() {
        if (!this.is_open) {
            return this.num_requests <= 0;
        }
        if (ORB.diag >= 1) {
            if (this._fromClient) {
                System.out.print("[ " + _CORBA.Orbix.myServer() + ": ");
            } else {
                System.out.print("[ ");
            }
            if (!this._isIIOPConnection) {
                System.out.println("End of Connection (" + this.host + "," + this.server + "," + this.remote_user + ",pid=" + this.remote_pid + ") ]");
            } else {
                System.out.println("End of IIOP connection (" + this.host + ":" + this.port + ") ]");
            }
        }
        if (_CORBA.connection_callback != null) {
            _CORBA.connection_callback.CloseCallBack(this.server, this.getConnectionObject());
        }
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception exception) {}
        this.is_open = false;
        if (this.recv_thread != Thread.currentThread() && this.recv_thread != null) {
            this.recv_thread.stop();
        }
        this.recv_thread = null;
        if (this.daemon_conn != null) {
            try {
                _CORBA.Orbix.connect_table.releaseConnection(this.daemon_conn);
            }
            catch (SystemException systemException) {}
            this.daemon_conn = null;
        }
        if (this._fromClient) {
            ServerConnection.removeClient();
        }
        this.notifyAll();
        return false;
    }

    public synchronized void sendBuffer(byte[] byArray, int n, int n2) {
        if (this.socket == null) {
            String string = ErrorMsgs.getMessage(10083, null);
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new COMM_FAILURE(string, 10083, completionStatus);
        }
        try {
            this.socket.write(byArray, n, n2);
            return;
        }
        catch (IOException iOException) {
            String string = ErrorMsgs.getMessage(10083, null);
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new COMM_FAILURE(string, 10083, completionStatus);
        }
    }

    public synchronized void send_request(Request request, boolean bl) {
        if (!this.is_open) {
            String string = ErrorMsgs.getMessage(12081, null);
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new COMM_FAILURE(string, 12081, completionStatus);
        }
        request.getProt().updateMsg(request);
        Object object = request.coder;
        object = new IntHolder(((MarshalBuffer)object)._length);
        this.target_object = (BaseObject)request._target;
        this.host = this.target_object._host();
        this.server = this.target_object._implementation();
        this.marker = this.target_object._marker();
        Object object2 = request.coder;
        object2 = this.doOutgoingTransformer(((MarshalBuffer)object2)._buffer, (IntHolder)object, request);
        this.sendBuffer((byte[])object2, 0, ((IntHolder)object).value);
        if (!bl) {
            if (this.reqs == null) {
                this._initRequestCache();
            }
            if (this.num_requests >= this.max_requests) {
                short s = Config.get_REQ_CACHE_SIZE();
                int[] nArray = new int[this.num_requests + s];
                Request[] requestArray = new Request[this.num_requests + s];
                int[] nArray2 = new int[this.num_requests + s];
                byte[][] byArray = new byte[this.num_requests + s][];
                int[] nArray3 = new int[this.num_requests + s];
                byte[] byArray2 = new byte[this.num_requests + s];
                System.arraycopy(this.reqs, 0, requestArray, 0, this.num_requests);
                System.arraycopy(this.req_seqn, 0, nArray, 0, this.num_requests);
                System.arraycopy(this.resp_type, 0, nArray2, 0, this.num_requests);
                System.arraycopy(this.resp_offset, 0, nArray3, 0, this.num_requests);
                System.arraycopy(this.resp_data, 0, byArray, 0, this.num_requests);
                System.arraycopy(this.resp_sex, 0, byArray2, 0, this.num_requests);
                this.reqs = requestArray;
                this.req_seqn = nArray;
                this.resp_type = nArray2;
                this.resp_offset = nArray3;
                this.resp_data = byArray;
                this.max_requests = this.num_requests + s;
                this.resp_sex = byArray2;
            }
            this.reqs[this.num_requests] = request;
            this.req_seqn[this.num_requests] = request._get_seqn();
            this.resp_type[this.num_requests] = 0;
            this.resp_offset[this.num_requests] = 0;
            this.resp_data[this.num_requests] = null;
            this.resp_sex[this.num_requests] = 0;
            ++this.num_requests;
        }
    }

    public synchronized int get_response(Request request) {
        if (ORB.diag >= 2) {
            System.out.println("-- Getting response from '" + this.key + "'");
        }
        boolean bl = false;
        int n = -1;
        long l = System.currentTimeMillis();
        while (!bl) {
            n = 0;
            while (n < this.num_requests) {
                if (this.reqs[n] == request) break;
                ++n;
            }
            if (n >= this.num_requests) {
                String string = ErrorMsgs.getMessage(10280, null);
                CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
                throw new NO_RESPONSE(string, 10280, completionStatus);
            }
            if (this.resp_type[n] != 0) {
                bl = true;
                break;
            }
            if (ORB.tx_timeout != 0 && l + (long)ORB.tx_timeout < System.currentTimeMillis()) {
                this.resp_type[n] = 2;
                this.resp_data[n] = this.fixed_timeout_buffer;
                break;
            }
            if (bl) continue;
            if (ORB.diag >= 2) {
                System.out.println("-- Waiting for response on " + this.key);
            }
            try {
                if (ORB.tx_timeout == 0) {
                    this.wait();
                    continue;
                }
                this.wait(ORB.tx_timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
        ObjectRef objectRef = _OrbixWeb.Object(request.target());
        if (ORB.diag >= 2) {
            System.out.println("[Incoming reply to " + request.operation() + " from " + objectRef._implementation() + "@" + objectRef._host() + "]");
        }
        int n2 = this.resp_type[n];
        int n3 = this.resp_offset[n];
        byte[] byArray = this.resp_data[n];
        byte by = this.resp_sex[n];
        if (this._isIIOPConnection || n2 != 1) {
            request._set_response(byArray, byArray.length, n3, false, by);
        } else {
            request._set_response(byArray, byArray.length, n3, true, by);
        }
        --this.num_requests;
        while (n < this.num_requests) {
            this.reqs[n] = this.reqs[n + 1];
            this.req_seqn[n] = this.req_seqn[n + 1];
            this.resp_type[n] = this.resp_type[n + 1];
            this.resp_offset[n] = this.resp_offset[n + 1];
            this.resp_data[n] = this.resp_data[n + 1];
            ++n;
        }
        this.reqs[n] = null;
        this.resp_type[n] = 0;
        this.resp_offset[n] = 0;
        this.resp_data[n] = null;
        switch (n2) {
            case 2: 
            case 4: {
                ExceptionHelper.extract(request, n2);
                break;
            }
            case 3: {
                ((BaseObject)request.getObj())._getProt().handleSpecialMsg(request);
                break;
            }
            default: {
                String string = ErrorMsgs.getMessage(10000, null);
                CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
                throw new UNKNOWN(string, 10000, completionStatus);
            }
            case 1: 
        }
        return 1;
    }

    public synchronized Request get_any_response() {
        int n = 0;
        while (n < this.num_requests) {
            if (this.resp_type[n] != 0) {
                Request request = this.reqs[n];
                request.get_response();
                return request;
            }
            ++n;
        }
        return null;
    }

    public synchronized boolean poll_response(Request request) {
        int n = 0;
        while (n < this.num_requests) {
            if (this.reqs[n] == request) break;
            ++n;
        }
        if (n >= this.num_requests) {
            String string = ErrorMsgs.getMessage(10280, null);
            CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
            throw new NO_RESPONSE(string, 10280, completionStatus);
        }
        return this.resp_type[n] != 0;
    }

    public synchronized boolean poll_any_response() {
        int n = 0;
        while (n < this.num_requests) {
            if (this.resp_type[n] != 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void ignore_response(Request request) {
        int n = 0;
        while (n < this.num_requests) {
            if (this.reqs[n] == request) {
                --this.num_requests;
                while (n < this.num_requests) {
                    this.reqs[n] = this.reqs[n + 1];
                    this.req_seqn[n] = this.req_seqn[n + 1];
                    this.resp_type[n] = this.resp_type[n + 1];
                    this.resp_offset[n] = this.resp_offset[n + 1];
                    this.resp_data[n] = this.resp_data[n + 1];
                    ++n;
                }
                this.reqs[this.num_requests] = null;
                this.req_seqn[this.num_requests] = 0;
                this.resp_type[this.num_requests] = 0;
                this.resp_offset[this.num_requests] = 0;
                this.resp_data[this.num_requests] = null;
                return;
            }
            ++n;
        }
        String string = ErrorMsgs.getMessage(10280, null);
        CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
        throw new NO_RESPONSE(string, 10280, completionStatus);
    }

    public void run() {
        if (ORB.diag >= 2) {
            System.out.println("-- Receive thread started for " + this.key);
        }
        if (this.isSecureConnection()) {
            this.socket.completeHandshake();
        }
        while (true) {
            byte[] byArray = new byte[4];
            try {
                this.socket.read(byArray, 0, 4);
                if (byArray[0] == _CORBA.magic[0] && byArray[1] == _CORBA.magic[1] && byArray[2] == _CORBA.magic[2] && byArray[3] == _CORBA.magic[3]) {
                    this._isIIOPConnection = true;
                    if (this.fixed_marshal_buffer == null) {
                        this.fixed_marshal_buffer = IIOPProt.fixed_marshal_buffer;
                        this.fixed_timeout_buffer = IIOPProt.fixed_timeout_buffer;
                        this.fixed_failure_buffer = IIOPProt.fixed_failure_buffer;
                    }
                    if (_CORBA.globIIOPProtocol == null) {
                        _CORBA.globIIOPProtocol = new IIOPProt();
                    }
                    _CORBA.globIIOPProtocol.incomingMessage(this, byArray);
                    continue;
                }
                this._isIIOPConnection = false;
                if (this.fixed_marshal_buffer == null) {
                    this.fixed_marshal_buffer = OrbixProt.fixed_marshal_buffer;
                    this.fixed_timeout_buffer = OrbixProt.fixed_timeout_buffer;
                    this.fixed_failure_buffer = OrbixProt.fixed_failure_buffer;
                }
                if (_CORBA.globOrbixProtocol == null) {
                    _CORBA.globOrbixProtocol = new OrbixProt();
                }
                _CORBA.globOrbixProtocol.incomingMessage(this, byArray);
            }
            catch (Exception exception) {
                this.socketFailure(exception);
                return;
            }
        }
    }

    public void receiveBuffer(byte[] byArray, int n, int n2) {
        try {
            this.socket.read(byArray, n, n2);
            return;
        }
        catch (IOException iOException) {
            this.socketFailure(iOException);
            return;
        }
    }

    public byte[] doOutgoingTransformer(byte[] byArray, IntHolder intHolder, Request request) {
        IT_reqTransformer iT_reqTransformer = ORB.getTransformer(this.server, this.host);
        boolean bl = true;
        if (iT_reqTransformer == null) {
            bl = false;
        } else if (this.connection_type != 3) {
            if (this.server.equals("IT_daemon")) {
                bl = false;
            } else if (this._isIIOPConnection) {
                if (this.port == Config.get_ORBIXD_IIOP_PORT()) {
                    bl = false;
                }
            } else if (this.port == Config.get_ORBIXD_PORT()) {
                bl = false;
            }
        }
        if (bl) {
            if (!this._isIIOPConnection) {
                octetSeqHolder octetSeqHolder2;
                byte[] byArray2 = new byte[intHolder.value - 4];
                System.arraycopy(byArray, 4, byArray2, 0, intHolder.value - 4);
                if (ORB.diag >= 2) {
                    System.out.println("-- Calling outgoing Orbix Prot. transformer");
                }
                if (!iT_reqTransformer.transform(octetSeqHolder2 = new octetSeqHolder(byArray2), this.host, true, request)) {
                    String string = iT_reqTransformer.transform_error();
                    CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
                    throw new COMM_FAILURE(string, 10097, completionStatus);
                }
                byArray2 = octetSeqHolder2.value;
                byArray = new byte[byArray2.length + 4];
                this.storeIntInArray(byArray, 0, byArray2.length);
                System.arraycopy(byArray2, 0, byArray, 4, byArray2.length);
                intHolder.value = byArray2.length + 4;
            } else {
                octetSeqHolder octetSeqHolder3;
                byte[] byArray3 = new byte[intHolder.value - 12];
                System.arraycopy(byArray, 12, byArray3, 0, intHolder.value - 12);
                if (ORB.diag >= 2) {
                    System.out.println("-- Calling outgoing IIOP transformer");
                }
                if (!iT_reqTransformer.transform(octetSeqHolder3 = new octetSeqHolder(byArray3), this.host, true, request)) {
                    String string = iT_reqTransformer.transform_error();
                    CompletionStatus completionStatus = CompletionStatus.COMPLETED_NO;
                    throw new COMM_FAILURE(string, 10097, completionStatus);
                }
                byArray3 = octetSeqHolder3.value;
                byte[] byArray4 = new byte[byArray3.length + 12];
                System.arraycopy(byArray, 0, byArray4, 0, 12);
                byArray = byArray4;
                this.storeIntInArray(byArray, 8, byArray3.length);
                System.arraycopy(byArray3, 0, byArray, 12, byArray3.length);
                intHolder.value = byArray3.length + 12;
            }
        }
        return byArray;
    }

    public byte[] doIncomingTransformer(byte[] byArray) {
        int n;
        IT_reqTransformer iT_reqTransformer = ORB.getTransformer(this.server, this.host);
        if (iT_reqTransformer == null) {
            return byArray;
        }
        if (this.server.equals("IT_daemon")) {
            return byArray;
        }
        if (this._isIIOPConnection) {
            n = 4;
            if (Config.get_ORBIXD_IIOP_PORT() == this.port) {
                return byArray;
            }
        } else {
            n = 0;
            if (Config.get_ORBIXD_PORT() == this.port) {
                return byArray;
            }
        }
        if (ORB.diag >= 2) {
            System.out.println("-- Calling incoming transformer");
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        octetSeqHolder octetSeqHolder2 = new octetSeqHolder(byArray2);
        boolean bl = iT_reqTransformer.transform(octetSeqHolder2, this.host, false, null);
        byArray2 = octetSeqHolder2.value;
        if (!bl || byArray2.length < 8) {
            byArray = this.fixed_marshal_buffer;
        } else {
            byArray = new byte[byArray2.length + n];
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }
        return byArray;
    }

    public synchronized void cacheMsg(byte[] byArray, int n, int n2, int n3, byte by) {
        int n4 = 0;
        while (n4 < this.num_requests) {
            if (this.req_seqn[n4] == n3 && this.resp_type[n4] == 0) {
                this.resp_type[n4] = n2;
                this.resp_offset[n4] = n;
                this.resp_data[n4] = byArray;
                this.resp_sex[n4] = by;
                this.notifyAll();
                if (!this.policy.equals("per_method")) break;
                this.close();
                return;
            }
            ++n4;
        }
        if (n4 >= this.num_requests && ORB.diag >= 4) {
            System.out.println("-- No request for response.  Ignoring it.");
        }
    }

    protected synchronized void socketFailure(Exception exception) {
        this.connection_failed = true;
        int n = 0;
        while (n < this.num_requests) {
            if (this.resp_type[n] == 0) {
                this.resp_type[n] = 2;
                this.resp_data[n] = this.fixed_failure_buffer;
            }
            ++n;
        }
        this.close();
        this.notifyAll();
    }

    private synchronized void storeIntInArray(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    private int getIntFromArray(byte[] byArray, int n) {
        int n2 = byArray[n] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
        return n2;
    }

    protected int genSeqn() {
        return ++this.seqn;
    }

    public Object getConnectionObject() {
        return this.socket.getConnectionObject();
    }

    protected void finalize() {
        if (!this.is_open) {
            return;
        }
        if (ORB.diag >= 1) {
            System.out.println("[ End of Connection (" + this.host + "," + this.server + "," + this.remote_user + ",pid=" + this.remote_pid + ") ]");
        }
        if (_CORBA.connection_callback != null) {
            _CORBA.connection_callback.CloseCallBack(this.server, this.getConnectionObject());
        }
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception exception) {}
        try {
            if (this.recv_thread != Thread.currentThread()) {
                this.recv_thread.stop();
            }
            this.recv_thread = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected static boolean initIiopProxyRef() {
        if (iiopProxyRef != null) {
            return true;
        }
        try {
            if (Config.get_IIOP_PROXY_HOST() == null || Config.get_IIOP_PROXY_PORT() == 0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        String string = Config.get_IIOP_PROXY_HOST();
        if (string.indexOf(".") <= 0 && !Config.get_LOCAL_DOMAIN().equals("")) {
            string = String.valueOf(string) + "." + Config.get_LOCAL_DOMAIN();
        }
        try {
            int n = Config.get_IIOP_PROXY_PORT();
            iiopProxyRef = (BaseObject)_OrbixWeb.Object(_CORBA.Orbix.string_to_object(InitService.makeIOR(string, n, string, "IIOPProxy", "", "IDL:IIOPProxy:1.0")));
        }
        catch (SystemException systemException) {
            if (ORB.diag > 2) {
                System.err.println("failed to create Wonderwall object reference! " + systemException);
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            if (ORB.diag > 2) {
                System.err.println("class cast exception failed! ");
            }
            classCastException.printStackTrace();
            return false;
        }
        iiopProxyKey = String.valueOf(iiopProxyRef._serverKey(0)) + "@" + iiopProxyRef._host() + ":" + ":_iiop_:";
        return true;
    }

    protected static void updateIiopProxyRef(IOR iOR) {
        iiopProxyRef._setIOR(iOR);
        iiopProxyKey = String.valueOf(iiopProxyRef._serverKey(0)) + "@" + iiopProxyRef._host() + ":" + ":_iiop_:";
    }

    public synchronized void enableBiDir() {
        if (!this._fromClient || this._isBiDir || !this.is_open) {
            return;
        }
        this.key = "bidir:" + _biDirKey++;
        _CORBA.Orbix.connect_table.enterConnection(this);
        this._isBiDir = true;
    }

    protected boolean isSecureConnection() {
        return false;
    }

    protected boolean authenticationFailed() {
        return this.socket.authenticationFailed();
    }

    public int getConnectionType() {
        return this.connection_type;
    }

    public static String dumpBuffer(String string, byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        int n3 = n;
        while (n3 < n + n2) {
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer(String.valueOf(ClientConnection.toPaddedDec(n3, 4, '0')) + "   ");
            boolean bl = true;
            int n4 = n3;
            while (n4 < n3 + 8) {
                if (n4 >= n2) {
                    bl = false;
                    break;
                }
                int n5 = n4;
                while (n5 < n4 + 4) {
                    if (n5 >= n2) {
                        bl = false;
                        break;
                    }
                    if (byArray[n5] < 32 || byArray[n5] >= 128) {
                        stringBuffer2.append('.');
                    } else {
                        stringBuffer2.append((char)byArray[n5]);
                    }
                    ++n5;
                }
                stringBuffer3.append(" ");
                int n6 = byArray[n4] >= 0 ? byArray[n4] : 256 + byArray[n4];
                stringBuffer3.append(ClientConnection.toPaddedDec(n6, 4, ' '));
                if (n4 + 1 < n2) {
                    n6 = byArray[n4 + 1] >= 0 ? byArray[n4 + 1] : 256 + byArray[n4 + 1];
                    stringBuffer3.append(ClientConnection.toPaddedDec(n6, 4, ' '));
                    if (n4 + 2 < n2) {
                        n6 = byArray[n4 + 2] >= 0 ? byArray[n4 + 2] : 256 + byArray[n4 + 2];
                        stringBuffer3.append(ClientConnection.toPaddedDec(n6, 4, ' '));
                        if (n4 + 3 < n2) {
                            n6 = byArray[n4 + 3] >= 0 ? byArray[n4 + 3] : 256 + byArray[n4 + 3];
                            stringBuffer3.append(ClientConnection.toPaddedDec(n6, 4, ' '));
                        }
                    }
                }
                n4 += 4;
            }
            while (stringBuffer3.length() < 47) {
                stringBuffer3.append(" ");
            }
            stringBuffer.append(string);
            stringBuffer.append(stringBuffer3.toString());
            stringBuffer.append(stringBuffer2.toString());
            stringBuffer.append("\n");
            n3 += 8;
        }
        return stringBuffer.toString();
    }

    public static String dumpBuffer(byte[] byArray, int n, int n2) {
        return ClientConnection.dumpBuffer("--  dump: ", byArray, n, n2);
    }

    public static String dumpBuffer(byte[] byArray, int n) {
        return ClientConnection.dumpBuffer("--  dump: ", byArray, 0, n);
    }

    public static String dumpBuffer(byte[] byArray) {
        return ClientConnection.dumpBuffer("--  dump: ", byArray, 0, byArray.length);
    }

    private static String toPaddedDec(int n, int n2, char c) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = String.valueOf(c) + string;
        }
        return string;
    }

    private static String toPaddedHex(int n, int n2, char c) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = String.valueOf(c) + string;
        }
        return string;
    }

    static {
        iiopProxyRef = null;
        iiopProxyKey = null;
        lastConnectFailure = null;
    }
}

