/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.Activator;

import IE.Iona.OrbixWeb.Activator.Activator;
import IE.Iona.OrbixWeb.Activator.ArgumentList;
import IE.Iona.OrbixWeb.Activator.ClassLauncher;
import IE.Iona.OrbixWeb.Activator.Constants;
import IE.Iona.OrbixWeb.Activator.DJAuthenticationFilter;
import IE.Iona.OrbixWeb.Activator.DJGuiConsole;
import IE.Iona.OrbixWeb.Activator.DJSecurityManager;
import IE.Iona.OrbixWeb.Activator.DefImplFinder;
import IE.Iona.OrbixWeb.Activator.Environment;
import IE.Iona.OrbixWeb.Activator.IT_daemonImpl;
import IE.Iona.OrbixWeb.Activator.LocatorImpl;
import IE.Iona.OrbixWeb.Activator.ServerLoader;
import IE.Iona.OrbixWeb.Activator.Switch;
import IE.Iona.OrbixWeb.CORBA.BOA;
import IE.Iona.OrbixWeb.CORBA.ErrorMsgs;
import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.Features.Config;
import IE.Iona.OrbixWeb._CORBA;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class orbixd {
    private static final String progName = "orbixdj";
    private Activator activator;
    private String classpath = Config.getConfigItem("IT_DEFAULT_CLASSPATH");
    private String impRepPath = Config.getConfigItem("IT_IMP_REP_PATH");
    private int iiopPort = 1571;
    private int orbixPort = 1570;
    private boolean inProcess = false;
    private boolean guiConsole = false;
    private boolean redirectProcess = false;
    private boolean allowUnregisteredServers = false;
    private static Environment environment = null;

    public static void main(String[] stringArray) {
        Config.setConfigItem("IT_CONNECTION_TIMEOUT", String.valueOf(-1));
        Config.setConfigItem("IT_MULTI_THREADED_SERVER", "true");
        ORB.init(stringArray, null);
        orbixd.setupOrbixdPort();
        new DJAuthenticationFilter();
        orbixd orbixd2 = new orbixd(stringArray);
        orbixd2.setupConsole();
        orbixd2.start();
    }

    public static Environment getEnvironment() {
        return environment;
    }

    private static void checkJavaVersion() {
        String string;
        boolean bl = true;
        try {
            string = System.getProperty("java.version");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n = Constants.toInt(stringTokenizer.nextToken());
            int n2 = Constants.toInt(stringTokenizer.nextToken());
            if (n < 1 || n2 < 1) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            string = ErrorMsgs.getMessage(12812, null);
            System.out.println(string);
            System.exit(1);
        }
    }

    private static void setupOrbixdPort() {
        String string = Config.getConfigItem("IT_ORBIXD_PORT");
        BOA.commsPort = new Integer(string);
    }

    public orbixd(String[] stringArray) {
        Object object;
        String string = Config.getConfigItem("IT_ORBIXD_IIOP_PORT");
        this.iiopPort = Integer.valueOf(string);
        Config.setConfigItem("IT_IIOP_LISTEN_PORT", String.valueOf(this.iiopPort));
        this.orbixPort = BOA.commsPort;
        this.parseArgs(stringArray);
        DefImplFinder defImplFinder = new DefImplFinder(this.impRepPath, this.classpath, this.inProcess, this.redirectProcess);
        defImplFinder.initialise();
        ServerLoader serverLoader = new ServerLoader(true);
        LocatorImpl locatorImpl = new LocatorImpl();
        this.activator = new Activator(defImplFinder, locatorImpl, serverLoader);
        _CORBA.Orbix.Activator(this.activator);
        serverLoader.activator(this.activator);
        if (this.allowUnregisteredServers) {
            object = (IT_daemonImpl)this.activator.IT_daemon();
            ((IT_daemonImpl)object).allowUnregisteredServers();
        }
        if (this.inProcess) {
            object = new DJSecurityManager();
            System.setSecurityManager((SecurityManager)object);
        }
        this.readEnvironment();
    }

    private void readEnvironment() {
        if (this.dataAvailable(System.in)) {
            try {
                environment = new Environment(System.in);
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private boolean dataAvailable(InputStream inputStream) {
        boolean bl = false;
        try {
            if (inputStream.available() != 0) {
                bl = true;
            }
        }
        catch (IOException iOException) {}
        return bl;
    }

    public void start() {
        this.printStartupMessage();
        this.activator.start();
    }

    private void setupConsole() {
        if (!this.guiConsole) {
            return;
        }
        DJGuiConsole dJGuiConsole = new DJGuiConsole(this.activator, "orbixdj Console");
        dJGuiConsole.show();
    }

    private void printStartupMessage() {
        System.out.println("");
        System.out.println("[orbixdj: Server \"IT_daemon\" is now available to the network ]");
        System.out.println("[     Configuration Orbix-TCP/" + this.orbixPort + "," + this.iiopPort + "/Orbix-XDR ]");
    }

    private void printEvalMessage() {
        System.out.println("This is a time-limited evaluation copy - for details on obtaining a full development kit please contact info@iona.com or order direct from http://www.iona.com/webstore/");
    }

    private void parseArgs(String[] stringArray) {
        ArgumentList argumentList = new ArgumentList();
        argumentList.warnOfUnknownParams();
        Switch switch_ = new Switch("-inProcess", false);
        argumentList.addArgument(switch_);
        Switch switch_2 = new Switch("-textConsole", false);
        argumentList.addArgument(switch_2);
        Switch switch_3 = new Switch("-noProcessRedirect", false);
        argumentList.addArgument(switch_3);
        Switch switch_4 = new Switch("-u", false);
        argumentList.addArgument(switch_4);
        Switch switch_5 = new Switch("-V", false);
        argumentList.addArgument(switch_5);
        Switch switch_6 = new Switch("-v", false);
        argumentList.addArgument(switch_6);
        Switch switch_7 = new Switch("-help", false);
        switch_7.addAlternateName("-?");
        argumentList.addArgument(switch_7);
        if (!argumentList.parseArguments(stringArray) || switch_7.isPresent()) {
            argumentList.printUsage(progName);
            System.exit(1);
        }
        if (switch_5.isPresent()) {
            this.printCompleteSetupInfo();
            System.exit(1);
        }
        if (switch_6.isPresent()) {
            this.printSetupInfo();
            System.exit(1);
        }
        this.inProcess = switch_.isPresent();
        this.guiConsole = !switch_2.isPresent();
        this.redirectProcess = !switch_3.isPresent();
        if (switch_4.isPresent()) {
            this.allowUnregisteredServers = true;
            return;
        }
        this.allowUnregisteredServers = false;
    }

    private void printSetupInfo() {
        System.out.println("");
        System.out.println("Java Activator for OrbixWeb Version 3.0 Final");
        System.out.println("");
        this.printSetupInfoLine("Implementation Repository Path", Config.getConfigItem("IT_IMP_REP_PATH"));
        this.printSetupInfoLine("Daemon Port", Config.getConfigItem("IT_ORBIXD_PORT"));
        this.printSetupInfoLine("Daemon IIOP Port", Config.getConfigItem("IT_ORBIXD_IIOP_PORT"));
        this.printSetupInfoLine("Daemon Port Base", Config.getConfigItem("IT_DAEMON_SERVER_BASE"));
        this.printSetupInfoLine("Daemon Port Range", Config.getConfigItem("IT_DAEMON_SERVER_RANGE"));
        this.printSetupInfoLine("Local host", Config.getConfigItem("IT_LOCAL_HOSTNAME"));
        this.printSetupInfoLine("Local domain", Config.getConfigItem("IT_LOCAL_DOMAIN"));
        this.printSetupInfoLine("Java Interpreter", Config.getConfigItem("IT_JAVA_INTERPRETER"));
        this.printSetupInfoLine("Default Classpath", Config.getConfigItem("IT_DEFAULT_CLASSPATH"));
    }

    private void printSetupInfoLine(String string, String string2) {
        int n = 35 - string.length();
        if (string2 == null) {
            string2 = "";
        }
        System.out.println(String.valueOf(string) + this.padding(n) + ": " + string2);
    }

    private String padding(int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = 32;
            ++n2;
        }
        return new String(byArray);
    }

    private void printCompleteSetupInfo() {
        System.out.println("");
        System.out.println("Java Activator for OrbixWeb Version 3.0 Final");
        System.out.println("");
        String string = ClassLauncher.searchClassPath("OrbixWeb.properties");
        if (string == null) {
            string = "(unknown)";
        }
        this.printSetupInfoLine("OrbixWeb Properties File", string);
        this.printSetupInfoLine("Diagnostic level", Config.getConfigItem("setDiagnostics"));
        this.printSetupInfoLine("IT_PING_USING_IIOP", Config.getConfigItem("IT_PING_USING_IIOP"));
        this.printSetupInfoLine("IT_BIND_USING_IIOP", Config.getConfigItem("IT_BIND_USING_IIOP"));
        this.printSetupInfoLine("IT_ORBIXD_PORT", Config.getConfigItem("IT_ORBIXD_PORT"));
        this.printSetupInfoLine("IT_ORBIXD_IIOP_PORT", Config.getConfigItem("IT_ORBIXD_IIOP_PORT"));
        this.printSetupInfoLine("IT_IIOP_LISTEN_PORT", Config.getConfigItem("IT_IIOP_LISTEN_PORT"));
        this.printSetupInfoLine("IT_SSL_IIOP_LISTEN_PORT", Config.getConfigItem("IT_SSL_IIOP_LISTEN_PORT"));
        this.printSetupInfoLine("IT_IIOP_USE_LOCATOR", Config.getConfigItem("IT_IIOP_USE_LOCATOR"));
        this.printSetupInfoLine("IT_KEEP_ALIVE_FORWARDER_CONN", Config.getConfigItem("IT_KEEP_ALIVE_FORWARDER_CONN"));
        this.printSetupInfoLine("IT_LOCATE_ATTEMPTS", Config.getConfigItem("IT_LOCATE_ATTEMPTS"));
        this.printSetupInfoLine("IT_LOCATOR_HOPS", Config.getConfigItem("IT_LOCATOR_HOPS"));
        this.printSetupInfoLine("pingDuringBind", Config.getConfigItem("pingDuringBind"));
        this.printSetupInfoLine("IT_OBJECT_TABLE_SIZE", Config.getConfigItem("IT_OBJECT_TABLE_SIZE"));
        this.printSetupInfoLine("IT_LISTENER_PRIORITY", Config.getConfigItem("IT_LISTENER_PRIORITY"));
        this.printSetupInfoLine("IT_READER_PRIORITY", Config.getConfigItem("IT_READER_PRIORITY"));
        this.printSetupInfoLine("IT_BUFFER_SIZE", Config.getConfigItem("IT_BUFFER_SIZE"));
        this.printSetupInfoLine("IT_REQ_CACHE_SIZE", Config.getConfigItem("IT_REQ_CACHE_SIZE"));
        this.printSetupInfoLine("IT_NS_HOSTNAME", Config.getConfigItem("IT_NS_HOSTNAME"));
        this.printSetupInfoLine("IT_NS_PORT", Config.getConfigItem("IT_NS_PORT"));
        this.printSetupInfoLine("IT_NS_IP_ADDR", Config.getConfigItem("IT_NS_IP_ADDR"));
        this.printSetupInfoLine("IT_TRADING_SERVER", Config.getConfigItem("IT_TRADING_SERVER"));
        this.printSetupInfoLine("IT_ACCEPT_CONNECTIONS", Config.getConfigItem("IT_ACCEPT_CONNECTIONS"));
        this.printSetupInfoLine("IT_CONNECTION_TIMEOUT", Config.getConfigItem("IT_CONNECTION_TIMEOUT"));
        this.printSetupInfoLine("IT_ANY_BUFFER_SIZE", Config.getConfigItem("IT_ANY_BUFFER_SIZE"));
        this.printSetupInfoLine("IT_IORS_USE_DNS", Config.getConfigItem("IT_IORS_USE_DNS"));
        this.printSetupInfoLine("IT_OBJECT_TABLE_LOAD_FACTOR", Config.getConfigItem("IT_OBJECT_TABLE_LOAD_FACTOR"));
        this.printSetupInfoLine("IT_ALWAYS_CHECK_LOCAL_OBJS", Config.getConfigItem("IT_ALWAYS_CHECK_LOCAL_OBJS"));
        this.printSetupInfoLine("IT_CLASSPATH_SWITCH", Config.getConfigItem("IT_CLASSPATH_SWITCH"));
        this.printSetupInfoLine("IT_JAVA_COMPILER", Config.getConfigItem("IT_JAVA_COMPILER"));
        this.printSetupInfoLine("IT_JAVA_INTERPRETER", Config.getConfigItem("IT_JAVA_INTERPRETER"));
        this.printSetupInfoLine("IT_DAEMON_SERVER_BASE", Config.getConfigItem("IT_DAEMON_SERVER_BASE"));
        this.printSetupInfoLine("IT_DAEMON_SERVER_RANGE", Config.getConfigItem("IT_DAEMON_SERVER_RANGE"));
        this.printSetupInfoLine("IT_IMPL_IS_READY_TIMEOUT", Config.getConfigItem("IT_IMPL_IS_READY_TIMEOUT"));
        this.printSetupInfoLine("IT_DEFAULT_CLASSPATH", Config.getConfigItem("IT_DEFAULT_CLASSPATH"));
        this.printSetupInfoLine("IT_IMP_REP_PATH", Config.getConfigItem("IT_IMP_REP_PATH"));
        this.printSetupInfoLine("IT_IMPL_READY_IF_CONNECTED", Config.getConfigItem("IT_IMPL_READY_IF_CONNECTED"));
        this.printSetupInfoLine("IT_CONNECT_TABLE_SIZE_DEFAULT", Config.getConfigItem("IT_CONNECT_TABLE_SIZE_DEFAULT"));
        this.printSetupInfoLine("IT_DETECT_APPLET_SANDBOX", Config.getConfigItem("IT_DETECT_APPLET_SANDBOX"));
        this.printSetupInfoLine("IT_DII_COPY_ARGS", Config.getConfigItem("IT_DII_COPY_ARGS"));
        this.printSetupInfoLine("IT_DSI_COPY_ARGS", Config.getConfigItem("IT_DSI_COPY_ARGS"));
        this.printSetupInfoLine("IT_HTTP_TUNNEL_HOST", Config.getConfigItem("IT_HTTP_TUNNEL_HOST"));
        this.printSetupInfoLine("IT_HTTP_TUNNEL_PORT", Config.getConfigItem("IT_HTTP_TUNNEL_PORT"));
        this.printSetupInfoLine("IT_HTTP_TUNNEL_PROTO", Config.getConfigItem("IT_HTTP_TUNNEL_PROTO"));
        this.printSetupInfoLine("IT_HTTP_TUNNEL_PREFERRED", Config.getConfigItem("IT_HTTP_TUNNEL_PREFERRED"));
        this.printSetupInfoLine("IT_IIOP_PROXY_HOST", Config.getConfigItem("IT_IIOP_PROXY_HOST"));
        this.printSetupInfoLine("IT_IIOP_PROXY_PORT", Config.getConfigItem("IT_IIOP_PROXY_PORT"));
        this.printSetupInfoLine("IT_IIOP_PROXY_PREFERRED", Config.getConfigItem("IT_IIOP_PROXY_PREFERRED"));
        this.printSetupInfoLine("IT_INITIAL_REFERENCES", Config.getConfigItem("IT_INITIAL_REFERENCES"));
        this.printSetupInfoLine("IT_LOCAL_HOSTNAME", Config.getConfigItem("IT_LOCAL_HOSTNAME"));
        this.printSetupInfoLine("IT_LOCAL_DOMAIN", Config.getConfigItem("IT_LOCAL_DOMAIN"));
        this.printSetupInfoLine("IT_MULTI_THREADED_SERVER", Config.getConfigItem("IT_MULTI_THREADED_SERVER"));
        this.printSetupInfoLine("IT_NON_COPYING_ANYS", Config.getConfigItem("IT_NON_COPYING_ANYS"));
        this.printSetupInfoLine("IT_OBJECT_CONNECT_TIMEOUT", Config.getConfigItem("IT_OBJECT_CONNECT_TIMEOUT"));
        this.printSetupInfoLine("IT_SECURITY_AUTHENTICATE_CLIENTS", Config.getConfigItem("IT_SECURITY_AUTHENTICATE_CLIENTS"));
        this.printSetupInfoLine("IT_SECURITY_DEFAULT_ENTITY", Config.getConfigItem("IT_SECURITY_DEFAULT_ENTITY"));
        this.printSetupInfoLine("IT_USE_BIDIR_IIOP", Config.getConfigItem("IT_USE_BIDIR_IIOP"));
        this.printSetupInfoLine("IT_USE_EXTENDED_CAPABILITIES", Config.getConfigItem("IT_USE_EXTENDED_CAPABILITIES"));
        this.printSetupInfoLine("IT_NAMES_HASH_TABLE_LOAD_FACTOR", Config.getConfigItem("IT_NAMES_HASH_TABLE_LOAD_FACTOR"));
        this.printSetupInfoLine("IT_NAMES_HASH_TABLE_SIZE", Config.getConfigItem("IT_NAMES_HASH_TABLE_SIZE"));
        this.printSetupInfoLine("IT_NAMES_REPOSITORY_PATH", Config.getConfigItem("IT_NAMES_REPOSITORY_PATH"));
        this.printSetupInfoLine("IT_NAMES_SERVER", Config.getConfigItem("IT_NAMES_SERVER"));
        this.printSetupInfoLine("IT_NAMES_TIMEOUT", Config.getConfigItem("IT_NAMES_TIMEOUT"));
    }

    public static boolean isEvaluationLicense() {
        return false;
    }
}

