/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.Activator;

import IE.Iona.OrbixWeb.Activator.ActiveServer;
import IE.Iona.OrbixWeb.Activator.AutomaticServer;
import IE.Iona.OrbixWeb.Activator.DJException;
import IE.Iona.OrbixWeb.Activator.DJStringTokenizer;
import IE.Iona.OrbixWeb.Activator.DefActiveServer;
import IE.Iona.OrbixWeb.Activator.DefImplFinder;
import IE.Iona.OrbixWeb.Activator.DefServerManager;
import IE.Iona.OrbixWeb.Activator.Environment;
import IE.Iona.OrbixWeb.Activator.LaunchArguments;
import IE.Iona.OrbixWeb.Activator.LaunchRecord;
import IE.Iona.OrbixWeb.Activator.LaunchTable;
import IE.Iona.OrbixWeb.Activator.StreamRedirector;
import IE.Iona.OrbixWeb.Activator.orbixd;
import IE.Iona.OrbixWeb.CORBA.ErrorMsgs;
import IE.Iona.OrbixWeb.CORBA.NVList;
import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.Features.Config;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.util.Vector;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public class ProcessManager
extends DefServerManager {
    private static final String IFR_SERVERNAME = "IFR";
    private static final String IFR_EXE_NAME = "ifr";
    private boolean redirectProcess = false;
    static int curr_port = Integer.valueOf(Config.getConfigItem("IT_DAEMON_SERVER_BASE"));
    static int max_retries = Integer.valueOf(Config.getConfigItem("IT_DAEMON_SERVER_RANGE"));

    public ProcessManager(String string, NVList nVList, DefImplFinder defImplFinder, boolean bl) {
        super(string, nVList, defImplFinder);
        this.redirectProcess = bl;
    }

    protected ActiveServer loadNewServer(LaunchRecord launchRecord, String string, String string2, String string3, String string4) throws SystemException {
        Object object;
        boolean bl = false;
        if (!string4.startsWith("###ORBIXWEB###")) {
            bl = true;
        }
        launchRecord.orbix_port = launchRecord.iiop_port = ProcessManager.allocateServerPort();
        String string5 = LaunchTable.getLaunchKey(string, "*", null);
        DefImplFinder.launchedServers.add(string5, launchRecord);
        try {
            object = null;
            object = bl ? this.launchNativeExecutable(string, string2, string3, string4, launchRecord) : this.launchJavaExecutable(string, string2, string3, string4, launchRecord);
            if (this.redirectProcess) {
                this.redirectProcessOutput((Process)object);
            } else if (File.separatorChar == '\\') {
                this.redirectProcessOutputToNull((Process)object);
            }
            AutomaticServer automaticServer = new AutomaticServer((Process)object, launchRecord);
            launchRecord.connect();
            launchRecord.serverReady();
            automaticServer.start();
        }
        catch (Exception exception) {
            DefImplFinder.launchedServers.remove(string5);
            if (ORB.diag >= 16) {
                System.out.println(exception.toString());
                exception.printStackTrace();
            }
            throw new BAD_OPERATION(12002, CompletionStatus.COMPLETED_NO);
        }
        object = new DefActiveServer(string2, launchRecord.user_name, launchRecord);
        return object;
    }

    private Process launchJavaExecutable(String string, String string2, String string3, String string4, LaunchRecord launchRecord) throws IOException {
        LaunchArguments launchArguments = new LaunchArguments(string4);
        String[] stringArray = this.commandLine(launchArguments, launchRecord);
        if (ORB.diag >= 1) {
            System.out.println("Launching a server with the following:");
            this.printArray(stringArray);
            System.out.println("");
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(stringArray);
        return process;
    }

    private Process launchNativeExecutable(String string, String string2, String string3, String string4, LaunchRecord launchRecord) throws IOException {
        String[] stringArray = this.createNativeCommandLine(string4);
        String[] stringArray2 = this.createEnvironment(launchRecord);
        if (ORB.diag >= 2) {
            System.out.println("Launching a server with the following:");
            this.printArray(stringArray);
            System.out.println("");
            System.out.println("Using the following environment: ");
            this.printArray(stringArray2);
            System.out.println("");
        }
        Runtime runtime = Runtime.getRuntime();
        System.out.println("About to exec");
        Process process = runtime.exec(stringArray, stringArray2);
        System.out.println("Finished  exec");
        return process;
    }

    private String[] createNativeCommandLine(String string) {
        DJStringTokenizer dJStringTokenizer = new DJStringTokenizer(string);
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (dJStringTokenizer.hasMoreTokens()) {
            if (File.separatorChar == '\\') {
                vector.addElement(ProcessManager.quote(dJStringTokenizer.nextToken()));
            } else {
                vector.addElement(dJStringTokenizer.nextToken());
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String[] createEnvironment(LaunchRecord launchRecord) {
        Vector<String> vector = new Vector<String>(10, 1);
        vector.addElement("IT_SERVER_COMMS=" + launchRecord.comms);
        vector.addElement("IT_SERVER_PORT=" + launchRecord.orbix_port);
        vector.addElement("IT_SERVER_CODE=" + launchRecord.code);
        vector.addElement("IT_SERVER_NAME=" + launchRecord.serverName);
        vector.addElement("IT_SERVER_MARKER=*");
        vector.addElement("IT_MARKER_PATTERN=*");
        vector.addElement("IT_ACT_POLICY=shared_m");
        vector.addElement("IT_IIOP_PORT=" + launchRecord.iiop_port);
        vector.addElement("IT_WELL_KNOWN_PORT=" + Config.get_IIOP_LISTEN_PORT());
        Environment environment = orbixd.getEnvironment();
        if (environment != null) {
            String[] stringArray = environment.toArray();
            Object[] objectArray = new String[stringArray.length + vector.size()];
            vector.copyInto(objectArray);
            System.arraycopy(stringArray, 0, objectArray, vector.size(), stringArray.length);
            return objectArray;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean isIFR(String string, String string2) {
        return string.equals(IFR_SERVERNAME) && string2.indexOf(IFR_EXE_NAME) != -1;
    }

    private void printArray(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            System.out.print(String.valueOf(stringArray[n]) + " ");
            ++n;
        }
    }

    private void redirectProcessOutput(Process process) {
        StreamRedirector streamRedirector = new StreamRedirector(process.getInputStream(), System.out);
        streamRedirector.start();
        StreamRedirector streamRedirector2 = new StreamRedirector(process.getErrorStream(), System.err);
        streamRedirector2.start();
    }

    private void redirectProcessOutputToNull(Process process) {
        PrintStream printStream = new PrintStream(null);
        StreamRedirector streamRedirector = new StreamRedirector(process.getInputStream(), printStream);
        streamRedirector.start();
        StreamRedirector streamRedirector2 = new StreamRedirector(process.getErrorStream(), printStream);
        streamRedirector2.start();
    }

    public final String[] commandLine(LaunchArguments launchArguments, LaunchRecord launchRecord) throws SystemException {
        this.checkPaths(launchArguments);
        String string = null;
        string = launchArguments.getClasspath() != null ? String.valueOf(launchArguments.getClasspath()) + File.pathSeparator + Config.getConfigItem("IT_DEFAULT_CLASSPATH") : Config.getConfigItem("IT_DEFAULT_CLASSPATH");
        String string2 = "-Dorbixweb.env=" + launchRecord.comms + ":" + launchRecord.code + ":" + launchRecord.orbix_port + ":" + launchRecord.serverName + ":" + launchRecord.pid + ":*:" + "*" + ":shared_m::" + Config.get_IIOP_LISTEN_PORT() + ":" + launchRecord.iiop_port;
        Vector<String> vector = new Vector<String>(10, 1);
        vector.addElement(Config.getConfigItem("IT_JAVA_INTERPRETER"));
        vector.addElement("-classpath");
        if (File.separatorChar == '\\') {
            string = ProcessManager.quote(string);
        }
        vector.addElement(string);
        vector.addElement(string2);
        vector.addElement(launchArguments.getClassname());
        String[] stringArray = launchArguments.getArgs();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void checkPaths(LaunchArguments launchArguments) throws SystemException {
        String string;
        Object object;
        String string2 = Config.getConfigItem("IT_JAVA_INTERPRETER");
        if (string2 == null) {
            object = ErrorMsgs.getMessage(12811, null);
            DJException.throw_BAD_PARAM_Exception(12811, (String)object);
        }
        if (!((File)(object = new File(string2))).exists()) {
            string = ErrorMsgs.getMessage(12811, null);
            DJException.throw_BAD_PARAM_Exception(12811, string);
        }
        string = String.valueOf(launchArguments.getClasspath()) + File.pathSeparator + Config.getConfigItem("IT_DEFAULT_CLASSPATH");
        Class clazz = null;
        boolean bl = true;
        try {
            clazz = DefServerManager.findClass(launchArguments.getClassname(), string);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (clazz == null || !bl) {
            String string3 = ErrorMsgs.getMessage(12808, null);
            DJException.throw_BAD_PARAM_Exception(12808, string3);
        }
    }

    public static final synchronized int allocateServerPort() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = Config.getConfigItem("IT_DAEMON_SERVER_BASE");
        n2 = Integer.valueOf(string);
        string = Config.getConfigItem("IT_DAEMON_SERVER_RANGE");
        n3 = Integer.valueOf(string);
        while (true) {
            try {
                if (curr_port > n2 + n3) {
                    curr_port = n2;
                }
                ServerSocket serverSocket = new ServerSocket(curr_port);
                serverSocket.close();
                return curr_port++;
            }
            catch (IOException iOException) {
                ++curr_port;
                if (++n < max_retries) continue;
                throw new COMM_FAILURE(ErrorMsgs.getMessage(10088, "daemon : no free listener port for server"), 10088, CompletionStatus.COMPLETED_NO);
            }
            break;
        }
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static String quote(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(" ") != -1) {
            return "\"" + string + "\"";
        }
        return string;
    }
}

