/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.Activator;

import IE.Iona.OrbixWeb.Activator.HashTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Environment {
    private Hashtable environmentEntries = new HashTable();
    private String[] entriesInArray;
    private boolean arrayValid = false;

    public Environment() {
        this.arrayValid = false;
    }

    public Environment(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        if (bufferedReader.ready()) {
            String string = bufferedReader.readLine();
            while (string != null) {
                this.addEntry(string);
                string = bufferedReader.readLine();
            }
        }
    }

    public void addEntry(String string) {
        String string2 = this.getEnvVarName(string);
        String string3 = this.getEnvVarValue(string);
        if (string2 != null) {
            if (string3 == null) {
                string3 = "";
            }
            this.environmentEntries.put(string2, string3);
            this.arrayValid = false;
        }
    }

    public String getEntry(String string) {
        return (String)this.environmentEntries.get(string);
    }

    public String[] toArray() {
        if (!this.arrayValid) {
            this.prepareArrayVersionOfData();
        }
        return this.entriesInArray;
    }

    public int numEntries() {
        return this.environmentEntries.size();
    }

    private void prepareArrayVersionOfData() {
        this.entriesInArray = new String[this.environmentEntries.size()];
        this.copyInto(this.entriesInArray);
        this.arrayValid = true;
    }

    public void copyInto(String[] stringArray) {
        Enumeration enumeration = this.environmentEntries.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.environmentEntries.get(string);
            stringArray[n] = String.valueOf(string) + "=" + string2;
            ++n;
        }
    }

    private String getEnvVarName(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        if (n != -1) {
            try {
                string2 = string.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return string2;
    }

    private String getEnvVarValue(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        if (n != -1) {
            try {
                string2 = string.substring(n + 1);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return string2;
    }
}

